/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.internal.util;

import android.os.Environment;
import android.util.Log;
import java.io.File;

public final class RuntimeSwitchableLogging {
    private static final File MAGIC_FILE = new File(Environment.getExternalStorageDirectory(), "dont_skip_the_muffin");
    private static final long CHECK_INTERVAL = 5000L;
    private static long sLastCheckTime = Long.MIN_VALUE;
    private static boolean sLoggingCache;

    private RuntimeSwitchableLogging() {
    }

    public static void i(String tag, String message) {
        if (RuntimeSwitchableLogging.isLoggingEnabled()) {
            Log.i((String)("*Dynamic*-" + tag), (String)message);
        }
    }

    public static void i(String tag, String message, Exception exception) {
        if (RuntimeSwitchableLogging.isLoggingEnabled()) {
            Log.i((String)("*Dynamic*-" + tag), (String)message, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLoggingEnabled() {
        Class<RuntimeSwitchableLogging> clazz = RuntimeSwitchableLogging.class;
        synchronized (RuntimeSwitchableLogging.class) {
            if (System.currentTimeMillis() - sLastCheckTime > 5000L) {
                sLoggingCache = MAGIC_FILE.exists();
                sLastCheckTime = System.currentTimeMillis();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sLoggingCache;
        }
    }
}

