/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.CharSequenceReader;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CharSequences {
    public static int indexOf(CharSequence sequence, char c11) {
        return CharSequences.indexOf(sequence, c11, 0);
    }

    public static int indexOf(CharSequence sequence, char c11, int start) {
        for (int i11 = start; i11 < sequence.length(); ++i11) {
            if (sequence.charAt(i11) != c11) continue;
            return i11;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle, int start) {
        int length = haystack.length();
        int needleLength = needle.length();
        if (needleLength <= length && start >= 0) {
            if (needleLength > 0) {
                if (start > length - needleLength) {
                    start = length - needleLength;
                }
                char firstChar = needle.charAt(0);
                while (true) {
                    int i11;
                    if ((i11 = CharSequences.lastIndexOf(haystack, firstChar, start)) == -1) {
                        return -1;
                    }
                    int o12 = i11;
                    int o22 = 0;
                    while (++o22 < needleLength && haystack.charAt(++o12) == needle.charAt(o22)) {
                    }
                    if (o22 == needleLength) {
                        return i11;
                    }
                    start = i11 - 1;
                }
            }
            return start < length ? start : length;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence sequence, char c11) {
        return CharSequences.lastIndexOf(sequence, c11, sequence.length());
    }

    public static int lastIndexOf(CharSequence sequence, int c11, int start) {
        int length = sequence.length();
        if (start >= 0) {
            if (start >= length) {
                start = length - 1;
            }
            for (int i11 = start; i11 >= 0; --i11) {
                if (sequence.charAt(i11) != c11) continue;
                return i11;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle) {
        return CharSequences.lastIndexOf(haystack, needle, haystack.length());
    }

    public static boolean regionMatches(CharSequence sequence, int thisStart, CharSequence string, int start, int length) {
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        if (thisStart < 0 || sequence.length() - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        for (int i11 = 0; i11 < length; ++i11) {
            if (sequence.charAt(thisStart + i11) == string.charAt(start + i11)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence sequence, boolean ignoreCase, int thisStart, CharSequence string, int start, int length) {
        if (!ignoreCase) {
            return CharSequences.regionMatches(sequence, thisStart, string, start, length);
        }
        if (thisStart < 0 || length > sequence.length() - thisStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int end = thisStart + length;
        while (thisStart < end) {
            char c22;
            char c12;
            if ((c12 = sequence.charAt(thisStart++)) == (c22 = string.charAt(start++)) || CharSequences.foldCase(c12) == CharSequences.foldCase(c22)) continue;
            return false;
        }
        return true;
    }

    private static char foldCase(char ch2) {
        if (ch2 < '\u0080') {
            if ('A' <= ch2 && ch2 <= 'Z') {
                return (char)(ch2 + 32);
            }
            return ch2;
        }
        return Character.toLowerCase(Character.toUpperCase(ch2));
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix) {
        return CharSequences.startsWith(sequence, prefix, 0);
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix, int start) {
        int prefixLength;
        int sequenceLength = sequence.length();
        if (sequenceLength < start + (prefixLength = prefix.length())) {
            return false;
        }
        int i11 = start;
        for (int j11 = 0; j11 < prefixLength; ++j11) {
            if (sequence.charAt(i11) != prefix.charAt(j11)) {
                return false;
            }
            ++i11;
        }
        return true;
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix, boolean caseSensitive) {
        if (suffix.length() > sequence.length()) {
            return false;
        }
        int suffixLength = suffix.length();
        int sequenceLength = sequence.length();
        int i11 = sequenceLength - suffixLength;
        int j11 = 0;
        while (i11 < sequenceLength) {
            char c22;
            char c12 = sequence.charAt(i11);
            if (c12 != (c22 = suffix.charAt(j11))) {
                if (caseSensitive) {
                    return false;
                }
                if (Character.toLowerCase(c12) != Character.toLowerCase(c22)) {
                    return false;
                }
            }
            ++i11;
            ++j11;
        }
        return true;
    }

    public static boolean containsUpperCase(CharSequence s11) {
        if (s11 != null) {
            int n11 = s11.length();
            for (int i11 = 0; i11 < n11; ++i11) {
                if (!Character.isUpperCase(s11.charAt(i11))) continue;
                return true;
            }
        }
        return false;
    }

    public static int indexOf(CharSequence haystack, CharSequence needle) {
        return CharSequences.indexOf(haystack, needle, 0);
    }

    public static int indexOf(CharSequence haystack, CharSequence needle, int start) {
        int needleLength = needle.length();
        if (needleLength == 0) {
            return start;
        }
        char first = needle.charAt(0);
        if (needleLength == 1) {
            return CharSequences.indexOf(haystack, first, start);
        }
        int max = haystack.length() - needleLength;
        block0: for (int i11 = start; i11 <= max; ++i11) {
            if (haystack.charAt(i11) != first) continue;
            int h11 = i11 + 1;
            for (int n11 = 1; n11 < needleLength; ++n11) {
                if (haystack.charAt(h11) != needle.charAt(n11)) continue block0;
                ++h11;
            }
            return i11;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence where, CharSequence what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i11 = fromIndex; i11 <= max; ++i11) {
            if (!CharSequences.charsEqualIgnoreCase(where.charAt(i11), first)) {
                while (++i11 <= max && !CharSequences.charsEqualIgnoreCase(where.charAt(i11), first)) {
                }
            }
            if (i11 > max) continue;
            int j11 = i11 + 1;
            int end = j11 + targetCount - 1;
            int k11 = 1;
            while (j11 < end && CharSequences.charsEqualIgnoreCase(where.charAt(j11), what.charAt(k11))) {
                ++j11;
                ++k11;
            }
            if (j11 != end) continue;
            return i11;
        }
        return -1;
    }

    private static boolean charsEqualIgnoreCase(char c12, char c22) {
        return CharSequences.toUpperCase(c12) == CharSequences.toUpperCase(c22) || CharSequences.toLowerCase(c12) == CharSequences.toLowerCase(c22);
    }

    public static char toUpperCase(char c11) {
        if (c11 < 'a') {
            return c11;
        }
        if (c11 <= 'z') {
            return (char)(c11 + -32);
        }
        return Character.toUpperCase(c11);
    }

    public static char toLowerCase(char c11) {
        if (c11 < 'A' || c11 >= 'a' && c11 <= 'z') {
            return c11;
        }
        if (c11 <= 'Z') {
            return (char)(c11 + 32);
        }
        return Character.toLowerCase(c11);
    }

    public static CharSequence createSequence(char[] data) {
        return new ArrayBackedCharSequence(data);
    }

    public static CharSequence createSequence(char[] data, int offset, int length) {
        return new ArrayBackedCharSequence(data, offset, length);
    }

    public static char[] getCharArray(CharSequence sequence) {
        if (sequence instanceof ArrayBackedCharSequence) {
            return ((ArrayBackedCharSequence)sequence).getCharArray();
        }
        return sequence.toString().toCharArray();
    }

    public static CharSequenceReader getReader(CharSequence data, boolean stripBom) {
        CharSequenceReader reader = new CharSequenceReader(data);
        if (stripBom && data.length() > 0 && data.charAt(0) == '\ufeff') {
            reader.read();
        }
        return reader;
    }

    public static Document parseDocumentSilently(CharSequence xml, boolean namespaceAware) {
        try {
            CharSequenceReader reader = CharSequences.getReader(xml, true);
            return XmlUtils.parseDocument(reader, namespaceAware);
        }
        catch (IOException | SAXException exception) {
            return null;
        }
    }

    public static InputStream getInputStream(CharSequence text) {
        return new ByteArrayInputStream(text.toString().getBytes(Charsets.UTF_8));
    }

    private static class ArrayBackedCharSequence
    implements CharSequence {
        public final char[] data;
        private final int offset;
        private final int length;

        public ArrayBackedCharSequence(char[] data) {
            this(data, 0, data.length);
        }

        public ArrayBackedCharSequence(char[] data, int offset, int length) {
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public char[] getCharArray() {
            if (this.offset == 0 && this.length == this.data.length) {
                return this.data;
            }
            return Arrays.copyOfRange(this.data, this.offset, this.offset + this.length);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.data[this.offset + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ArrayBackedCharSequence(this.data, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            return new String(this.data, this.offset, this.length);
        }
    }
}

