/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;

public abstract class ApkSerializer {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final ApkListener apkListener;
    private final boolean verbose;

    ApkSerializer(Optional<ApkListener> apkListener, boolean verbose) {
        this.apkListener = apkListener.orElse(ApkListener.NO_OP);
        this.verbose = verbose;
    }

    public Commands.ApkDescription serialize(Path apkPath, ModuleSplit moduleSplit) {
        return this.serialize(apkPath.getParent(), apkPath.getFileName().toString(), moduleSplit);
    }

    public Commands.ApkDescription serialize(Path outputDirectory, String apkRelativePath, ModuleSplit moduleSplit) {
        ZipPath relativePath = ZipPath.create(apkRelativePath);
        return this.serialize(outputDirectory, ImmutableMap.of(relativePath, moduleSplit)).get(relativePath);
    }

    public abstract ImmutableMap<ZipPath, Commands.ApkDescription> serialize(Path var1, ImmutableMap<ZipPath, ModuleSplit> var2);

    protected void notifyApkSerialized(Commands.ApkDescription apkDescription, ModuleSplit.SplitType splitType) {
        this.apkListener.onApkFinalized(apkDescription);
        if (this.verbose) {
            System.out.printf("INFO: [%s] '%s' of type '%s' was written to disk.%n", new Object[]{LocalDateTime.now(ZoneId.systemDefault()).format(DATE_FORMATTER), apkDescription.getPath(), splitType});
        }
    }
}

