/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import sun.misc.Unsafe;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class Striped64
extends Number {
    static final ThreadLocal<int @Nullable []> threadHashCode = new ThreadLocal();
    static final Random rng = new Random();
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    @CheckForNull
    volatile transient Cell[] cells;
    volatile transient long base;
    volatile transient int busy;
    private static final Unsafe UNSAFE;
    private static final long baseOffset;
    private static final long busyOffset;

    Striped64() {
    }

    final boolean casBase(long cmp, long val) {
        return UNSAFE.compareAndSwapLong(this, baseOffset, cmp, val);
    }

    final boolean casBusy() {
        return UNSAFE.compareAndSwapInt(this, busyOffset, 0, 1);
    }

    abstract long fn(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void retryUpdate(long x11, @CheckForNull int[] hc2, boolean wasUncontended) {
        int h11;
        if (hc2 == null) {
            hc2 = new int[1];
            threadHashCode.set(hc2);
            int r11 = rng.nextInt();
            hc2[0] = r11 == 0 ? 1 : r11;
            h11 = hc2[0];
        } else {
            h11 = hc2[0];
        }
        boolean collide = false;
        while (true) {
            long v11;
            int n11;
            Cell[] as2 = this.cells;
            if (this.cells != null && (n11 = as2.length) > 0) {
                Cell a11 = as2[n11 - 1 & h11];
                if (a11 == null) {
                    if (this.busy == 0) {
                        Cell r12 = new Cell(x11);
                        if (this.busy == 0 && this.casBusy()) {
                            boolean created = false;
                            try {
                                int j11;
                                int m11;
                                Cell[] rs2 = this.cells;
                                if (this.cells != null && (m11 = rs2.length) > 0 && rs2[j11 = m11 - 1 & h11] == null) {
                                    rs2[j11] = r12;
                                    created = true;
                                }
                            }
                            finally {
                                this.busy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v11 = a11.value;
                    if (a11.cas(v11, this.fn(v11, x11))) return;
                    if (n11 >= NCPU || this.cells != as2) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.busy == 0 && this.casBusy()) {
                        try {
                            if (this.cells == as2) {
                                Cell[] rs3 = new Cell[n11 << 1];
                                for (int i11 = 0; i11 < n11; ++i11) {
                                    rs3[i11] = as2[i11];
                                }
                                this.cells = rs3;
                            }
                        }
                        finally {
                            this.busy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h11 ^= h11 << 13;
                h11 ^= h11 >>> 17;
                h11 ^= h11 << 5;
                hc2[0] = h11;
                continue;
            }
            if (this.busy == 0 && this.cells == as2 && this.casBusy()) {
                boolean init = false;
                try {
                    if (this.cells == as2) {
                        Cell[] rs4 = new Cell[2];
                        rs4[h11 & 1] = new Cell(x11);
                        this.cells = rs4;
                        init = true;
                    }
                }
                finally {
                    this.busy = 0;
                }
                if (!init) continue;
                return;
            }
            v11 = this.base;
            if (this.casBase(v11, this.fn(v11, x11))) return;
        }
    }

    final void internalReset(long initialValue) {
        Cell[] as2 = this.cells;
        this.base = initialValue;
        if (as2 != null) {
            for (Cell a11 : as2) {
                if (a11 == null) continue;
                a11.value = initialValue;
            }
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k11 = Unsafe.class;
                        for (Field f11 : k11.getDeclaredFields()) {
                            f11.setAccessible(true);
                            Object x11 = f11.get(null);
                            if (!k11.isInstance(x11)) continue;
                            return (Unsafe)k11.cast(x11);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e11) {
                throw new RuntimeException("Could not initialize intrinsics", e11.getCause());
            }
        }
    }

    static {
        try {
            UNSAFE = Striped64.getUnsafe();
            Class<Striped64> sk2 = Striped64.class;
            baseOffset = UNSAFE.objectFieldOffset(sk2.getDeclaredField("base"));
            busyOffset = UNSAFE.objectFieldOffset(sk2.getDeclaredField("busy"));
        }
        catch (Exception e11) {
            throw new Error(e11);
        }
    }

    static final class Cell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;
        private static final Unsafe UNSAFE;
        private static final long valueOffset;

        Cell(long x11) {
            this.value = x11;
        }

        final boolean cas(long cmp, long val) {
            return UNSAFE.compareAndSwapLong(this, valueOffset, cmp, val);
        }

        static {
            try {
                UNSAFE = Striped64.getUnsafe();
                Class<Cell> ak2 = Cell.class;
                valueOffset = UNSAFE.objectFieldOffset(ak2.getDeclaredField("value"));
            }
            catch (Exception e11) {
                throw new Error(e11);
            }
        }
    }
}

