/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.renpy.android;
/**
 * This class demonstrates the minimal client implementation of the
 * DownloaderService from the Downloader library.
 */
public class DownloaderService extends com.google.android.vending.expansion.downloader.impl.DownloaderService {
    // stuff for LVL -- MODIFY FOR YOUR APPLICATION!
    private static final String BASE64_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnuEWAcDOIVnMiE+21oKAG2SJ0F150eAioAqtjAoGViBzu0cMiJBvJG/O6ji57BytiVn67qzqOeKjRwl0H0xL1OWyEA3UKo1K80SK242c3agCHxfoMoPwzGfk4BgjzXJ7dRZTjbYaw4tHwhoRxCxjEDow0xgvhwphyyoFSGBNExdSLY/bKLjxjWzgN9hN4Ot3eYLcv+rjvVnRDLHKhrFOWKgvUqDrYCAL1Wok+fXSKK/ZE25Exx79KJ1PXSCTv9bn8vtB6n1xjLg7UYMzimZwmbP03uGL3W+zKtbq+Fk/LMY8YO7pjyk/Gz9DZZvcMdTARDntQF8sD0tWrwlaLhIxawIDAQAB";
    // used by the preference obfuscater
    private static final byte[] SALT = new byte[] {
            1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
    };

    /**
     * This public key comes from your Android Market publisher account, and it
     * used by the LVL to validate responses from Market on your behalf.
     */
    @Override
    public String getPublicKey() {
        return BASE64_PUBLIC_KEY;
    }

    /**
     * This is used by the preference obfuscater to make sure that your
     * obfuscated preferences are different than the ones used by other
     * applications.
     */
    @Override
    public byte[] getSALT() {
        return SALT;
    }

    /**
     * Fill this in with the class name for your alarm receiver. We do this
     * because receivers must be unique across all of Android (it's a good idea
     * to make sure that your receiver is in your unique package)
     */
    @Override
    public String getAlarmReceiverClassName() {
        return DownloaderAlarmReceiver.class.getName();
    }

}
