/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;

public class ResourceTableValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        Resources.ResourceTable resourceTable = module.getResourceTable().orElse(Resources.ResourceTable.getDefaultInstance());
        String moduleName = module.getName().getName();
        ImmutableSet resFiles = module.findEntriesUnderPath(BundleModule.RESOURCES_DIRECTORY).map(ModuleEntry::getPath).collect(ImmutableSet.toImmutableSet());
        if (!resFiles.isEmpty() && !module.getResourceTable().isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("Module '%s' contains resource files but is missing a resource table.", moduleName).build();
        }
        ImmutableSet<ZipPath> referencedFiles = ResourcesUtils.getAllFileReferences(resourceTable);
        for (ZipPath referencedFile : referencedFiles) {
            if (referencedFile.startsWith(BundleModule.RESOURCES_DIRECTORY)) continue;
            throw InvalidBundleException.builder().withUserMessage("Resource table of module '%s' references file '%s' outside of the '%s/' directory.", moduleName, referencedFile, BundleModule.RESOURCES_DIRECTORY).build();
        }
        ImmutableSet nonReferencedFiles = ImmutableSet.copyOf(Sets.difference(resFiles, referencedFiles));
        if (!nonReferencedFiles.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Module '%s' contains resource files that are not referenced from the resource table: %s", moduleName, nonReferencedFiles).build();
        }
        ImmutableSet<ZipPath> nonExistingFiles = ImmutableSet.copyOf(Sets.difference(referencedFiles, resFiles));
        if (!nonExistingFiles.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Resource table of module '%s' contains references to non-existing files: %s", moduleName, nonExistingFiles).build();
        }
    }

    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        if (!BundleValidationUtils.isAssetOnlyBundle(modules)) {
            this.checkResourceIds(modules);
        }
    }

    @VisibleForTesting
    void checkResourceIds(ImmutableList<BundleModule> modules) {
        BundleModule baseModule = BundleValidationUtils.expectBaseModule(modules);
        if (baseModule.getAndroidManifest().getIsolatedSplits().orElse(false).booleanValue()) {
            ImmutableList<BundleModule> modulesIncludedInFusing = modules.stream().filter(BundleModule::isIncludedInFusing).collect(ImmutableList.toImmutableList());
            ResourceTableValidator.checkResourceIdsAreUnique(modulesIncludedInFusing);
            for (BundleModule module : modules) {
                if (module.isIncludedInFusing()) continue;
                ResourceTableValidator.checkResourceIdsAreUnique(ImmutableList.of(module));
            }
        } else {
            ResourceTableValidator.checkResourceIdsAreUnique(modules);
        }
    }

    private static void checkResourceIdsAreUnique(ImmutableList<BundleModule> modules) {
        HashSet usedResourceIds = Sets.newHashSet();
        for (BundleModule module : modules) {
            Resources.ResourceTable resourceTable = module.getResourceTable().orElse(Resources.ResourceTable.getDefaultInstance());
            ResourcesUtils.entries(resourceTable).forEach(resourceTableEntry -> {
                boolean foundDuplicate;
                boolean bl2 = foundDuplicate = !usedResourceIds.add(resourceTableEntry.getResourceId());
                if (foundDuplicate) {
                    throw InvalidBundleException.builder().withUserMessage("Duplicate resource id (%s).", resourceTableEntry.getResourceId().toString()).build();
                }
            });
        }
    }
}

