/*
 * Decompiled with CFR 0.152.
 */
package org.kxml2.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlpull.v1.XmlSerializer;

public class WbxmlSerializer
implements XmlSerializer {
    Hashtable stringTable = new Hashtable();
    OutputStream out;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    ByteArrayOutputStream stringTableBuf = new ByteArrayOutputStream();
    String pending;
    int depth;
    String name;
    String namespace;
    Vector attributes = new Vector();
    Hashtable attrStartTable = new Hashtable();
    Hashtable attrValueTable = new Hashtable();
    Hashtable tagTable = new Hashtable();
    private int attrPage;
    private int tagPage;
    private String encoding;

    public XmlSerializer attribute(String string, String string2, String string3) {
        this.attributes.addElement(string2);
        this.attributes.addElement(string3);
        return this;
    }

    public void cdsect(String string) throws IOException {
        this.text(string);
    }

    public void comment(String string) {
    }

    public void docdecl(String string) {
        throw new RuntimeException("Cannot write docdecl for WBXML");
    }

    public void entityRef(String string) {
        throw new RuntimeException("EntityReference not supported for WBXML");
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean getFeature(String string) {
        return false;
    }

    public String getNamespace() {
        throw new RuntimeException("NYI");
    }

    public String getName() {
        throw new RuntimeException("NYI");
    }

    public String getPrefix(String string, boolean bl2) {
        throw new RuntimeException("NYI");
    }

    public Object getProperty(String string) {
        return null;
    }

    public void ignorableWhitespace(String string) {
    }

    public void endDocument() throws IOException {
        WbxmlSerializer.writeInt(this.out, this.stringTableBuf.size());
        this.out.write(this.stringTableBuf.toByteArray());
        this.out.write(this.buf.toByteArray());
        this.out.flush();
    }

    public void flush() {
    }

    public void checkPending(boolean bl2) throws IOException {
        if (this.pending == null) {
            return;
        }
        int n11 = this.attributes.size();
        int[] nArray = (int[])this.tagTable.get(this.pending);
        if (nArray == null) {
            this.buf.write(n11 == 0 ? (bl2 ? 4 : 68) : (bl2 ? 132 : 196));
            this.writeStrT(this.pending, false);
        } else {
            if (nArray[0] != this.tagPage) {
                this.tagPage = nArray[0];
                this.buf.write(0);
                this.buf.write(this.tagPage);
            }
            this.buf.write(n11 == 0 ? (bl2 ? nArray[1] : nArray[1] | 0x40) : (bl2 ? nArray[1] | 0x80 : nArray[1] | 0xC0));
        }
        for (int i11 = 0; i11 < n11; ++i11) {
            nArray = (int[])this.attrStartTable.get(this.attributes.elementAt(i11));
            if (nArray == null) {
                this.buf.write(4);
                this.writeStrT((String)this.attributes.elementAt(i11), false);
            } else {
                if (nArray[0] != this.attrPage) {
                    this.attrPage = nArray[0];
                    this.buf.write(0);
                    this.buf.write(this.attrPage);
                }
                this.buf.write(nArray[1]);
            }
            nArray = (int[])this.attrValueTable.get(this.attributes.elementAt(++i11));
            if (nArray == null) {
                this.writeStr((String)this.attributes.elementAt(i11));
                continue;
            }
            if (nArray[0] != this.attrPage) {
                this.attrPage = nArray[0];
                this.buf.write(0);
                this.buf.write(this.attrPage);
            }
            this.buf.write(nArray[1]);
        }
        if (n11 > 0) {
            this.buf.write(1);
        }
        this.pending = null;
        this.attributes.removeAllElements();
    }

    public void processingInstruction(String string) {
        throw new RuntimeException("PI NYI");
    }

    public void setFeature(String string, boolean bl2) {
        throw new IllegalArgumentException("unknown feature " + string);
    }

    public void setOutput(Writer writer) {
        throw new RuntimeException("Wbxml requires an OutputStream!");
    }

    public void setOutput(OutputStream outputStream, String string) throws IOException {
        this.encoding = string == null ? "UTF-8" : string;
        this.out = outputStream;
        this.buf = new ByteArrayOutputStream();
        this.stringTableBuf = new ByteArrayOutputStream();
    }

    public void setPrefix(String string, String string2) {
        throw new RuntimeException("NYI");
    }

    public void setProperty(String string, Object object) {
        throw new IllegalArgumentException("unknown property " + string);
    }

    public void startDocument(String string, Boolean bl2) throws IOException {
        this.out.write(3);
        this.out.write(1);
        if (string != null) {
            this.encoding = string;
        }
        if (this.encoding.toUpperCase().equals("UTF-8")) {
            this.out.write(106);
        } else if (this.encoding.toUpperCase().equals("ISO-8859-1")) {
            this.out.write(4);
        } else {
            throw new UnsupportedEncodingException(string);
        }
    }

    public XmlSerializer startTag(String string, String string2) throws IOException {
        if (string != null && !"".equals(string)) {
            throw new RuntimeException("NSP NYI");
        }
        this.checkPending(false);
        this.pending = string2;
        ++this.depth;
        return this;
    }

    public XmlSerializer text(char[] cArray, int n11, int n12) throws IOException {
        this.checkPending(false);
        this.writeStr(new String(cArray, n11, n12));
        return this;
    }

    public XmlSerializer text(String string) throws IOException {
        this.checkPending(false);
        this.writeStr(string);
        return this;
    }

    private void writeStr(String string) throws IOException {
        int n11 = 0;
        int n12 = 0;
        int n13 = string.length();
        while (n11 < n13) {
            int n14;
            while (n11 < n13 && string.charAt(n11) < 'A') {
                ++n11;
            }
            for (n14 = n11; n14 < n13 && string.charAt(n14) >= 'A'; ++n14) {
            }
            if (n14 - n11 > 10) {
                if (n11 > n12 && string.charAt(n11 - 1) == ' ' && this.stringTable.get(string.substring(n11, n14)) == null) {
                    this.buf.write(131);
                    this.writeStrT(string.substring(n12, n14), false);
                } else {
                    if (n11 > n12 && string.charAt(n11 - 1) == ' ') {
                        --n11;
                    }
                    if (n11 > n12) {
                        this.buf.write(131);
                        this.writeStrT(string.substring(n12, n11), false);
                    }
                    this.buf.write(131);
                    this.writeStrT(string.substring(n11, n14), true);
                }
                n12 = n14;
            }
            n11 = n14;
        }
        if (n12 < n13) {
            this.buf.write(131);
            this.writeStrT(string.substring(n12, n13), false);
        }
    }

    public XmlSerializer endTag(String string, String string2) throws IOException {
        if (this.pending != null) {
            this.checkPending(true);
        } else {
            this.buf.write(1);
        }
        --this.depth;
        return this;
    }

    public void writeWapExtension(int n11, Object object) throws IOException {
        this.checkPending(false);
        this.buf.write(n11);
        switch (n11) {
            case 192: 
            case 193: 
            case 194: {
                break;
            }
            case 195: {
                byte[] byArray = (byte[])object;
                WbxmlSerializer.writeInt(this.buf, byArray.length);
                this.buf.write(byArray);
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                this.writeStrI(this.buf, (String)object);
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                this.writeStrT((String)object, false);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    static void writeInt(OutputStream outputStream, int n11) throws IOException {
        byte[] byArray = new byte[5];
        int n12 = 0;
        do {
            byArray[n12++] = (byte)(n11 & 0x7F);
        } while ((n11 >>= 7) != 0);
        while (n12 > 1) {
            outputStream.write(byArray[--n12] | 0x80);
        }
        outputStream.write(byArray[0]);
    }

    void writeStrI(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes(this.encoding);
        outputStream.write(byArray);
        outputStream.write(0);
    }

    private final void writeStrT(String string, boolean bl2) throws IOException {
        Integer n11 = (Integer)this.stringTable.get(string);
        if (n11 != null) {
            WbxmlSerializer.writeInt(this.buf, n11);
        } else {
            int n12;
            int n13 = this.stringTableBuf.size();
            if (string.charAt(0) >= '0' && bl2) {
                string = ' ' + string;
                WbxmlSerializer.writeInt(this.buf, n13 + 1);
            } else {
                WbxmlSerializer.writeInt(this.buf, n13);
            }
            this.stringTable.put(string, new Integer(n13));
            if (string.charAt(0) == ' ') {
                this.stringTable.put(string.substring(1), new Integer(n13 + 1));
            }
            if ((n12 = string.lastIndexOf(32)) > 1) {
                this.stringTable.put(string.substring(n12), new Integer(n13 + n12));
                this.stringTable.put(string.substring(n12 + 1), new Integer(n13 + n12 + 1));
            }
            this.writeStrI(this.stringTableBuf, string);
            this.stringTableBuf.flush();
        }
    }

    public void setTagTable(int n11, String[] stringArray) {
        for (int i11 = 0; i11 < stringArray.length; ++i11) {
            if (stringArray[i11] == null) continue;
            int[] nArray = new int[]{n11, i11 + 5};
            this.tagTable.put(stringArray[i11], nArray);
        }
    }

    public void setAttrStartTable(int n11, String[] stringArray) {
        for (int i11 = 0; i11 < stringArray.length; ++i11) {
            if (stringArray[i11] == null) continue;
            int[] nArray = new int[]{n11, i11 + 5};
            this.attrStartTable.put(stringArray[i11], nArray);
        }
    }

    public void setAttrValueTable(int n11, String[] stringArray) {
        for (int i11 = 0; i11 < stringArray.length; ++i11) {
            if (stringArray[i11] == null) continue;
            int[] nArray = new int[]{n11, i11 + 133};
            this.attrValueTable.put(stringArray[i11], nArray);
        }
    }
}

