/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.util.StandardUtilities;

public abstract class BufferListSet
implements SearchFileSet {
    private String[] files;

    @Override
    public synchronized String getFirstFile(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[0];
    }

    @Override
    public synchronized String getLastFile(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[this.files.length - 1];
    }

    @Override
    public synchronized String getNextFile(View view, String string) {
        return this.getPrevOrNextFile(view, string, Direction.NEXT);
    }

    @Override
    public synchronized String getPrevFile(View view, String string) {
        return this.getPrevOrNextFile(view, string, Direction.PREV);
    }

    @Override
    public synchronized String[] getFiles(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files;
    }

    @Override
    public synchronized int getFileCount(View view) {
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    @Override
    public String getCode() {
        return null;
    }

    public void invalidateCachedList() {
        this.files = null;
    }

    private String getPrevOrNextFile(View view, String string, Direction direction) {
        boolean bl;
        if (this.files == null) {
            this.files = this._getFiles(view);
        }
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        if (string == null) {
            string = view.getBuffer().getSymlinkPath();
            VFS vFS = VFSManager.getVFSForPath(string);
            boolean bl2 = (vFS.getCapabilities() & 0x80) != 0;
            for (int i = 0; i < this.files.length; ++i) {
                if (StandardUtilities.compareStrings(this.files[i], string, bl2) != 0) continue;
                return string;
            }
            if (direction == Direction.NEXT) {
                return this.getFirstFile(view);
            }
            return this.getLastFile(view);
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        boolean bl3 = bl = (vFS.getCapabilities() & 0x80) != 0;
        if (direction == Direction.NEXT && StandardUtilities.compareStrings(this.files[this.files.length - 1], string, bl) == 0) {
            return null;
        }
        if (direction == Direction.PREV && StandardUtilities.compareStrings(this.files[0], string, bl) == 0) {
            return null;
        }
        for (int i = 0; i < this.files.length - 1; ++i) {
            if (StandardUtilities.compareStrings(this.files[i], string, bl) != 0) continue;
            if (direction == Direction.NEXT) {
                return this.files[i + 1];
            }
            if (i == 0) {
                return this.files[this.files.length - 1];
            }
            return this.files[i - 1];
        }
        return null;
    }

    protected abstract String[] _getFiles(Component var1);

    private static enum Direction {
        PREV,
        NEXT;

    }
}

