/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class FavoritesProvider
implements DynamicMenuProvider {
    @Override
    public boolean updateEveryTime() {
        return false;
    }

    @Override
    public void update(JMenu jMenu) {
        final View view = GUIUtilities.getView(jMenu);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jEdit.openFile(view, actionEvent.getActionCommand());
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VFSBrowser.browseDirectory(view, actionEvent.getActionCommand());
            }
        };
        VFSFile[] vFSFileArray = FavoritesVFS.getFavorites();
        if (vFSFileArray.length == 0) {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.no-favorites.label"));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
        } else {
            Arrays.sort(vFSFileArray, new VFS.DirectoryEntryCompare(jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs"), jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase")));
            for (int i = 0; i < vFSFileArray.length; ++i) {
                FavoritesVFS.Favorite favorite = (FavoritesVFS.Favorite)vFSFileArray[i];
                JMenuItem jMenuItem = new JMenuItem(favorite.getLabel());
                jMenuItem.setActionCommand(favorite.getPath());
                jMenuItem.setIcon(FileCellRenderer.getIconForFile(favorite, false));
                if (favorite.getType() == 0) {
                    jMenuItem.addActionListener(actionListener);
                } else {
                    jMenuItem.addActionListener(actionListener2);
                }
                jMenu.add(jMenuItem);
            }
        }
    }
}

