/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;

public class FavoritesVFS
extends VFS {
    public static final String PROTOCOL = "favorites";
    private static FavoritesVFS instance;
    private static final Object lock;
    private static List<Favorite> favorites;

    public FavoritesVFS() {
        super(PROTOCOL, 344, new String[]{"type"});
        instance = this;
    }

    @Override
    public String getParentOfPath(String string) {
        return "favorites:";
    }

    @Override
    public VFSFile[] _listFiles(Object object, String string, Component component) {
        return FavoritesVFS.getFavorites();
    }

    @Override
    public VFSFile _getFile(Object object, String string, Component component) {
        return new Favorite(string, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean _delete(Object object, String string, Component component) {
        Object object2 = lock;
        synchronized (object2) {
            string = string.substring(PROTOCOL.length() + 1);
            Iterator<Favorite> iterator = favorites.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getPath().equals(string)) continue;
                iterator.remove();
                VFSManager.sendVFSUpdate(this, "favorites:", false);
                EditBus.sendAsync(new DynamicMenuChanged(PROTOCOL));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean _rename(Object object, String string, String string2, Component component) {
        VFSFile[] vFSFileArray = FavoritesVFS.getFavorites();
        for (int i = 0; i < vFSFileArray.length; ++i) {
            Favorite favorite = (Favorite)vFSFileArray[i];
            if (!favorite.getPath().equals(string)) continue;
            favorite.label = string2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFavorites() {
        Object object = lock;
        synchronized (object) {
            String string;
            favorites = new LinkedList<Favorite>();
            int n = 0;
            while ((string = jEdit.getProperty("vfs.favorite." + n)) != null) {
                Favorite favorite = new Favorite(string, jEdit.getIntegerProperty("vfs.favorite." + n + ".type", 1));
                favorites.add(favorite);
                String string2 = jEdit.getProperty("vfs.favorite." + n + ".label");
                if (string2 != null) {
                    favorite.label = string2;
                }
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToFavorites(String string, int n) {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                FavoritesVFS.loadFavorites();
            }
            for (Favorite favorite : favorites) {
                if (!favorite.getPath().equals(string)) continue;
                return;
            }
            favorites.add(new Favorite(string, n));
            VFSManager.sendVFSUpdate(instance, "favorites:", false);
            EditBus.send(new DynamicMenuChanged(PROTOCOL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFavorites() {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                return;
            }
            int n = 0;
            for (Favorite favorite : favorites) {
                String string = favorite.getPath();
                String string2 = favorite.getLabel();
                jEdit.setProperty("vfs.favorite." + n, string);
                if (string.equals(string2) || MiscUtilities.abbreviateView(string).equals(string2)) {
                    jEdit.unsetProperty("vfs.favorite." + n + ".label");
                } else {
                    jEdit.setProperty("vfs.favorite." + n + ".label", string2);
                }
                jEdit.setIntegerProperty("vfs.favorite." + n + ".type", favorite.getType());
                ++n;
            }
            jEdit.unsetProperty("vfs.favorite." + favorites.size());
            jEdit.unsetProperty("vfs.favorite." + favorites.size() + ".type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VFSFile[] getFavorites() {
        Object object = lock;
        synchronized (object) {
            if (favorites == null) {
                FavoritesVFS.loadFavorites();
            }
            return favorites.toArray(new VFSFile[favorites.size()]);
        }
    }

    static {
        lock = new Object();
    }

    public static class Favorite
    extends VFSFile {
        private String label;

        Favorite(String string, int n) {
            super(string, string, "favorites:" + string, n, 0L, false);
            this.label = MiscUtilities.abbreviateView(string);
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public String getExtendedAttribute(String string) {
            if (string.equals("type")) {
                return super.getExtendedAttribute(string);
            }
            return null;
        }

        @Override
        public VFS getVFS() {
            return VFSManager.getVFSForProtocol(FavoritesVFS.PROTOCOL);
        }
    }
}

