/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockablePanel;
import org.gjt.sp.jedit.gui.DockableWindowContainer;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.DockableWindowManagerImpl;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.DockableWindowUpdate;
import org.gjt.sp.util.StandardUtilities;

public class PanelWindowContainer
implements DockableWindowContainer,
DockableWindowManager.DockingArea {
    static final int SPLITTER_WIDTH = 10;
    DockablePanel dockablePanel;
    JPanel buttonPanel;
    private final DockableWindowManagerImpl wm;
    private final String position;
    private final JButton closeBox;
    private final JButton menuBtn;
    private final ButtonGroup buttonGroup;
    private final JToggleButton nullButton;
    private int dimension;
    private final List<DockableWindowManagerImpl.Entry> dockables;
    private final List<AbstractButton> buttons;
    private DockableWindowManagerImpl.Entry current;
    private JPopupMenu popup;
    private String mostRecent;

    public PanelWindowContainer(DockableWindowManagerImpl dockableWindowManagerImpl, String string, int n) {
        this.wm = dockableWindowManagerImpl;
        this.position = string;
        this.buttonPanel = new JPanel(new ButtonLayout());
        this.buttonPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.closeBox = new JButton(GUIUtilities.loadIcon("closebox.gif"));
        this.closeBox.setRequestFocusEnabled(false);
        this.closeBox.setToolTipText(jEdit.getProperty("view.docking.close-tooltip"));
        if (OperatingSystem.isMacOSLF()) {
            this.closeBox.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.closeBox.setMargin(new Insets(0, 0, 0, 0));
        this.closeBox.addActionListener(new ActionHandler());
        this.menuBtn = new JButton(GUIUtilities.loadIcon(jEdit.getProperty("dropdown-arrow.icon")));
        this.menuBtn.setRequestFocusEnabled(false);
        this.menuBtn.setToolTipText(jEdit.getProperty("view.docking.menu-tooltip"));
        if (OperatingSystem.isMacOSLF()) {
            this.menuBtn.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.menuBtn.setMargin(new Insets(0, 0, 0, 0));
        this.menuBtn.addMouseListener(new MenuMouseHandler());
        this.buttonGroup = new ButtonGroup();
        this.nullButton = new JToggleButton();
        this.buttonGroup.add(this.nullButton);
        this.dockables = new ArrayList<DockableWindowManagerImpl.Entry>();
        this.buttons = new ArrayList<AbstractButton>();
        this.dockablePanel = new DockablePanel(this);
        this.dimension = n;
    }

    public DockableWindowManagerImpl getDockableWindowManager() {
        return this.wm;
    }

    @Override
    public void register(DockableWindowManagerImpl.Entry entry) {
        int n;
        this.dockables.add(entry);
        if (this.position.equals("top") || this.position.equals("bottom")) {
            n = 0;
        } else if (this.position.equals("left")) {
            n = 2;
        } else if (this.position.equals("right")) {
            n = 1;
        } else {
            throw new InternalError("Invalid position: " + this.position);
        }
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setMargin(new Insets(1, 1, 1, 1));
        jToggleButton.setRequestFocusEnabled(false);
        jToggleButton.setIcon(new RotatedTextIcon(n, jToggleButton.getFont(), entry.shortTitle()));
        jToggleButton.setActionCommand(entry.factory.name);
        jToggleButton.addActionListener(new ActionHandler());
        jToggleButton.addMouseListener(new MenuMouseHandler());
        if (OperatingSystem.isMacOSLF()) {
            jToggleButton.putClientProperty("JButton.buttonType", "toolbar");
        }
        this.buttonGroup.add(jToggleButton);
        this.buttons.add(jToggleButton);
        entry.btn = jToggleButton;
        this.wm.revalidate();
    }

    @Override
    public void unregister(DockableWindowManagerImpl.Entry entry) {
        if (entry.factory.name.equals(this.mostRecent)) {
            this.mostRecent = null;
        }
        if (entry.btn != null) {
            this.buttonPanel.remove(entry.btn);
            this.buttons.remove(entry.btn);
            entry.btn = null;
        }
        this.dockables.remove(entry);
        if (entry.win != null) {
            this.dockablePanel.remove(entry.win);
        }
        if (this.current == entry) {
            this.current = null;
            this.show(this.current);
        } else {
            this.wm.revalidate();
            this.dockablePanel.repaint();
            this.buttonPanel.repaint();
        }
    }

    @Override
    public void remove(DockableWindowManagerImpl.Entry entry) {
        if (entry.factory.name.equals(this.mostRecent)) {
            this.mostRecent = null;
        }
        if (entry.win != null) {
            this.dockablePanel.remove(entry.win);
            entry.win = null;
        }
        if (this.current == entry) {
            this.current = null;
            this.show(this.current);
        } else {
            this.wm.revalidate();
            this.dockablePanel.repaint();
        }
    }

    @Override
    public void showMostRecent() {
        if (this.dockables.isEmpty()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.mostRecent == null) {
            this.mostRecent = this.dockables.get((int)0).factory.name;
        }
        this.wm.showDockableWindow(this.mostRecent);
    }

    @Override
    public void show(DockableWindowManagerImpl.Entry entry) {
        if (this.current == entry) {
            if (entry != null) {
                if (entry.win instanceof DefaultFocusComponent) {
                    ((DefaultFocusComponent)((Object)entry.win)).focusOnDefaultComponent();
                } else {
                    entry.win.requestDefaultFocus();
                }
            }
            return;
        }
        if (entry != null) {
            if (this.current == null) {
                this.dockablePanel.setBorder(new DockBorder(this.position));
            }
            this.mostRecent = entry.factory.name;
            this.current = entry;
            if (entry.win.getParent() != this.dockablePanel) {
                this.dockablePanel.add(entry.factory.name, entry.win);
            }
            this.dockablePanel.showDockable(entry.factory.name);
            entry.btn.setSelected(true);
            if (entry.win instanceof DefaultFocusComponent) {
                ((DefaultFocusComponent)((Object)entry.win)).focusOnDefaultComponent();
            } else {
                entry.win.requestDefaultFocus();
            }
        } else {
            if (this.current != null) {
                Object object = DockableWindowUpdate.DEACTIVATED;
                EditBus.send(new DockableWindowUpdate(this.wm, object, this.current.factory.name));
            }
            this.current = null;
            this.nullButton.setSelected(true);
            this.dockablePanel.setBorder(null);
            this.wm.getView().getTextArea().requestFocus();
        }
        this.wm.revalidate();
        this.dockablePanel.repaint();
    }

    @Override
    public boolean isVisible(DockableWindowManagerImpl.Entry entry) {
        return this.current == entry;
    }

    @Override
    public String getCurrent() {
        if (this.current == null) {
            return null;
        }
        return this.current.factory.name;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getPosition() {
        return this.position;
    }

    @Override
    public String[] getDockables() {
        String[] stringArray = new String[this.dockables.size()];
        for (int i = 0; i < this.dockables.size(); ++i) {
            DockableWindowManagerImpl.Entry entry = this.dockables.get(i);
            stringArray[i] = entry.factory.name;
        }
        return stringArray;
    }

    void save() {
        jEdit.setIntegerProperty("view.dock." + this.position + ".dimension", this.dimension);
        if (this.current == null) {
            jEdit.unsetProperty("view.dock." + this.position + ".last");
        } else {
            jEdit.setProperty("view.dock." + this.position + ".last", this.current.factory.name);
        }
    }

    void setDimension(int n) {
        if (n > 10) {
            this.dimension = n - 10;
        }
    }

    void sortDockables() {
        this.buttonPanel.removeAll();
        this.buttonPanel.add(this.closeBox);
        this.buttonPanel.add(this.menuBtn);
        Collections.sort(this.buttons, new DockableWindowCompare());
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttonPanel.add(this.buttons.get(i));
        }
    }

    int getWrappedDimension(int n) {
        return ((ButtonLayout)this.buttonPanel.getLayout()).getWrappedDimension(this.buttonPanel, n);
    }

    @Override
    public void show(String string) {
        DockableWindowManagerImpl.Entry entry = null;
        if (string != null) {
            this.wm.showDockableWindow(string);
            this.wm.hideDockableWindow(string);
        }
        this.show(entry);
    }

    class ButtonLayout
    implements LayoutManager {
        ButtonLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        int getWrappedDimension(JComponent jComponent, int n) {
            Insets insets = jComponent.getBorder().getBorderInsets(jComponent);
            Component[] componentArray = jComponent.getComponents();
            if (componentArray.length <= 2) {
                return 0;
            }
            Dimension dimension = componentArray[2].getPreferredSize();
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                int n2 = n - insets.right;
                Dimension dimension2 = this.preferredLayoutSizeLR(insets, componentArray, dimension, n2);
                return dimension2.height;
            }
            Dimension dimension3 = this.preferredLayoutSizeTB(n, insets, componentArray, dimension);
            return dimension3.width;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Insets insets = ((JComponent)container).getBorder().getBorderInsets(container);
            Component[] componentArray = container.getComponents();
            if (componentArray.length <= 2) {
                return new Dimension(0, 0);
            }
            Dimension dimension = componentArray[2].getPreferredSize();
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                int n = container.getWidth() - insets.right;
                Dimension dimension2 = this.preferredLayoutSizeLR(insets, componentArray, dimension, n);
                return dimension2;
            }
            Dimension dimension3 = this.preferredLayoutSizeTB(container.getHeight(), insets, componentArray, dimension);
            return dimension3;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            Insets insets = ((JComponent)container).getBorder().getBorderInsets(container);
            Component[] componentArray = container.getComponents();
            if (componentArray.length <= 2) {
                for (int i = 0; i < componentArray.length; ++i) {
                    componentArray[i].setVisible(false);
                }
                return;
            }
            componentArray[0].setVisible(true);
            componentArray[1].setVisible(true);
            Dimension dimension = componentArray[2].getPreferredSize();
            if (PanelWindowContainer.this.position.equals("top") || PanelWindowContainer.this.position.equals("bottom")) {
                int n = container.getWidth() - insets.right;
                int n2 = Math.max(dimension.height, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().width);
                int n3 = (n2 << 1) + insets.left;
                int n4 = insets.top;
                PanelWindowContainer.this.closeBox.setBounds(insets.left, insets.top, n2, n2);
                PanelWindowContainer.this.menuBtn.setBounds(insets.left + n2, insets.top, n2, n2);
                for (int i = 2; i < componentArray.length; ++i) {
                    int n5 = componentArray[i].getPreferredSize().width;
                    if (n5 + n3 > n) {
                        n3 = insets.left;
                        n4 += n2;
                    }
                    componentArray[i].setBounds(n3, n4, n5, n2);
                    n3 += n5;
                }
            } else {
                int n = container.getHeight() - insets.bottom;
                int n6 = Math.max(dimension.width, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().height);
                int n7 = insets.left;
                int n8 = (n6 << 1) + insets.top;
                PanelWindowContainer.this.closeBox.setBounds(insets.left, insets.top, n6, n6);
                PanelWindowContainer.this.menuBtn.setBounds(insets.left, insets.top + n6, n6, n6);
                for (int i = 2; i < componentArray.length; ++i) {
                    int n9 = componentArray[i].getPreferredSize().height;
                    if (n9 + n8 > n) {
                        n7 += n6;
                        n8 = insets.top;
                    }
                    componentArray[i].setBounds(n7, n8, n6, n9);
                    n8 += n9;
                }
            }
        }

        private Dimension preferredLayoutSizeLR(Insets insets, Component[] componentArray, Dimension dimension, int n) {
            int n2 = Math.max(dimension.height, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().width);
            int n3 = (n2 << 1) + insets.left;
            Dimension dimension2 = new Dimension(0, n2 + insets.top + insets.bottom);
            for (int i = 2; i < componentArray.length; ++i) {
                int n4 = componentArray[i].getPreferredSize().width;
                if (n4 + n3 > n) {
                    dimension2.height += n2;
                    n3 = insets.left;
                }
                n3 += n4;
            }
            return dimension2;
        }

        private Dimension preferredLayoutSizeTB(int n, Insets insets, Component[] componentArray, Dimension dimension) {
            int n2 = n - insets.bottom;
            int n3 = Math.max(dimension.width, ((PanelWindowContainer)PanelWindowContainer.this).closeBox.getPreferredSize().height);
            int n4 = (n3 << 1) + insets.top;
            Dimension dimension2 = new Dimension(n3 + insets.left + insets.right, 0);
            for (int i = 2; i < componentArray.length; ++i) {
                int n5 = componentArray[i].getPreferredSize().height;
                if (n5 + n4 > n2) {
                    dimension2.width += n3;
                    n4 = insets.top;
                }
                n4 += n5;
            }
            return dimension2;
        }
    }

    public static class RotatedTextIcon
    implements Icon {
        public static final int NONE = 0;
        public static final int CW = 1;
        public static final int CCW = 2;
        private final int rotate;
        private final Font font;
        private final GlyphVector glyphs;
        private final float width;
        private final float height;
        private final float ascent;
        private final RenderingHints renderHints;

        public RotatedTextIcon(int n, Font font, String string) {
            this.rotate = n;
            this.font = font;
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            this.glyphs = font.createGlyphVector(fontRenderContext, string);
            this.width = (int)this.glyphs.getLogicalBounds().getWidth() + 4;
            LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
            this.ascent = lineMetrics.getAscent();
            this.height = (int)lineMetrics.getHeight();
            this.renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.renderHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }

        @Override
        public int getIconWidth() {
            return (int)(this.rotate == 1 || this.rotate == 2 ? this.height : this.width);
        }

        @Override
        public int getIconHeight() {
            return (int)(this.rotate == 1 || this.rotate == 2 ? this.width : this.height);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(this.font);
            AffineTransform affineTransform = graphics2D.getTransform();
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(this.renderHints);
            graphics2D.setColor(component.getForeground());
            if (this.rotate == 0) {
                graphics2D.drawGlyphVector(this.glyphs, n + 2, (float)n2 + this.ascent);
            } else if (this.rotate == 1) {
                AffineTransform affineTransform2 = new AffineTransform();
                affineTransform2.concatenate(affineTransform);
                affineTransform2.translate(n, n2 + 2);
                affineTransform2.rotate(1.5707963267948966, this.height / 2.0f, this.width / 2.0f);
                graphics2D.setTransform(affineTransform2);
                graphics2D.drawGlyphVector(this.glyphs, (this.height - this.width) / 2.0f, (this.width - this.height) / 2.0f + this.ascent);
            } else if (this.rotate == 2) {
                AffineTransform affineTransform3 = new AffineTransform();
                affineTransform3.concatenate(affineTransform);
                affineTransform3.translate(n, n2 - 2);
                affineTransform3.rotate(4.71238898038469, this.height / 2.0f, this.width / 2.0f);
                graphics2D.setTransform(affineTransform3);
                graphics2D.drawGlyphVector(this.glyphs, (this.height - this.width) / 2.0f, (this.width - this.height) / 2.0f + this.ascent);
            }
            graphics2D.setTransform(affineTransform);
            graphics2D.setRenderingHints(renderingHints);
        }
    }

    static class DockBorder
    implements Border {
        String position;
        Insets insets;
        Color color1;
        Color color2;
        Color color3;

        DockBorder(String string) {
            this.position = string;
            this.insets = new Insets(string.equals("bottom") ? 10 : 0, string.equals("right") ? 10 : 0, string.equals("top") ? 10 : 0, string.equals("left") ? 10 : 0);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.updateColors();
            if (this.color1 == null || this.color2 == null || this.color3 == null) {
                return;
            }
            if (this.position.equals("bottom")) {
                this.paintHorizBorder(graphics, n, n2, n3);
            } else if (this.position.equals("right")) {
                this.paintVertBorder(graphics, n, n2, n4);
            } else if (this.position.equals("top")) {
                this.paintHorizBorder(graphics, n, n2 + n4 - 10, n3);
            } else if (this.position.equals("left")) {
                this.paintVertBorder(graphics, n + n3 - 10, n2, n4);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private void paintHorizBorder(Graphics graphics, int n, int n2, int n3) {
            graphics.setColor(this.color3);
            graphics.fillRect(n, n2, n3, 10);
            for (int i = 0; i < n3 / 4 - 1; ++i) {
                graphics.setColor(this.color1);
                graphics.drawLine(n + (i << 2) + 2, n2 + 3, n + (i << 2) + 2, n2 + 3);
                graphics.setColor(this.color2);
                graphics.drawLine(n + (i << 2) + 3, n2 + 4, n + (i << 2) + 3, n2 + 4);
                graphics.setColor(this.color1);
                graphics.drawLine(n + (i << 2) + 4, n2 + 5, n + (i << 2) + 4, n2 + 5);
                graphics.setColor(this.color2);
                graphics.drawLine(n + (i << 2) + 5, n2 + 6, n + (i << 2) + 5, n2 + 6);
            }
        }

        private void paintVertBorder(Graphics graphics, int n, int n2, int n3) {
            graphics.setColor(this.color3);
            graphics.fillRect(n, n2, 10, n3);
            for (int i = 0; i < n3 / 4 - 1; ++i) {
                graphics.setColor(this.color1);
                graphics.drawLine(n + 3, n2 + (i << 2) + 2, n + 3, n2 + (i << 2) + 2);
                graphics.setColor(this.color2);
                graphics.drawLine(n + 4, n2 + (i << 2) + 3, n + 4, n2 + (i << 2) + 3);
                graphics.setColor(this.color1);
                graphics.drawLine(n + 5, n2 + (i << 2) + 4, n + 5, n2 + (i << 2) + 4);
                graphics.setColor(this.color2);
                graphics.drawLine(n + 6, n2 + (i << 2) + 5, n + 6, n2 + (i << 2) + 5);
            }
        }

        private void updateColors() {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                this.color1 = MetalLookAndFeel.getControlHighlight();
                this.color2 = MetalLookAndFeel.getControlDarkShadow();
                this.color3 = MetalLookAndFeel.getControl();
            } else {
                this.color3 = null;
                this.color2 = null;
                this.color1 = null;
            }
        }
    }

    class MenuMouseHandler
    extends MouseAdapter {
        MenuMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (PanelWindowContainer.this.popup != null && PanelWindowContainer.this.popup.isVisible()) {
                PanelWindowContainer.this.popup.setVisible(false);
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            String string = component instanceof JToggleButton ? ((JToggleButton)component).getActionCommand() : PanelWindowContainer.this.getCurrent();
            if (component == PanelWindowContainer.this.menuBtn || GUIUtilities.isPopupTrigger(mouseEvent)) {
                boolean bl;
                int n;
                int n2;
                if (string == null) {
                    PanelWindowContainer.this.popup = PanelWindowContainer.this.wm.createPopupMenu(PanelWindowContainer.this, null, false);
                } else {
                    PanelWindowContainer.this.popup = PanelWindowContainer.this.wm.createPopupMenu(PanelWindowContainer.this, string, false);
                }
                if (component == PanelWindowContainer.this.menuBtn) {
                    n2 = 0;
                    n = PanelWindowContainer.this.menuBtn.getHeight();
                    bl = false;
                } else {
                    n2 = mouseEvent.getX();
                    n = mouseEvent.getY();
                    bl = true;
                }
                GUIUtilities.showPopupMenu(PanelWindowContainer.this.popup, component, n2, n, bl);
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PanelWindowContainer.this.popup != null && PanelWindowContainer.this.popup.isVisible()) {
                PanelWindowContainer.this.popup.setVisible(false);
            }
            if (actionEvent.getSource() == PanelWindowContainer.this.closeBox) {
                PanelWindowContainer.this.show((DockableWindowManagerImpl.Entry)null);
            } else if (PanelWindowContainer.this.wm.isDockableWindowVisible(actionEvent.getActionCommand())) {
                PanelWindowContainer.this.show((DockableWindowManagerImpl.Entry)null);
            } else {
                PanelWindowContainer.this.wm.showDockableWindow(actionEvent.getActionCommand());
            }
        }
    }

    static class DockableWindowCompare
    implements Comparator<AbstractButton> {
        DockableWindowCompare() {
        }

        @Override
        public int compare(AbstractButton abstractButton, AbstractButton abstractButton2) {
            String string = abstractButton.getActionCommand();
            String string2 = abstractButton2.getActionCommand();
            return StandardUtilities.compareStrings(jEdit.getProperty(string + ".title", ""), jEdit.getProperty(string2 + ".title", ""), true);
        }
    }
}

