/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.ThreadUtilities;

public class BufferSwitcher
extends JComboBox {
    private final EditPane editPane;
    private boolean updating;
    private Object itemSelectedBefore;

    public BufferSwitcher(final EditPane editPane) {
        this.editPane = editPane;
        this.setRenderer(new BufferCellRenderer());
        this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                BufferSwitcher.this.itemSelectedBefore = BufferSwitcher.this.getSelectedItem();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                Buffer buffer;
                if (!BufferSwitcher.this.updating && (buffer = (Buffer)BufferSwitcher.this.getSelectedItem()) != null) {
                    editPane.setBuffer(buffer);
                }
                editPane.getTextArea().requestFocus();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                BufferSwitcher.this.setSelectedItem(BufferSwitcher.this.itemSelectedBefore);
            }
        });
    }

    public void updateBufferList() {
        final BufferSet bufferSet = this.editPane.getBufferSet();
        if (bufferSet.size() == 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BufferSwitcher.this.updating = true;
                BufferSwitcher.this.setMaximumRowCount(jEdit.getIntegerProperty("bufferSwitcher.maxRowCount", 10));
                BufferSwitcher.this.setModel(new DefaultComboBoxModel<Buffer>(bufferSet.getAllBuffers()));
                BufferSwitcher.this.setSelectedItem(BufferSwitcher.this.editPane.getBuffer());
                BufferSwitcher.this.setToolTipText(BufferSwitcher.this.editPane.getBuffer().getPath(true));
                BufferSwitcher.this.updating = false;
            }
        };
        ThreadUtilities.runInDispatchThread(runnable);
    }

    static class BufferCellRenderer
    extends DefaultListCellRenderer {
        BufferCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Buffer buffer = (Buffer)object;
            if (buffer == null) {
                this.setIcon(null);
            } else {
                this.setIcon(buffer.getIcon());
                this.setToolTipText(buffer.getPath());
            }
            return this;
        }
    }
}

