/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;

public class LocalFileSaveTask
extends Task {
    private static final int BUFFER_SIZE = 4096;
    private File file;
    private String body;
    private String charset;

    public LocalFileSaveTask(File file, String string, String string2) {
        this.file = file;
        this.body = string;
        this.charset = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _run() {
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        try {
            fileOutputStream = new FileOutputStream(this.file);
            fileChannel = fileOutputStream.getChannel();
            byte[] byArray = this.body.getBytes(this.charset);
            fileOutputStream = new FileOutputStream(this.file);
            fileChannel = fileOutputStream.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            int n = byArray.length;
            this.setMaximum(n);
            this.setStatus("Saving " + n + " bytes to " + this.file.getPath());
            for (int i = 0; i < n; i += fileChannel.write((ByteBuffer)byteBuffer.put(byArray, i, Math.min(4096, n - i)).flip())) {
                byteBuffer.rewind();
                this.setValue(i);
            }
        }
        catch (IOException iOException) {
            try {
                Log.log(9, this, iOException, iOException);
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(fileChannel);
                IOUtilities.closeQuietly((Closeable)fileOutputStream);
                throw throwable;
            }
            IOUtilities.closeQuietly(fileChannel);
            IOUtilities.closeQuietly((Closeable)fileOutputStream);
        }
        IOUtilities.closeQuietly(fileChannel);
        IOUtilities.closeQuietly((Closeable)fileOutputStream);
    }
}

