/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.ServiceListHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandlerProvider;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.XMLUtilities;

public class ServiceManager {
    private static final Map<Descriptor, Descriptor> serviceMap = new HashMap<Descriptor, Descriptor>();

    public static void loadServices(PluginJAR pluginJAR, URL uRL, PluginJAR.PluginCacheEntry pluginCacheEntry) {
        ServiceListHandler serviceListHandler = new ServiceListHandler(pluginJAR, uRL);
        try {
            InputStream inputStream = uRL.openStream();
            if (inputStream == null) {
                Log.log(7, ServiceManager.class, "Unable to open: " + uRL);
            } else if (!XMLUtilities.parseXML(uRL.openStream(), serviceListHandler) && pluginCacheEntry != null) {
                pluginCacheEntry.cachedServices = serviceListHandler.getCachedServices();
            }
        }
        catch (IOException iOException) {
            Log.log(9, ServiceManager.class, iOException);
        }
    }

    public static void unloadServices(PluginJAR pluginJAR) {
        Iterator<Descriptor> iterator = serviceMap.keySet().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = iterator.next();
            if (descriptor.plugin != pluginJAR) continue;
            iterator.remove();
        }
    }

    public static void registerService(String string, String string2, String string3, PluginJAR pluginJAR) {
        Descriptor descriptor = new Descriptor(string, string2, string3, pluginJAR);
        serviceMap.put(descriptor, descriptor);
    }

    public static void unregisterService(String string, String string2) {
        Descriptor descriptor = new Descriptor(string, string2);
        serviceMap.remove(descriptor);
    }

    public static String[] getServiceTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        Set<Descriptor> set = serviceMap.keySet();
        for (Descriptor descriptor : set) {
            hashSet.add(descriptor.clazz);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String[] getServiceNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set<Descriptor> set = serviceMap.keySet();
        for (Descriptor descriptor : set) {
            if (!descriptor.clazz.equals(string)) continue;
            arrayList.add(descriptor.name);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getServiceNames(Class clazz) {
        return ServiceManager.getServiceNames(clazz.getName());
    }

    public static Object getService(String string, String string2) {
        Descriptor descriptor = new Descriptor(string, string2);
        Descriptor descriptor2 = serviceMap.get(descriptor);
        if (descriptor2 == null) {
            return null;
        }
        if (descriptor2.code == null) {
            ServiceManager.loadServices(descriptor2.plugin, descriptor2.plugin.getServicesURI(), null);
            descriptor2 = serviceMap.get(descriptor);
        }
        return descriptor2.getInstance();
    }

    public static <E> E getService(Class<E> clazz, String string) {
        return (E)ServiceManager.getService(clazz.getName(), string);
    }

    static void registerService(Descriptor descriptor) {
        serviceMap.put(descriptor, descriptor);
    }

    public static class ServiceFoldHandlerProvider
    implements FoldHandlerProvider {
        public static final String SERVICE = "org.gjt.sp.jedit.buffer.FoldHandler";

        @Override
        public FoldHandler getFoldHandler(String string) {
            FoldHandler foldHandler = (FoldHandler)ServiceManager.getService(SERVICE, string);
            return foldHandler;
        }

        @Override
        public String[] getFoldModes() {
            String[] stringArray = ServiceManager.getServiceNames(SERVICE);
            Arrays.sort(stringArray, new StandardUtilities.StringCompare());
            return stringArray;
        }
    }

    static class Descriptor {
        final String clazz;
        final String name;
        String code;
        PluginJAR plugin;
        Object instance;
        boolean instanceIsNull;

        Descriptor(String string, String string2) {
            this.clazz = string;
            this.name = string2;
        }

        Descriptor(String string, String string2, String string3, PluginJAR pluginJAR) {
            this.clazz = string;
            this.name = string2;
            this.code = string3;
            this.plugin = pluginJAR;
        }

        Object getInstance() {
            if (this.instanceIsNull) {
                return null;
            }
            if (this.instance == null) {
                this.instance = BeanShell.eval(null, BeanShell.getNameSpace(), this.code);
                if (this.instance == null) {
                    this.instanceIsNull = true;
                }
            }
            return this.instance;
        }

        public int hashCode() {
            int n = 31 * this.clazz.hashCode() + this.name.hashCode();
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Descriptor) {
                Descriptor descriptor = (Descriptor)object;
                return descriptor.clazz.equals(this.clazz) && descriptor.name.equals(this.name);
            }
            return false;
        }
    }
}

