/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.Closeable;
import java.io.IOException;
import org.gjt.sp.jedit.RegisterSaver;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.SettingsXML;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class JEditRegisterSaver
implements RegisterSaver {
    private SettingsXML registersXML;

    JEditRegisterSaver() {
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            this.registersXML = new SettingsXML(string, "registers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadRegisters() {
        if (this.registersXML == null) {
            return;
        }
        if (!this.registersXML.fileExists()) {
            return;
        }
        Log.log(3, jEdit.class, "Loading " + this.registersXML);
        RegistersHandler registersHandler = new RegistersHandler();
        try {
            Registers.setLoading(true);
            this.registersXML.load(registersHandler);
        }
        catch (IOException iOException) {
            Log.log(9, Registers.class, iOException);
        }
        finally {
            Registers.setLoading(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveRegisters() {
        if (this.registersXML == null) {
            return;
        }
        if (this.registersXML.hasChangedOnDisk()) {
            Log.log(7, Registers.class, this.registersXML + " changed on disk; will not save registers");
            return;
        }
        Log.log(3, Registers.class, "Saving " + this.registersXML);
        String string = System.getProperty("line.separator");
        SettingsXML.Saver saver = null;
        try {
            saver = this.registersXML.openSaver();
            saver.writeXMLDeclaration();
            saver.write("<!DOCTYPE REGISTERS SYSTEM \"registers.dtd\">");
            saver.write(string);
            saver.write("<REGISTERS>");
            saver.write(string);
            Registers.Register[] registerArray = Registers.getRegisters();
            for (int i = 0; i < registerArray.length; ++i) {
                Registers.Register register = registerArray[i];
                if (register == null || i == 36 || i == 37 || register.toString().length() == 0) continue;
                saver.write("<REGISTER NAME=\"");
                if (i == 34) {
                    saver.write("&quot;");
                } else {
                    saver.write((char)i);
                }
                saver.write("\">");
                saver.write(XMLUtilities.charsToEntities(register.toString(), false));
                saver.write("</REGISTER>");
                saver.write(string);
            }
            saver.write("</REGISTERS>");
            saver.write(string);
            saver.finish();
        }
        catch (Exception exception) {
            Log.log(9, Registers.class, exception);
        }
        finally {
            IOUtilities.closeQuietly((Closeable)saver);
        }
    }

    private static class RegistersHandler
    extends DefaultHandler {
        private String registerName;
        private final StringBuilder charData = new StringBuilder();
        private boolean inRegister;

        private RegistersHandler() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            return XMLUtilities.findEntity(string2, "registers.dtd", this.getClass());
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.registerName = attributes.getValue("NAME");
            this.inRegister = "REGISTER".equals(string3);
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if ("REGISTER".equals(string3)) {
                if (this.registerName == null || this.registerName.length() != 1) {
                    Log.log(9, this, "Malformed NAME: " + this.registerName);
                } else {
                    Registers.setRegister(this.registerName.charAt(0), this.charData.toString());
                }
                this.inRegister = false;
                this.charData.setLength(0);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.inRegister) {
                this.charData.append(cArray, n, n2);
            }
        }
    }
}

