/*
 * Decompiled with CFR 0.152.
 */
package buffertabs;

import buffertabs.BufferTabComponent;
import buffertabs.BufferTabsOptionPane;
import buffertabs.BufferTabsPlugin;
import buffertabs.ColorTabs;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetListener;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class BufferTabs
extends JTabbedPane
implements BufferSetListener {
    private static final String SORT_BUFFERS = "sortBuffers";
    private final EditPane editPane;
    private final JComponent textArea;
    private final ChangeHandler changeHandler;
    private final MouseHandler mouseHandler;
    private final MouseMotionHandler mouseMotionHandler;
    private final Set<Buffer> knownBuffers;
    private TabbedPaneUI ui;
    private TabbedPaneUI bshUI;
    private static int moving = -1;

    public BufferTabs(EditPane editPane) {
        this.editPane = editPane;
        this.textArea = editPane.getTextArea();
        this.changeHandler = new ChangeHandler();
        this.changeHandler.setEnabled(true);
        this.mouseHandler = new MouseHandler();
        this.mouseMotionHandler = new MouseMotionHandler();
        this.knownBuffers = Collections.synchronizedSet(new HashSet());
    }

    public synchronized void start() {
        this.propertiesChanged();
        BufferSet bufferSet = this.editPane.getBufferSet();
        bufferSet.getAllBuffers((BufferSetListener)this);
        bufferSet.addBufferSetListener((BufferSetListener)this);
        EditBus.addToBus((Object)this);
        int index = bufferSet.indexOf(this.editPane.getBuffer());
        this.updateColorAt(this.getSelectedIndex());
        if (index >= 0) {
            this.setSelectedIndex(index);
            this.updateHighlightAt(index);
        }
        this.addChangeListener(this.changeHandler);
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseMotionHandler);
    }

    public synchronized void stop() {
        EditBus.removeFromBus((Object)this);
        this.removeChangeListener(this.changeHandler);
        this.removeMouseListener(this.mouseHandler);
        this.removeMouseMotionListener(this.mouseMotionHandler);
    }

    private static boolean areBuffersSorted() {
        return jEdit.getBooleanProperty((String)SORT_BUFFERS);
    }

    private static void stopBufferSorting() {
        jEdit.setBooleanProperty((String)SORT_BUFFERS, (boolean)false);
        jEdit.propertiesChanged();
    }

    public EditPane getEditPane() {
        return this.editPane;
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bu) {
        Buffer buff;
        int index;
        Buffer buffer = bu.getBuffer();
        BufferSet bufferSet = this.editPane.getBufferSet();
        if (bu.getWhat() == BufferUpdate.DIRTY_CHANGED || bu.getWhat() == BufferUpdate.CREATED) {
            int index2 = bufferSet.indexOf(buffer);
            if (index2 >= 0 && index2 < this.getTabCount()) {
                this.updateTitleAt(index2);
            }
        } else if (bu.getWhat() == BufferUpdate.LOADED) {
            int index3 = bufferSet.indexOf(buffer);
            if (index3 >= 0 && index3 < this.getTabCount()) {
                this.updateTitleAt(index3);
                this.updateHighlightAt(index3);
            }
        } else if (bu.getWhat() == BufferUpdate.SAVED && (index = bufferSet.indexOf(buff = bu.getBuffer())) >= 0 && index < this.getTabCount()) {
            this.setToolTipTextAt(index, buff.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate epu) {
        EditPane editPane = epu.getEditPane();
        if (editPane == this.editPane && epu.getWhat() == EditPaneUpdate.BUFFER_CHANGED) {
            try {
                Buffer buffer = editPane.getBuffer();
                int index = editPane.getBufferSet().indexOf(buffer);
                if (!this.knownBuffers.contains(buffer) && index != -1) {
                    this.bufferAdded(buffer, index);
                }
                this.changeHandler.setEnabled(false);
                this.updateColorAt(this.getSelectedIndex());
                this.setSelectedIndex(index);
                this.updateHighlightAt(index);
            }
            finally {
                this.changeHandler.setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferRemoved(Buffer buffer, int index) {
        try {
            this.changeHandler.setEnabled(false);
            this.knownBuffers.remove(buffer);
            this.removeTabAt(index);
            if (this.getTabCount() > 0 && super.indexOfComponent(this.textArea) == -1) {
                this.setComponentAt(0, this.textArea);
                this.textArea.setVisible(true);
            }
        }
        finally {
            this.changeHandler.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferMoved(Buffer buffer, int oldIndex, int newIndex) {
        try {
            this.changeHandler.setEnabled(false);
            this.bufferRemoved(buffer, oldIndex);
            this.bufferAdded(buffer, newIndex);
        }
        finally {
            this.changeHandler.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferAdded(Buffer buffer, int index) {
        if (this.knownBuffers.contains(buffer)) {
            return;
        }
        try {
            this.changeHandler.setEnabled(false);
            this.knownBuffers.add(buffer);
            JComponent component = null;
            if (super.indexOfComponent(this.textArea) == -1) {
                component = this.textArea;
            }
            this.insertTab(buffer.getName(), null, component, buffer.getPath(), index);
            this.updateTitleAt(index);
            if (component == this.textArea) {
                this.textArea.setVisible(true);
            }
        }
        finally {
            this.changeHandler.setEnabled(true);
        }
        if (this.editPane.getBuffer() == buffer) {
            this.setSelectedIndex(index);
            this.updateHighlightAt(index);
        } else {
            this.updateColorAt(index);
        }
    }

    private void setTabComponent(final int index, final boolean set) {
        try {
            final Method m = this.getClass().getMethod("setTabComponentAt", Integer.TYPE, Component.class);
            if (m != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        BufferTabComponent tab = set ? new BufferTabComponent(BufferTabs.this) : null;
                        try {
                            m.invoke((Object)BufferTabs.this, index, tab);
                        }
                        catch (IllegalAccessException e) {
                            Log.log((int)9, (Object)this, (Object)e);
                        }
                        catch (InvocationTargetException e) {
                            Log.log((int)9, (Object)this, (Object)e);
                        }
                    }
                };
                ThreadUtilities.runInDispatchThread((Runnable)runnable);
            }
        }
        catch (NoSuchMethodException e) {
            Log.log((int)9, (Object)this, (Object)e);
        }
    }

    public void bufferSetSorted() {
        BufferSet bufferSet = this.editPane.getBufferSet();
        this.removeAll();
        this.knownBuffers.clear();
        bufferSet.getAllBuffers((BufferSetListener)this);
    }

    public void propertiesChanged() {
        int layoutPolicy = BufferTabsOptionPane.getWrapTabsProperty() ? 0 : 1;
        this.setTabLayoutPolicy(layoutPolicy);
        TabbedPaneUI currentUI = this.getUI();
        boolean myUI = currentUI.getClass().getCanonicalName().endsWith("MyUI");
        if (jEdit.getBooleanProperty((String)"buffertabs.nostretch", (boolean)false)) {
            if (currentUI instanceof BasicTabbedPaneUI && !myUI) {
                boolean extensible;
                int mod = currentUI.getClass().getModifiers();
                boolean bl = extensible = !Modifier.isFinal(mod) && !Modifier.isAbstract(mod) && Modifier.isPublic(mod);
                if (extensible && this.bshUI == null) {
                    this.ui = currentUI;
                    String name = this.getUI().getClass().getCanonicalName();
                    String bsh = "class MyUI extends " + name + "{\n" + "\tprotected boolean shouldPadTabRun(int tabPlacement, int run) {\n" + "\t\treturn false;\n" + "\t}\n" + "}\n" + "return new MyUI();";
                    this.bshUI = (TabbedPaneUI)BeanShell.eval(null, (NameSpace)BeanShell.getNameSpace(), (String)bsh);
                }
                try {
                    if (this.bshUI != null) {
                        this.setUI(this.bshUI);
                    }
                }
                catch (Exception e) {
                    this.setUI(this.ui);
                }
            }
        } else if (myUI) {
            try {
                this.setUI(this.ui);
            }
            catch (Exception e) {
                this.setUI(this.bshUI);
            }
        }
        if (ColorTabs.instance().isEnabled() != jEdit.getBooleanProperty((String)"buffertabs.color-tabs")) {
            ColorTabs.instance().setEnabled(!ColorTabs.instance().isEnabled());
            if (!ColorTabs.instance().isEnabled()) {
                for (int i = this.getTabCount() - 1; i >= 0; --i) {
                    this.setBackgroundAt(i, null);
                    this.setForegroundAt(i, null);
                }
                this.getUI().uninstallUI(this);
                UIManager.getDefaults().put("TabbedPane.selected", (Object)null);
                this.getUI().installUI(this);
            }
        }
        if (ColorTabs.instance().isEnabled()) {
            ColorTabs.instance().setMuteColors(jEdit.getBooleanProperty((String)"buffertabs.color-mute"));
            ColorTabs.instance().setColorVariation(jEdit.getBooleanProperty((String)"buffertabs.color-variation"));
            ColorTabs.instance().setForegroundColorized(jEdit.getBooleanProperty((String)"buffertabs.color-foreground"));
            if (ColorTabs.instance().isSelectedColorized() != jEdit.getBooleanProperty((String)"buffertabs.color-selected")) {
                ColorTabs.instance().setSelectedColorized(!ColorTabs.instance().isSelectedColorized());
                if (!ColorTabs.instance().isSelectedColorized()) {
                    try {
                        this.getUI().uninstallUI(this);
                        UIManager.getDefaults().put("TabbedPane.selected", (Object)null);
                        this.getUI().installUI(this);
                    }
                    catch (Exception e) {
                        Log.log((int)9, BufferTabs.class, (Object)("propertiesChanged: 3 " + e.toString()));
                    }
                }
            }
            if (ColorTabs.instance().isSelectedColorized()) {
                ColorTabs.instance().setSelectedForegroundColorized(jEdit.getBooleanProperty((String)"buffertabs.color-selected-foreground"));
            }
            ColorTabs.instance().propertiesChanged();
            int selectedIndex = this.getSelectedIndex();
            for (int i = this.getTabCount() - 1; i >= 0; --i) {
                if (selectedIndex == i) {
                    this.updateHighlightAt(i);
                    continue;
                }
                this.updateColorAt(i);
            }
        }
    }

    private void updateColorAt(int index) {
        if (!ColorTabs.instance().isEnabled()) {
            return;
        }
        if (index < 0) {
            return;
        }
        Buffer buffer = this.editPane.getBufferSet().getBuffer(index);
        String name = buffer.getName();
        try {
            Color color = ColorTabs.instance().getDefaultColorFor(name);
            if (!ColorTabs.instance().isForegroundColorized()) {
                this.setBackgroundAt(index, color);
                this.setForegroundAt(index, null);
            } else {
                this.setForegroundAt(index, color);
                this.setBackgroundAt(index, null);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.log((int)7, (Object)this, (Object)"The following is a JRE bug:", (Throwable)e);
        }
    }

    private void updateHighlightAt(int index) {
        if (index < 0) {
            return;
        }
        if (ColorTabs.instance().isEnabled() && ColorTabs.instance().isSelectedColorized() && index == this.getSelectedIndex()) {
            Buffer buffer = this.editPane.getBufferSet().getBuffer(index);
            String name = buffer.getName();
            Color color = ColorTabs.instance().getDefaultColorFor(name);
            if (!ColorTabs.instance().isSelectedForegroundColorized()) {
                Color selected = ColorTabs.instance().alterColorHighlight(color);
                this.setBackgroundAt(index, selected);
                this.setForegroundAt(index, null);
            } else {
                Color selected = ColorTabs.instance().alterColorDarken(color);
                this.setForegroundAt(index, selected);
                this.setBackgroundAt(index, null);
            }
        }
    }

    private void updateTitleAt(int index) {
        if (index < 0 || index >= this.getTabCount()) {
            return;
        }
        this.setTabComponent(index, jEdit.getBooleanProperty((String)"buffertabs.closeButton", (boolean)true));
        Buffer buffer = this.editPane.getBufferSet().getBuffer(index);
        String title = buffer.getName();
        Icon icon = null;
        if (jEdit.getBooleanProperty((String)"buffertabs.icons", (boolean)true)) {
            icon = buffer.getIcon();
        } else {
            if (buffer.isDirty()) {
                title = title + "*";
            }
            if (buffer.isNewFile()) {
                title = title + " (new)";
            }
        }
        this.setTitleAt(index, title);
        this.setIconAt(index, icon);
    }

    public synchronized void updateTitles() {
        this.propertiesChanged();
        for (int index = this.getTabCount() - 1; index >= 0; --index) {
            this.updateTitleAt(index);
        }
    }

    public void setTabPlacement(String location) {
        location = location.toLowerCase();
        int placement = 3;
        if ("top".equals(location)) {
            placement = 1;
        } else if ("left".equals(location)) {
            placement = 2;
        } else if ("right".equals(location)) {
            placement = 4;
        }
        this.setTabPlacement(placement);
    }

    @Override
    public Component getComponentAt(int index) {
        if (this.changeHandler.isEnabled() && index >= 0 && index < this.getTabCount()) {
            return this.textArea;
        }
        return super.getComponentAt(index);
    }

    @Override
    public int indexOfComponent(Component component) {
        if (component == null) {
            return super.indexOfComponent(this.textArea);
        }
        return super.indexOfComponent(component);
    }

    @Override
    protected String paramString() {
        int index = this.getSelectedIndex();
        if (index >= 0) {
            return this.getTitleAt(index);
        }
        return "";
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return false;
    }

    public int getTabAt(int x, int y) {
        for (int index = 0; index < this.getTabCount(); ++index) {
            Rectangle rect = this.getBoundsAt(index);
            if (!rect.contains(x, y)) continue;
            return index;
        }
        return -1;
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (moving != -1) {
                if (BufferTabs.this.getCursor() != Cursor.getPredefinedCursor(13)) {
                    BufferTabs.this.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                BufferTabs.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (GUIUtilities.isPopupTrigger((MouseEvent)e)) {
                if (!jEdit.getBooleanProperty((String)"buffertabs.usePopup", (boolean)true)) {
                    return;
                }
                BufferTabs.this.editPane.focusOnTextArea();
                JPopupMenu popupMenu = BufferTabsPlugin.getRightClickPopup();
                if (popupMenu == null) {
                    return;
                }
                int x = e.getX();
                int y = e.getY();
                popupMenu.show(e.getComponent(), x, y);
            } else {
                if (SwingUtilities.isMiddleMouseButton(e) && jEdit.getBooleanProperty((String)"buffertabs.close-tab-on.single-middle-click")) {
                    int tabIndex = BufferTabs.this.getTabAt(e.getX(), e.getY());
                    if (tabIndex < 0) {
                        return;
                    }
                    BufferTabs.this.editPane.focusOnTextArea();
                    jEdit.closeBuffer((EditPane)BufferTabs.this.editPane, (Buffer)BufferTabs.this.editPane.getBufferSet().getBuffer(tabIndex));
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    moving = BufferTabs.this.getTabAt(e.getX(), e.getY());
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && moving != -1) {
                int mv = moving;
                moving = -1;
                int index = BufferTabs.this.getTabAt(e.getX(), e.getY());
                if (index != -1 && index != mv) {
                    boolean movingEnabled = true;
                    if (BufferTabs.areBuffersSorted()) {
                        ReorderBuffersDisabledDialog dlg = new ReorderBuffersDisabledDialog((Frame)BufferTabs.this.editPane.getView());
                        dlg.setVisible(true);
                        boolean bl = movingEnabled = !BufferTabs.areBuffersSorted();
                    }
                    if (movingEnabled) {
                        jEdit.moveBuffer((EditPane)BufferTabs.this.editPane, (int)mv, (int)index);
                    }
                } else {
                    BufferTabs.this.editPane.focusOnTextArea();
                }
                BufferTabs.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                boolean doubleClick = e.getClickCount() == 2;
                boolean closeTab = jEdit.getBooleanProperty((String)"buffertabs.close-tab-on.double-left-click");
                boolean toggleDocks = jEdit.getBooleanProperty((String)"buffertabs.toggle-docks-on.double-left-click");
                if (doubleClick) {
                    if (closeTab) {
                        int tabIndex = BufferTabs.this.getTabAt(e.getX(), e.getY());
                        BufferTabs.this.editPane.focusOnTextArea();
                        jEdit.closeBuffer((EditPane)BufferTabs.this.editPane, (Buffer)BufferTabs.this.editPane.getBufferSet().getBuffer(tabIndex));
                    } else if (toggleDocks) {
                        BufferTabs.this.editPane.focusOnTextArea();
                        jEdit.getActiveView().getDockableWindowManager().toggleDockAreas();
                    }
                }
            }
        }
    }

    class ReorderBuffersDisabledDialog
    extends JDialog {
        private static final String GEOMETRY = "buffertabs.reorderBuffersDisabledDialog.geometry";
        private final JRadioButton disableSorting;
        private final JRadioButton keepSorting;

        ReorderBuffersDisabledDialog(Frame frame) {
            super(frame, jEdit.getProperty((String)"buffertabs.reorderBuffersDisabled.label"), true);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    ReorderBuffersDisabledDialog.this.saveGeometry();
                }
            });
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(5, 5, 5, 5);
            JLabel message = new JLabel(jEdit.getProperty((String)"buffertabs.bufferTabPositioningDisabled.label"));
            c.gridx = 0;
            c.gridy = 0;
            c.gridheight = 2;
            this.add((Component)message, c);
            this.disableSorting = new JRadioButton(jEdit.getProperty((String)"buffertabs.disableBufferSorting.label"), true);
            c.gridy += c.gridheight;
            c.gridheight = 1;
            this.add((Component)this.disableSorting, c);
            this.keepSorting = new JRadioButton(jEdit.getProperty((String)"buffertabs.keepBufferSorting.label"));
            ++c.gridy;
            this.add((Component)this.keepSorting, c);
            ButtonGroup options = new ButtonGroup();
            options.add(this.disableSorting);
            options.add(this.keepSorting);
            JButton close = new JButton("Close");
            close.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReorderBuffersDisabledDialog.this.saveGeometry();
                    ReorderBuffersDisabledDialog.this.save();
                    ReorderBuffersDisabledDialog.this.setVisible(false);
                }
            });
            ++c.gridy;
            c.fill = 0;
            this.add((Component)close, c);
            this.pack();
            GUIUtilities.loadGeometry((Window)this, (String)GEOMETRY);
        }

        private void save() {
            if (this.disableSorting.isSelected()) {
                BufferTabs.stopBufferSorting();
            }
        }

        private void saveGeometry() {
            GUIUtilities.saveGeometry((Window)this, (String)GEOMETRY);
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private boolean enabled = true;

        private ChangeHandler() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public synchronized void stateChanged(ChangeEvent e) {
            Buffer buffer;
            int index = BufferTabs.this.getSelectedIndex();
            BufferSet bufferSet = BufferTabs.this.editPane.getBufferSet();
            if (index >= 0 && this.isEnabled() && bufferSet.size() > index && (buffer = bufferSet.getBuffer(index)) != null) {
                int selectedIndex = bufferSet.indexOf(BufferTabs.this.editPane.getBuffer());
                if (selectedIndex >= 0) {
                    BufferTabs.this.updateColorAt(selectedIndex);
                }
                BufferTabs.this.editPane.setBuffer(buffer);
                BufferTabs.this.updateHighlightAt(index);
            }
        }
    }
}

