/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.VFSPathSelected;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class VFSDirectoryEntryTable
extends JTable {
    private final BrowserView browserView;
    private final JTableHeader header;
    private final FileCellRenderer renderer;
    private final StringBuffer typeSelectBuffer = new StringBuffer();
    private final Timer timer = new Timer(0, new ClearTypeSelect());
    private boolean resizingColumns;
    static final Icon ASC_ICON = GUIUtilities.loadIcon("arrow-asc.png");
    static final Icon DESC_ICON = GUIUtilities.loadIcon("arrow-desc.png");

    VFSDirectoryEntryTable(BrowserView browserView) {
        super(new VFSDirectoryEntryTableModel());
        this.browserView = browserView;
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.renderer = new FileCellRenderer();
        this.setDefaultRenderer(VFSDirectoryEntryTableModel.Entry.class, this.renderer);
        this.header = this.getTableHeader();
        this.header.setReorderingAllowed(false);
        this.addMouseListener(new MainMouseHandler());
        this.header.addMouseListener(new MouseHandler());
        this.header.setDefaultRenderer(new HeaderRenderer((DefaultTableCellRenderer)this.header.getDefaultRenderer()));
        this.setRowSelectionAllowed(true);
        this.getColumnModel().addColumnModelListener(new ColumnHandler());
        this.setAutoResizeMode(0);
    }

    public boolean selectFile(String string) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)this.getValueAt(i, 1);
            if (!entry.dirEntry.getPath().equals(string)) continue;
            this.setSelectedRow(i);
            return true;
        }
        return false;
    }

    public void doTypeSelect(String string, boolean bl) {
        if (string.length() == 0) {
            this.clearSelection();
        } else if (this.getSelectedRow() == -1) {
            this.doTypeSelect(string, 0, this.getRowCount(), bl);
        } else {
            int n = this.getSelectionModel().getMaxSelectionIndex();
            boolean bl2 = this.doTypeSelect(string, n, this.getRowCount(), bl);
            if (!bl2) {
                this.doTypeSelect(string, 0, n, bl);
            }
        }
    }

    public VFSFile[] getSelectedFiles() {
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        LinkedList<VFSFile> linkedList = new LinkedList<VFSFile>();
        int[] nArray = this.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            linkedList.add(vFSDirectoryEntryTableModel.files[nArray[i]].dirEntry);
        }
        return linkedList.toArray(new VFSFile[linkedList.size()]);
    }

    public void getExpandedDirectories(Set<String> set) {
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        if (vFSDirectoryEntryTableModel.files != null) {
            for (int i = 0; i < vFSDirectoryEntryTableModel.files.length; ++i) {
                if (!vFSDirectoryEntryTableModel.files[i].expanded) continue;
                set.add(vFSDirectoryEntryTableModel.files[i].dirEntry.getPath());
            }
        }
    }

    public void toggleExpanded(final int n) {
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        VFSDirectoryEntryTableModel.Entry entry = vFSDirectoryEntryTableModel.files[n];
        if (entry.dirEntry.getType() == 0) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                VFSDirectoryEntryTable.this.setSelectedRow(n);
            }
        };
        if (entry.expanded) {
            vFSDirectoryEntryTableModel.collapse(VFSManager.getVFSForPath(entry.dirEntry.getPath()), n);
            this.resizeColumns();
            ThreadUtilities.runInDispatchThread(runnable);
        } else {
            this.browserView.clearExpansionState();
            this.browserView.loadDirectory(entry, entry.dirEntry.getPath(), false, runnable);
        }
    }

    public void setDirectory(VFS vFS, Object object, List<VFSFile> list, Set<String> set) {
        int n;
        this.timer.stop();
        this.typeSelectBuffer.setLength(0);
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        if (object == null) {
            n = 0;
            vFSDirectoryEntryTableModel.setRoot(vFS, list);
        } else {
            n = vFSDirectoryEntryTableModel.expand(vFS, (VFSDirectoryEntryTableModel.Entry)object, list);
            ++n;
        }
        for (int i = 0; i < list.size(); ++i) {
            VFSDirectoryEntryTableModel.Entry entry = vFSDirectoryEntryTableModel.files[n + i];
            String string = entry.dirEntry.getPath();
            if (!set.contains(string)) continue;
            this.browserView.loadDirectory(entry, string, false);
            set.remove(string);
        }
        this.resizeColumns();
    }

    public void maybeReloadDirectory(String string) {
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        for (int i = 0; i < vFSDirectoryEntryTableModel.files.length; ++i) {
            VFSFile vFSFile;
            String string2;
            VFSDirectoryEntryTableModel.Entry entry = vFSDirectoryEntryTableModel.files[i];
            if (!entry.expanded || entry.dirEntry.getType() == 0 || !MiscUtilities.pathsEqual(string, string2 = (vFSFile = entry.dirEntry).getSymlinkPath() == null ? vFSFile.getPath() : vFSFile.getSymlinkPath())) continue;
            this.browserView.saveExpansionState();
            this.browserView.loadDirectory(entry, string, false);
            return;
        }
    }

    public void propertiesChanged() {
        this.renderer.propertiesChanged();
        VFSFile vFSFile = new VFSFile("foo", "foo", "foo", 0, 0L, false);
        this.setRowHeight(this.renderer.getTableCellRendererComponent((JTable)this, (Object)new VFSDirectoryEntryTableModel.Entry((VFSFile)vFSFile, (int)0), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height);
        Dimension dimension = this.getPreferredSize();
        this.setPreferredScrollableViewportSize(new Dimension(dimension.width, this.getRowHeight() * 12));
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        rectangle.width = 0;
        super.scrollRectToVisible(rectangle);
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
            int n = this.getSelectedRow();
            ActionContext actionContext = VFSBrowser.getActionContext();
            ActionContext actionContext2 = jEdit.getActionContext();
            EditAction editAction = actionContext.getAction("vfs.browser.up");
            VFSBrowser vFSBrowser = this.browserView.getBrowser();
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    keyEvent.consume();
                    if ((keyEvent.getModifiers() & 8) > 0) {
                        vFSBrowser.previousDirectory();
                        break;
                    }
                    if (n != -1) {
                        if (vFSDirectoryEntryTableModel.files[n].expanded) {
                            this.toggleExpanded(n);
                            return;
                        }
                        for (int i = n - 1; i >= 0; --i) {
                            if (!vFSDirectoryEntryTableModel.files[i].expanded || vFSDirectoryEntryTableModel.files[i].level >= vFSDirectoryEntryTableModel.files[n].level) continue;
                            this.setSelectedRow(i);
                            return;
                        }
                    }
                    String string = this.browserView.getBrowser().getDirectory();
                    string = MiscUtilities.getParentOfPath(string);
                    this.browserView.getBrowser().setDirectory(string);
                    break;
                }
                case 9: {
                    keyEvent.consume();
                    if ((keyEvent.getModifiers() & 1) > 0) {
                        this.browserView.getParentDirectoryList().requestFocus();
                        break;
                    }
                    vFSBrowser.focusOnDefaultComponent();
                    break;
                }
                case 8: {
                    keyEvent.consume();
                    actionContext.invokeAction(keyEvent, editAction);
                    break;
                }
                case 38: {
                    if ((keyEvent.getModifiers() & 8) <= 0) break;
                    keyEvent.consume();
                    actionContext.invokeAction(keyEvent, editAction);
                    break;
                }
                case 127: {
                    keyEvent.consume();
                    EditAction editAction2 = actionContext.getAction("vfs.browser.delete");
                    actionContext.invokeAction(keyEvent, editAction2);
                    break;
                }
                case 78: {
                    if ((keyEvent.getModifiersEx() & 0x80) != 128) break;
                    keyEvent.consume();
                    EditAction editAction3 = actionContext.getAction("vfs.browser.new-file");
                    actionContext.invokeAction(keyEvent, editAction3);
                    break;
                }
                case 155: {
                    keyEvent.consume();
                    EditAction editAction4 = actionContext.getAction("vfs.browser.new-directory");
                    actionContext.invokeAction(keyEvent, editAction4);
                    break;
                }
                case 27: {
                    EditAction editAction5 = actionContext.getAction("vfs.browser.closedialog");
                    actionContext.invokeAction(keyEvent, editAction5);
                    break;
                }
                case 113: {
                    EditAction editAction6 = actionContext.getAction("vfs.browser.rename");
                    keyEvent.consume();
                    actionContext.invokeAction(keyEvent, editAction6);
                    break;
                }
                case 116: {
                    keyEvent.consume();
                    EditAction editAction7 = actionContext.getAction("vfs.browser.reload");
                    actionContext.invokeAction(keyEvent, editAction7);
                    break;
                }
                case 39: 
                case 117: {
                    keyEvent.consume();
                    if ((keyEvent.getModifiers() & 8) > 0) {
                        vFSBrowser.nextDirectory();
                        break;
                    }
                    if (n == -1 || vFSDirectoryEntryTableModel.files[n].expanded) break;
                    this.toggleExpanded(n);
                    break;
                }
                case 10: {
                    keyEvent.consume();
                    this.browserView.getBrowser().filesActivated(keyEvent.isShiftDown() ? 1 : 0, false);
                }
            }
        } else if (keyEvent.getID() == 400) {
            if (keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isMetaDown()) {
                keyEvent.consume();
                return;
            }
            if (keyEvent.isShiftDown() && keyEvent.getKeyChar() == '\n') {
                keyEvent.consume();
                return;
            }
            VFSBrowser vFSBrowser = this.browserView.getBrowser();
            switch (keyEvent.getKeyChar()) {
                case '~': {
                    keyEvent.consume();
                    if (vFSBrowser.getMode() != 2) break;
                    vFSBrowser.setDirectory(System.getProperty("user.home"));
                    break;
                }
                case '/': {
                    keyEvent.consume();
                    if (vFSBrowser.getMode() != 2) break;
                    vFSBrowser.rootDirectory();
                    break;
                }
                case '-': {
                    keyEvent.consume();
                    if (vFSBrowser.getMode() != 2) break;
                    vFSBrowser.setDirectory(vFSBrowser.getView().getBuffer().getDirectory());
                    break;
                }
                default: {
                    keyEvent.consume();
                    this.typeSelectBuffer.append(keyEvent.getKeyChar());
                    this.doTypeSelect(this.typeSelectBuffer.toString(), vFSBrowser.getMode() == 3);
                    this.timer.stop();
                    this.timer.setInitialDelay(750);
                    this.timer.setRepeats(false);
                    this.timer.start();
                    return;
                }
            }
        }
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public void setSelectedRow(int n) {
        this.getSelectionModel().setSelectionInterval(n, n);
        this.scrollRectToVisible(this.getCellRect(n, 0, true));
    }

    private boolean doTypeSelect(String string, int n, int n2, boolean bl) {
        VFSFile[] vFSFileArray = ((VFSDirectoryEntryTableModel)this.getModel()).getFiles();
        int n3 = VFSFile.findCompletion(vFSFileArray, n, n2, string, bl);
        if (n3 != -1) {
            this.setSelectedRow(n3);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeColumns() {
        Object object;
        int n;
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        int[] nArray = new int[vFSDirectoryEntryTableModel.getColumnCount()];
        for (n = 0; n < nArray.length; ++n) {
            object = vFSDirectoryEntryTableModel.getColumnName(n);
            if (object == null) continue;
            nArray[n] = (int)this.renderer.plainFont.getStringBounds((String)object, fontRenderContext).getWidth();
        }
        for (n = 1; n < nArray.length; ++n) {
            nArray[n] = Math.max(nArray[n], vFSDirectoryEntryTableModel.getColumnWidth(n));
        }
        for (n = 0; n < vFSDirectoryEntryTableModel.files.length; ++n) {
            object = vFSDirectoryEntryTableModel.files[n];
            Font font = ((VFSDirectoryEntryTableModel.Entry)object).dirEntry.getType() == 0 ? this.renderer.plainFont : this.renderer.boldFont;
            nArray[0] = Math.max(nArray[0], this.renderer.getEntryWidth((VFSDirectoryEntryTableModel.Entry)object, font, fontRenderContext));
        }
        nArray[0] = nArray[0] + 10;
        TableColumnModel tableColumnModel = this.getColumnModel();
        try {
            this.resizingColumns = true;
            for (int i = 0; i < nArray.length; ++i) {
                tableColumnModel.getColumn(i).setPreferredWidth(nArray[i]);
                tableColumnModel.getColumn(i).setWidth(nArray[i]);
            }
        }
        finally {
            this.resizingColumns = false;
        }
        this.doLayout();
    }

    private void saveWidths() {
        if (this.resizingColumns) {
            return;
        }
        VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)this.getModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 1; i < vFSDirectoryEntryTableModel.getColumnCount(); ++i) {
            vFSDirectoryEntryTableModel.setColumnWidth(i, tableColumnModel.getColumn(i).getWidth());
        }
    }

    static class HeaderRenderer
    extends DefaultTableCellRenderer {
        private final DefaultTableCellRenderer tcr;

        HeaderRenderer(DefaultTableCellRenderer defaultTableCellRenderer) {
            this.tcr = defaultTableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)this.tcr.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)jTable.getModel();
            Icon icon = n2 == vFSDirectoryEntryTableModel.getSortColumn() ? (vFSDirectoryEntryTableModel.getAscending() ? ASC_ICON : DESC_ICON) : null;
            jLabel.setIcon(icon);
            return jLabel;
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == VFSDirectoryEntryTable.this.header && mouseEvent.getClickCount() == 2) {
                VFSDirectoryEntryTableModel vFSDirectoryEntryTableModel = (VFSDirectoryEntryTableModel)VFSDirectoryEntryTable.this.header.getTable().getModel();
                TableColumnModel tableColumnModel = VFSDirectoryEntryTable.this.header.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = tableColumnModel.getColumn(n).getModelIndex();
                VFSDirectoryEntryTable.this.saveWidths();
                if (vFSDirectoryEntryTableModel.sortByColumn(n2)) {
                    VFSDirectoryEntryTable.this.resizeColumns();
                    Log.log(1, this, "VFSDirectoryEntryTable sorted by " + vFSDirectoryEntryTableModel.getColumnName(n2) + (vFSDirectoryEntryTableModel.getAscending() ? " ascending" : " descending"));
                }
            }
        }
    }

    class MainMouseHandler
    extends MouseInputAdapter {
        MainMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (VFSDirectoryEntryTable.this.browserView.getBrowser().getMode() != 2) {
                return;
            }
            int n = VFSDirectoryEntryTable.this.getSelectionModel().getMinSelectionIndex();
            if (n == -1) {
                return;
            }
            VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)VFSDirectoryEntryTable.this.getModel().getValueAt(n, 0);
            boolean bl = entry.dirEntry.getType() == 1;
            EditBus.send(new VFSPathSelected(VFSDirectoryEntryTable.this.browserView.getBrowser().getView(), entry.dirEntry.getPath(), bl));
        }
    }

    class ColumnHandler
    implements TableColumnModelListener {
        ColumnHandler() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            VFSDirectoryEntryTable.this.saveWidths();
        }
    }

    class ClearTypeSelect
    implements ActionListener {
        ClearTypeSelect() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            VFSDirectoryEntryTable.this.typeSelectBuffer.setLength(0);
        }
    }
}

