/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLUtilities {
    public static String charsToEntities(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (('\u0000' <= c && c <= '\u001f' || '\u007f' <= c && c <= '\u009f') && c != '\r' && c != '\n' && c != '\t') {
                if (bl && c != '\u0000') {
                    stringBuilder.append("&#").append((int)c).append(';');
                    continue;
                }
                stringBuilder.append("<?illegal-xml-character ").append((int)c).append("?>");
                continue;
            }
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block5;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parseXML(InputStream inputStream, DefaultHandler defaultHandler) throws IOException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            InputSource inputSource = new InputSource(new BufferedInputStream(inputStream));
            inputSource.setSystemId("jedit.jar");
            xMLReader.setContentHandler(defaultHandler);
            xMLReader.setDTDHandler(defaultHandler);
            xMLReader.setEntityResolver(defaultHandler);
            xMLReader.setErrorHandler(defaultHandler);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            int n = sAXParseException.getLineNumber();
            Log.log(9, XMLUtilities.class, "while parsing from " + inputStream + ": SAXParseException: line " + n + ": ", sAXParseException);
            boolean bl = true;
            return bl;
        }
        catch (SAXException sAXException) {
            Log.log(9, XMLUtilities.class, sAXException);
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtilities.closeQuietly((Closeable)inputStream);
        }
        return false;
    }

    public static InputSource findEntity(String string, String string2, Class<?> clazz) {
        if (string != null && string.endsWith(string2)) {
            try {
                return new InputSource(new BufferedInputStream(clazz.getResourceAsStream(string2)));
            }
            catch (Exception exception) {
                Log.log(9, XMLUtilities.class, "Error while opening " + string2 + ':');
                Log.log(9, XMLUtilities.class, exception);
            }
        }
        return null;
    }

    private XMLUtilities() {
    }
}

