/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class FilteredListModel<E extends ListModel>
extends AbstractListModel
implements ListDataListener {
    protected E delegated;
    private Vector<Integer> filteredIndices;
    private Map<Integer, Integer> invertedIndices;
    private String filter;
    private JList list;

    protected FilteredListModel(E e) {
        this.delegated = e;
        e.addListDataListener(this);
        this.resetFilter();
    }

    public void setList(JList jList) {
        if (jList.getModel() != this) {
            throw new IllegalArgumentException("The given list " + jList + " doesn't use this model " + this);
        }
        this.list = jList;
    }

    public E getDelegated() {
        return this.delegated;
    }

    public void setDelegated(E e) {
        this.delegated.removeListDataListener(this);
        e.addListDataListener(this);
        this.delegated = e;
    }

    private void resetFilter() {
        this.filteredIndices = null;
    }

    public void setFilter(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Set<Integer> set = FilteredListModel.this.saveSelection();
                FilteredListModel.this.list.clearSelection();
                FilteredListModel.this.filter = string;
                if (string != null && string.length() > 0) {
                    int n = FilteredListModel.this.delegated.getSize();
                    String string2 = FilteredListModel.this.prepareFilter(string);
                    Vector<Integer> vector = new Vector<Integer>(n);
                    HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                    for (int i = 0; i < n; ++i) {
                        if (!FilteredListModel.this.passFilter(i, string2)) continue;
                        Integer n2 = i;
                        vector.add(n2);
                        hashMap.put(n2, vector.size() - 1);
                    }
                    FilteredListModel.this.invertedIndices = hashMap;
                    FilteredListModel.this.filteredIndices = vector;
                } else {
                    FilteredListModel.this.resetFilter();
                }
                FilteredListModel.this.fireContentsChanged(FilteredListModel.this, 0, FilteredListModel.this.getSize() - 1);
                FilteredListModel.this.restoreSelection(set);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public String prepareFilter(String string) {
        return string;
    }

    public abstract boolean passFilter(int var1, String var2);

    protected Set<Integer> saveSelection() {
        if (this.list == null) {
            return null;
        }
        int[] nArray = this.list.getSelectedIndices();
        if (nArray.length == 0) {
            return null;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>(nArray.length);
        for (int n : nArray) {
            hashSet.add(this.getTrueRow(n));
        }
        return hashSet;
    }

    protected void restoreSelection(Set<Integer> set) {
        if (set == null || this.getSize() == 0) {
            return;
        }
        Vector<Integer> vector = new Vector<Integer>(set);
        Collections.sort(vector);
        int n = -1;
        int n2 = -1;
        for (Integer n3 : vector) {
            int n4 = this.getInternal2ExternalRow(n3);
            if (n4 == -1) continue;
            if (n == -1) {
                n = n2 = n4;
                continue;
            }
            if (n4 == n2 + 1) {
                n2 = n4;
                continue;
            }
            this.list.setSelectionInterval(n, n2);
            n = n2 = n4;
        }
        if (n != -1) {
            this.list.setSelectionInterval(n, n2);
        }
    }

    public int getTrueRow(int n) {
        if (this.filteredIndices == null) {
            return n;
        }
        return this.filteredIndices.get(n);
    }

    public int getInternal2ExternalRow(int n) {
        if (this.invertedIndices == null) {
            return n;
        }
        Integer n2 = this.invertedIndices.get(n);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    @Override
    public Object getElementAt(int n) {
        int n2 = this.getTrueRow(n);
        return this.delegated.getElementAt(n2);
    }

    @Override
    public int getSize() {
        if (this.filteredIndices == null) {
            return this.delegated.getSize();
        }
        return this.filteredIndices.size();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setFilter(this.filter);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.setFilter(this.filter);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setFilter(this.filter);
    }
}

