/*
 * Decompiled with CFR 0.152.
 */
package whitespace;

import java.util.HashMap;
import java.util.Map;
import whitespace.WhiteSpaceDefaults;

public class WhiteSpaceModel {
    public static final String MODEL_PROPERTY = "white-space.model";
    private Option blockHighlight = new Option(WhiteSpaceDefaults.getBlockHighlightDefault());
    private Option foldHighlight = new Option(WhiteSpaceDefaults.getFoldHighlightDefault());
    private Option foldTooltip = new Option(WhiteSpaceDefaults.getFoldTooltipDefault());
    private Option spaceHighlight = new Option(WhiteSpaceDefaults.getSpaceHighlightDefault());
    private Option leadingSpaceHighlight = new Option(WhiteSpaceDefaults.getLeadingSpaceHighlightDefault());
    private Option innerSpaceHighlight = new Option(WhiteSpaceDefaults.getInnerSpaceHighlightDefault());
    private Option trailingSpaceHighlight = new Option(WhiteSpaceDefaults.getTrailingSpaceHighlightDefault());
    private Option tabHighlight = new Option(WhiteSpaceDefaults.getTabHighlightDefault());
    private Option leadingTabHighlight = new Option(WhiteSpaceDefaults.getLeadingTabHighlightDefault());
    private Option innerTabHighlight = new Option(WhiteSpaceDefaults.getInnerTabHighlightDefault());
    private Option trailingTabHighlight = new Option(WhiteSpaceDefaults.getTrailingTabHighlightDefault());
    private Option whitespaceHighlight = new Option(WhiteSpaceDefaults.getWhitespaceHighlightDefault());
    private Option removeTrailingWhitespace = new Option(WhiteSpaceDefaults.getRemoveTrailingWhitespace());
    private Option softTabifyLeadingWhitespace = new Option(WhiteSpaceDefaults.getSoftTabifyLeadingWhitespace());
    private Option tabifyLeadingWhitespace = new Option(WhiteSpaceDefaults.getTabifyLeadingWhitespace());
    private Option untabifyLeadingWhitespace = new Option(WhiteSpaceDefaults.getUntabifyLeadingWhitespace());
    private Map<String, Option> optsMap = new HashMap<String, Option>();

    public WhiteSpaceModel() {
        this.optsMap.put("space-highlight", this.spaceHighlight);
        this.optsMap.put("tab-highlight", this.tabHighlight);
        this.optsMap.put("whitespace-highlight", this.whitespaceHighlight);
        this.optsMap.put("block-highlight", this.blockHighlight);
        this.optsMap.put("fold-highlight", this.foldHighlight);
        this.optsMap.put("fold-tooltip", this.foldTooltip);
        this.optsMap.put("leading-space-highlight", this.leadingSpaceHighlight);
        this.optsMap.put("inner-space-highlight", this.innerSpaceHighlight);
        this.optsMap.put("trailing-space-highlight", this.trailingSpaceHighlight);
        this.optsMap.put("leading-tab-highlight", this.leadingTabHighlight);
        this.optsMap.put("inner-tab-highlight", this.innerTabHighlight);
        this.optsMap.put("trailing-tab-highlight", this.trailingTabHighlight);
        this.optsMap.put("remove-trailing-white-space", this.removeTrailingWhitespace);
        this.optsMap.put("soft-tabify-leading-white-space", this.softTabifyLeadingWhitespace);
        this.optsMap.put("tabify-leading-white-space", this.tabifyLeadingWhitespace);
        this.optsMap.put("untabify-leading-white-space", this.untabifyLeadingWhitespace);
    }

    public Option getOption(String sName) {
        return this.optsMap.get(sName);
    }

    public Option getBlockHighlight() {
        return this.blockHighlight;
    }

    public Option getFoldHighlight() {
        return this.foldHighlight;
    }

    public Option getFoldTooltip() {
        return this.foldTooltip;
    }

    public Option getSpaceHighlight() {
        return this.spaceHighlight;
    }

    public Option getLeadingSpaceHighlight() {
        return this.leadingSpaceHighlight;
    }

    public Option getInnerSpaceHighlight() {
        return this.innerSpaceHighlight;
    }

    public Option getTrailingSpaceHighlight() {
        return this.trailingSpaceHighlight;
    }

    public Option getTabHighlight() {
        return this.tabHighlight;
    }

    public Option getLeadingTabHighlight() {
        return this.leadingTabHighlight;
    }

    public Option getInnerTabHighlight() {
        return this.innerTabHighlight;
    }

    public Option getTrailingTabHighlight() {
        return this.trailingTabHighlight;
    }

    public Option getWhitespaceHighlight() {
        return this.whitespaceHighlight;
    }

    public Option getRemoveTrailingWhitespace() {
        return this.removeTrailingWhitespace;
    }

    public Option getSoftTabifyLeadingWhitespace() {
        return this.softTabifyLeadingWhitespace;
    }

    public Option getTabifyLeadingWhitespace() {
        return this.tabifyLeadingWhitespace;
    }

    public Option getUntabifyLeadingWhitespace() {
        return this.untabifyLeadingWhitespace;
    }

    public class Option {
        private boolean enabled;

        public Option() {
            this(false);
        }

        public Option(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void toggleEnabled() {
            this.setEnabled(!this.isEnabled());
        }
    }
}

