/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

class ExtensionManager {
    private final List<Entry> extensions = new LinkedList<Entry>();

    ExtensionManager() {
    }

    void addExtension(int n, TextAreaExtension textAreaExtension) {
        Entry entry = new Entry(n, textAreaExtension);
        int n2 = 0;
        for (Entry entry2 : this.extensions) {
            int n3 = entry2.layer;
            if (n < n3) {
                this.extensions.add(n2, entry);
                return;
            }
            ++n2;
        }
        this.extensions.add(entry);
    }

    void removeExtension(TextAreaExtension textAreaExtension) {
        Iterator<Entry> iterator = this.extensions.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().ext != textAreaExtension) continue;
            iterator.remove();
            return;
        }
    }

    TextAreaExtension[] getExtensions() {
        TextAreaExtension[] textAreaExtensionArray = new TextAreaExtension[this.extensions.size()];
        Iterator<Entry> iterator = this.extensions.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            textAreaExtensionArray[n++] = iterator.next().ext;
        }
        return textAreaExtensionArray;
    }

    void paintScreenLineRange(TextArea textArea, Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        try {
            int[] nArray = new int[n2 - n + 1];
            int[] nArray2 = new int[nArray.length];
            int[] nArray3 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n5 = i + n;
                ChunkCache.LineInfo lineInfo = textArea.chunkCache.getLineInfo(n5);
                if (lineInfo.physicalLine == -1) {
                    nArray[i] = -1;
                    continue;
                }
                nArray[i] = lineInfo.physicalLine;
                nArray2[i] = textArea.getScreenLineStartOffset(n5);
                nArray3[i] = textArea.getScreenLineEndOffset(n5);
            }
            this.paintScreenLineRange(graphics2D, n, n2, nArray, nArray2, nArray3, n3, n4);
        }
        catch (Exception exception) {
            Log.log(9, this, "Error repainting line range {" + n + ',' + n2 + "}:");
            Log.log(9, this, exception);
        }
    }

    String getToolTipText(int n, int n2) {
        for (int i = 0; i < this.extensions.size(); ++i) {
            TextAreaExtension textAreaExtension = this.extensions.get((int)i).ext;
            String string = textAreaExtension.getToolTipText(n, n2);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private void paintScreenLineRange(Graphics2D graphics2D, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4) {
        Iterator<Entry> iterator = this.extensions.iterator();
        while (iterator.hasNext()) {
            TextAreaExtension textAreaExtension = iterator.next().ext;
            try {
                textAreaExtension.paintScreenLineRange(graphics2D, n, n2, nArray, nArray2, nArray3, n3, n4);
            }
            catch (Throwable throwable) {
                Log.log(9, this, throwable);
                iterator.remove();
            }
        }
    }

    static class Entry {
        int layer;
        TextAreaExtension ext;

        Entry(int n, TextAreaExtension textAreaExtension) {
            this.layer = n;
            this.ext = textAreaExtension;
        }
    }
}

