/*
 * Decompiled with CFR 0.152.
 */
package whitespace;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import whitespace.WhiteSpaceModel;

public class FoldHighlight
extends TextAreaExtension {
    private static final Hashtable highlights = new Hashtable();
    private static Color foldColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.fold-color"));
    private JEditTextArea textArea;
    private EditPane editPane;
    private Segment segment = new Segment();

    private FoldHighlight(JEditTextArea textArea, EditPane editPane) {
        this.textArea = textArea;
        this.editPane = editPane;
    }

    public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
        WhiteSpaceModel model = this.getModel();
        if (model != null && model.getFoldHighlight().isEnabled()) {
            int i;
            try {
                if (this.textArea.getLineStartOffset(physicalLine) == -1 || this.textArea.getLineEndOffset(physicalLine) == -1) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            Buffer buffer = this.editPane.getBuffer();
            int foldLevel = buffer.getFoldLevel(physicalLine);
            TextAreaPainter painter = this.textArea.getPainter();
            FontMetrics fm = painter.getFontMetrics();
            int spaceWidth = fm.charWidth(' ');
            Vector<Integer> foldLevels = new Vector<Integer>();
            int level = foldLevel;
            for (i = physicalLine - 1; i >= 0 && (level = buffer.getFoldLevel(i)) != 0; --i) {
                if (level >= foldLevel) continue;
                foldLevels.addElement(new Integer(level));
                foldLevel = level;
            }
            for (i = 0; i < foldLevels.size(); ++i) {
                level = (Integer)foldLevels.elementAt(i);
                int x0 = level * spaceWidth + 1 + this.textArea.getHorizontalOffset();
                gfx.setColor(foldColor);
                gfx.drawLine(x0, y, x0, y + fm.getHeight() - 1);
            }
        }
    }

    public String getToolTipText(int x, int y) {
        WhiteSpaceModel model = this.getModel();
        if (model != null && model.getFoldHighlight().isEnabled() && model.getFoldTooltip().isEnabled()) {
            JEditTextArea ta = this.textArea;
            Buffer buffer = this.editPane.getBuffer();
            int offset = ta.xyToOffset(x, y, false);
            if (offset == -1 || offset >= ta.getBuffer().getLength()) {
                return null;
            }
            int physicalLine = ta.getLineOfOffset(offset);
            int foldLevel = buffer.getFoldLevel(physicalLine);
            int virtualLineOffset = offset - ta.getLineStartOffset(physicalLine);
            int physicalLineOffset = 0;
            if (virtualLineOffset > 0) {
                physicalLineOffset = MiscUtilities.getLeadingWhiteSpaceWidth((String)ta.getText(ta.getLineStartOffset(physicalLine), virtualLineOffset), (int)buffer.getTabSize());
            } else if (ta.getLineLength(physicalLine) == 0) {
                TextAreaPainter painter = this.textArea.getPainter();
                FontMetrics fm = painter.getFontMetrics();
                int spaceWidth = fm.charWidth(' ');
                physicalLineOffset = x / spaceWidth;
            }
            StringBuffer tooltip = new StringBuffer();
            if (physicalLineOffset > 0 && physicalLineOffset < foldLevel) {
                int level = 0;
                block0: for (int i = physicalLine - 1; i >= 0; --i) {
                    level = buffer.getFoldLevel(i);
                    if (level > physicalLineOffset) continue;
                    int referenceLevel = level;
                    int firstVisibleLine = ta.getFirstPhysicalLine();
                    if (i >= firstVisibleLine) break;
                    while (i >= 0) {
                        level = buffer.getFoldLevel(i);
                        String text = ta.getLineText(i).trim();
                        if (level < referenceLevel) break block0;
                        if (level == referenceLevel && FoldHighlight.hasSignificantChars(text)) {
                            if (tooltip.length() > 0) {
                                tooltip.insert(0, ' ');
                            }
                            tooltip.insert(0, text);
                            break block0;
                        }
                        --i;
                    }
                    break;
                }
            }
            if (tooltip.length() > 0) {
                return tooltip.toString();
            }
        }
        return null;
    }

    public WhiteSpaceModel getModel() {
        return (WhiteSpaceModel)this.textArea.getBuffer().getProperty((Object)"white-space.model");
    }

    private void updateTextArea() {
        if (this.textArea == null) {
            return;
        }
        DisplayManager displayManager = this.textArea.getDisplayManager();
        int physicalFirst = displayManager.getFirstVisibleLine();
        int physicalLast = displayManager.getLastVisibleLine();
        this.textArea.invalidateLineRange(physicalFirst, physicalLast);
    }

    public static void updateTextAreas(Buffer buffer) {
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            EditPane[] editPanes = views[i].getEditPanes();
            for (int j = 0; j < editPanes.length; ++j) {
                FoldHighlight highlight;
                if (editPanes[j].getBuffer() != buffer || (highlight = (FoldHighlight)((Object)highlights.get(editPanes[j]))) == null) continue;
                highlight.updateTextArea();
            }
        }
    }

    public static TextAreaExtension addHighlightTo(EditPane editPane) {
        JEditTextArea textArea = editPane.getTextArea();
        TextAreaPainter painter = textArea.getPainter();
        FoldHighlight highlight = null;
        highlight = (FoldHighlight)((Object)painter.getClientProperty((Object)FoldHighlight.class));
        if (highlight == null) {
            highlight = new FoldHighlight(textArea, editPane);
            highlights.put(editPane, highlight);
            painter.addExtension(0, (TextAreaExtension)highlight);
            painter.putClientProperty((Object)FoldHighlight.class, (Object)highlight);
        }
        return highlight;
    }

    public static void removeHighlightFrom(EditPane editPane) {
        FoldHighlight highlight = (FoldHighlight)((Object)editPane.getTextArea().getPainter().getClientProperty((Object)FoldHighlight.class));
        if (highlight != null) {
            editPane.getTextArea().getPainter().removeExtension((TextAreaExtension)highlight);
            editPane.getTextArea().getPainter().putClientProperty((Object)FoldHighlight.class, null);
        }
        highlights.remove(editPane);
    }

    public static void propertiesChanged() {
        boolean foldColorChanged;
        Color newFoldColor = GUIUtilities.parseColor((String)jEdit.getProperty((String)"white-space.fold-color"));
        boolean bl = foldColorChanged = !newFoldColor.equals(foldColor);
        if (!foldColorChanged) {
            return;
        }
        foldColor = newFoldColor;
        View[] views = jEdit.getViews();
        for (int i = 0; i < views.length; ++i) {
            EditPane[] editPanes = views[i].getEditPanes();
            for (int j = 0; j < editPanes.length; ++j) {
                WhiteSpaceModel model;
                FoldHighlight highlight = (FoldHighlight)((Object)highlights.get(editPanes[j]));
                if (highlight == null || (model = highlight.getModel()) == null || !model.getFoldHighlight().isEnabled()) continue;
                highlight.updateTextArea();
            }
        }
    }

    public static boolean hasSignificantChars(String text) {
        for (int i = text.length() - 1; i >= 0; --i) {
            if (!Character.isLetterOrDigit(text.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

