/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.Color;
import java.awt.Font;
import java.util.Locale;
import java.util.StringTokenizer;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class SyntaxUtilities {
    public static IPropertyManager propertyManager;

    public static String getColorHexString(Color color) {
        String string = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        return "#000000".substring(0, 7 - string.length()).concat(string);
    }

    public static Color parseColor(String string, Color color) {
        if (string == null || string.length() == 0) {
            return color;
        }
        if (string.charAt(0) == '#') {
            try {
                return Color.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                return color;
            }
        }
        if ("red".equals(string)) {
            return Color.red;
        }
        if ("green".equals(string)) {
            return Color.green;
        }
        if ("blue".equals(string)) {
            return Color.blue;
        }
        if ("yellow".equals(string)) {
            return Color.yellow;
        }
        if ("orange".equals(string)) {
            return Color.orange;
        }
        if ("white".equals(string)) {
            return Color.white;
        }
        if ("lightGray".equals(string)) {
            return Color.lightGray;
        }
        if ("gray".equals(string)) {
            return Color.gray;
        }
        if ("darkGray".equals(string)) {
            return Color.darkGray;
        }
        if ("black".equals(string)) {
            return Color.black;
        }
        if ("cyan".equals(string)) {
            return Color.cyan;
        }
        if ("magenta".equals(string)) {
            return Color.magenta;
        }
        if ("pink".equals(string)) {
            return Color.pink;
        }
        return color;
    }

    public static SyntaxStyle parseStyle(String string, String string2, int n, boolean bl, Color color) throws IllegalArgumentException {
        Color color2 = color;
        Color color3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("color:")) {
                if (!bl) continue;
                color2 = SyntaxUtilities.parseColor(string3.substring(6), Color.black);
                continue;
            }
            if (string3.startsWith("bgColor:")) {
                if (!bl) continue;
                color3 = SyntaxUtilities.parseColor(string3.substring(8), null);
                continue;
            }
            if (string3.startsWith("style:")) {
                for (int i = 6; i < string3.length(); ++i) {
                    if (string3.charAt(i) == 'i') {
                        bl2 = true;
                        continue;
                    }
                    if (string3.charAt(i) == 'b') {
                        bl3 = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid style: " + string3);
                }
                continue;
            }
            throw new IllegalArgumentException("Invalid directive: " + string3);
        }
        return new SyntaxStyle(color2, color3, new Font(string2, (bl2 ? 2 : 0) | (bl3 ? 1 : 0), n));
    }

    public static SyntaxStyle parseStyle(String string, String string2, int n, boolean bl) throws IllegalArgumentException {
        return SyntaxUtilities.parseStyle(string, string2, n, bl, Color.black);
    }

    public static SyntaxStyle[] loadStyles(String string, int n) {
        return SyntaxUtilities.loadStyles(string, n, true);
    }

    public static SyntaxStyle[] loadStyles(String string, int n, boolean bl) {
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[19];
        for (int i = 1; i < syntaxStyleArray.length; ++i) {
            try {
                String string2 = "view.style." + Token.tokenToString((byte)i).toLowerCase(Locale.ENGLISH);
                syntaxStyleArray[i] = SyntaxUtilities.parseStyle(propertyManager.getProperty(string2), string, n, bl);
                continue;
            }
            catch (Exception exception) {
                Log.log(9, StandardUtilities.class, exception);
            }
        }
        return syntaxStyleArray;
    }

    private SyntaxUtilities() {
    }
}

