/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.util.Comparator;
import java.util.Stack;
import javax.swing.text.Segment;

public class StandardUtilities {
    public static String charsToEscapes(String string) {
        return StandardUtilities.charsToEscapes(string, "\n\t\\\"'");
    }

    public static String charsToEscapes(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) != -1) {
                if (c == '\n') {
                    stringBuilder.append("\\n");
                    continue;
                }
                if (c == '\t') {
                    stringBuilder.append("\\t");
                    continue;
                }
                stringBuilder.append('\\');
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getIndentString(String string) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length() && Character.isWhitespace(c = string.charAt(i)); ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static int getLeadingWhiteSpace(String string) {
        return StandardUtilities.getLeadingWhiteSpace((CharSequence)string);
    }

    public static int getLeadingWhiteSpace(CharSequence charSequence) {
        int n;
        block3: for (n = 0; n < charSequence.length(); ++n) {
            switch (charSequence.charAt(n)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return n;
    }

    public static int getTrailingWhiteSpace(String string) {
        int n = 0;
        block3: for (int i = string.length() - 1; i >= 0; --i) {
            switch (string.charAt(i)) {
                case '\t': 
                case ' ': {
                    ++n;
                    continue block3;
                }
            }
        }
        return n;
    }

    public static int getLeadingWhiteSpaceWidth(String string, int n) {
        return StandardUtilities.getLeadingWhiteSpaceWidth((CharSequence)string, n);
    }

    public static int getLeadingWhiteSpaceWidth(CharSequence charSequence, int n) {
        int n2 = 0;
        block4: for (int i = 0; i < charSequence.length(); ++i) {
            switch (charSequence.charAt(i)) {
                case ' ': {
                    ++n2;
                    continue block4;
                }
                case '\t': {
                    n2 += n - n2 % n;
                    continue block4;
                }
            }
        }
        return n2;
    }

    public static String createWhiteSpace(int n, int n2) {
        return StandardUtilities.createWhiteSpace(n, n2, 0);
    }

    public static String truncateWhiteSpace(int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (int i = 0; n3 < n && i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                ++n3;
                stringBuilder.append(c);
                continue;
            }
            if (c != '\t') continue;
            int n4 = n3 + n2 - n3 % n2;
            if (n4 > n) {
                while (n3 < n) {
                    stringBuilder.append(' ');
                    ++n3;
                }
                continue;
            }
            n3 = n4;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String createWhiteSpace(int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 0) {
            while (n-- > 0) {
                stringBuilder.append(' ');
            }
        } else if (n == 1) {
            stringBuilder.append(' ');
        } else {
            int n4 = (n + n3 % n2) / n2;
            if (n4 != 0) {
                n += n3;
            }
            while (n4-- > 0) {
                stringBuilder.append('\t');
            }
            n4 = n % n2;
            while (n4-- > 0) {
                stringBuilder.append(' ');
            }
        }
        return stringBuilder.toString();
    }

    public static int getVirtualWidth(Segment segment, int n) {
        int n2 = 0;
        for (int i = 0; i < segment.count; ++i) {
            char c = segment.array[segment.offset + i];
            if (c == '\t') {
                n2 += n - n2 % n;
                continue;
            }
            ++n2;
        }
        return n2;
    }

    public static int getOffsetOfVirtualColumn(Segment segment, int n, int n2, int[] nArray) {
        int n3 = 0;
        for (int i = 0; i < segment.count; ++i) {
            char c = segment.array[segment.offset + i];
            if (c == '\t') {
                int n4 = n - n3 % n;
                if (n3 >= n2) {
                    return i;
                }
                n3 += n4;
                continue;
            }
            if (n3 >= n2) {
                return i;
            }
            ++n3;
        }
        if (nArray != null) {
            nArray[0] = n3;
        }
        return -1;
    }

    public static int compareStrings(String string, String string2, boolean bl) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n = Math.min(cArray.length, cArray2.length);
        int n2 = 0;
        for (int i = 0; n2 < n && i < n; ++n2, ++i) {
            char c = cArray[n2];
            char c2 = cArray2[i];
            if (Character.isDigit(c) && Character.isDigit(c2) && c != '0' && c2 != '0') {
                int n3;
                int n4 = i + 1;
                for (n3 = n2 + 1; n3 < cArray.length && Character.isDigit(cArray[n3]); ++n3) {
                }
                while (n4 < cArray2.length && Character.isDigit(cArray2[n4])) {
                    ++n4;
                }
                int n5 = n3 - n2;
                int n6 = n4 - i;
                if (n5 > n6) {
                    return 1;
                }
                if (n5 < n6) {
                    return -1;
                }
                for (int j = 0; j < n5; ++j) {
                    c = cArray[n2 + j];
                    c2 = cArray2[i + j];
                    if (c == c2) continue;
                    return c - c2;
                }
                n2 = n3 - 1;
                i = n4 - 1;
                continue;
            }
            if (bl) {
                c = Character.toLowerCase(c);
                c2 = Character.toLowerCase(c2);
            }
            if (c == c2) continue;
            return c - c2;
        }
        return cArray.length - cArray2.length;
    }

    public static boolean objectsEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public static String globToRE(String string) {
        if (string.startsWith("(re)")) {
            return string.substring(4);
        }
        Object object = new Object();
        Object object2 = new Object();
        Stack<Object> stack = new Stack<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                stringBuilder.append('\\');
                stringBuilder.append(c);
                bl = false;
                continue;
            }
            switch (c) {
                case '\\': {
                    bl = true;
                    continue block10;
                }
                case '?': {
                    stringBuilder.append('.');
                    continue block10;
                }
                case '(': 
                case ')': 
                case '+': 
                case '.': {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue block10;
                }
                case '*': {
                    stringBuilder.append(".*");
                    continue block10;
                }
                case '|': {
                    if (bl) {
                        stringBuilder.append("\\|");
                        continue block10;
                    }
                    stringBuilder.append('|');
                    continue block10;
                }
                case '{': {
                    stringBuilder.append('(');
                    if (i + 1 != string.length() && string.charAt(i + 1) == '!') {
                        stringBuilder.append('?');
                        stack.push(object);
                        continue block10;
                    }
                    stack.push(object2);
                    continue block10;
                }
                case ',': {
                    if (!stack.isEmpty() && stack.peek() == object2) {
                        stringBuilder.append('|');
                        continue block10;
                    }
                    stringBuilder.append(',');
                    continue block10;
                }
                case '}': {
                    if (!stack.isEmpty()) {
                        stringBuilder.append(')');
                        if (stack.pop() != object) continue block10;
                        stringBuilder.append(".*");
                        continue block10;
                    }
                    stringBuilder.append('}');
                    continue block10;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static boolean regionMatches(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            if (i + n >= charSequence.length()) {
                bl = false;
                break;
            }
            char c = charSequence.charAt(i + n);
            if (i + n2 >= charSequence2.length()) {
                bl = false;
                break;
            }
            char c2 = charSequence2.charAt(i + n2);
            if (c == c2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean startsWith(CharSequence charSequence, String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if (i < charSequence.length() && charSequence.charAt(i) == string.charAt(i)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean getBoolean(Object object, boolean bl) {
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if ("true".equals(object) || "yes".equals(object) || "on".equals(object)) {
            return true;
        }
        if ("false".equals(object) || "no".equals(object) || "off".equals(object)) {
            return false;
        }
        return bl;
    }

    private StandardUtilities() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringCompare<E>
    implements Comparator<E> {
        private boolean icase;

        public StringCompare(boolean bl) {
            this.icase = bl;
        }

        public StringCompare() {
        }

        @Override
        public int compare(E e, E e2) {
            return StandardUtilities.compareStrings(e.toString(), e2.toString(), this.icase);
        }
    }
}

