/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.StringTokenizer;
import org.gjt.sp.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesBean {
    private final char arraysep;
    private final String root;

    protected PropertiesBean(String string) {
        this(string, ':');
    }

    protected PropertiesBean(String string, char c) {
        if (string == null) {
            throw new IllegalArgumentException("root cannot be null");
        }
        this.root = string;
        this.arraysep = c;
    }

    public void load(Properties properties) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Method method;
                if ("class".equals(propertyDescriptorArray[i].getName()) || (method = propertyDescriptorArray[i].getWriteMethod()) == null) continue;
                String string = this.root + "." + propertyDescriptorArray[i].getName();
                Object object = properties.getProperty(string);
                if (object != null) {
                    object = this.parse((String)object, propertyDescriptorArray[i].getPropertyType());
                }
                try {
                    method.invoke((Object)this, object);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
        }
    }

    public void save(Properties properties) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                Method method;
                if ("class".equals(propertyDescriptorArray[i].getName()) || (method = propertyDescriptorArray[i].getReadMethod()) == null) continue;
                Object object = method.invoke((Object)this, new Object[0]);
                String string = this.root + "." + propertyDescriptorArray[i].getName();
                if (object != null) {
                    properties.setProperty(string, this.encode(object));
                    continue;
                }
                properties.remove(string);
            }
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
        }
    }

    public void clean(Properties properties) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if ("class".equals(propertyDescriptorArray[i].getName())) continue;
                String string = this.root + "." + propertyDescriptorArray[i].getName();
                properties.remove(string);
            }
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors() throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(this.getClass());
        return beanInfo.getPropertyDescriptors();
    }

    private String encode(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                String string = this.encode(Array.get(object, i));
                if (string == null) {
                    return null;
                }
                stringBuilder.append(string);
                if (i >= n - 1) continue;
                stringBuilder.append(this.arraysep);
            }
            return stringBuilder.toString();
        }
        if (clazz != Boolean.class && clazz != Boolean.TYPE && clazz != Character.class && clazz != Character.TYPE && clazz != Double.class && clazz != Double.TYPE && clazz != Float.class && clazz != Float.TYPE && clazz != Integer.class && clazz != Integer.TYPE && clazz != Long.class && clazz != Long.TYPE && clazz != Short.class && clazz != Short.TYPE && clazz != String.class) {
            Log.log(7, this, "unsupported type: " + clazz.getName());
            return null;
        }
        return object.toString();
    }

    private Object parse(String string, Class<?> clazz) {
        Object object = null;
        if (clazz.isArray()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(this.arraysep));
            Class<?> clazz2 = clazz.getComponentType();
            object = Array.newInstance(clazz2, stringTokenizer.countTokens());
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                Object object2 = this.parse(stringTokenizer.nextToken(), clazz2);
                if (object2 == null) {
                    return null;
                }
                Array.set(object, i, object2);
            }
        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            object = Boolean.valueOf(string);
        } else if (clazz == Character.class || clazz == Character.TYPE) {
            object = Character.valueOf(string.charAt(0));
        } else if (clazz == Double.class || clazz == Double.TYPE) {
            object = Double.valueOf(string);
        } else if (clazz == Float.class || clazz == Float.TYPE) {
            object = Float.valueOf(string);
        } else if (clazz == Integer.class || clazz == Integer.TYPE) {
            object = Integer.valueOf(string);
        } else if (clazz == Long.class || clazz == Long.TYPE) {
            object = Long.valueOf(string);
        } else if (clazz == Short.class || clazz == Short.TYPE) {
            object = Short.valueOf(string);
        } else if (clazz == String.class) {
            object = string;
        } else {
            Log.log(7, this, "unsupported type: " + clazz.getName());
        }
        return object;
    }
}

