/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class Log {
    public static final int MAXLINES = 500;
    public static final int DEBUG = 1;
    public static final int MESSAGE = 3;
    public static final int NOTICE = 5;
    public static final int WARNING = 7;
    public static final int ERROR = 9;
    private static final Object LOCK = new Object();
    private static final String[] log;
    private static int logLineCount;
    private static boolean wrap;
    private static int level;
    private static Writer stream;
    private static final String lineSep;
    private static final PrintStream realOut;
    private static final PrintStream realErr;
    private static final LogListModel listModel;
    private static final DateFormat timeFormat;
    private static final int MAX_THROWABLES = 10;
    public static final List<Throwable> throwables;

    public static void init(boolean bl, int n) {
        if (bl && System.out == realOut && System.err == realErr) {
            System.setOut(Log.createPrintStream(5, null));
            System.setErr(Log.createPrintStream(9, null));
        }
        level = n;
        Log.log(3, Log.class, "When reporting bugs, please include the following information:");
        String[] stringArray = new String[]{"java.version", "java.vm.version", "java.runtime.version", "java.vendor", "java.compiler", "os.name", "os.version", "os.arch", "user.home", "java.home", "java.class.path"};
        for (int i = 0; i < stringArray.length; ++i) {
            Log.log(3, Log.class, stringArray[i] + '=' + System.getProperty(stringArray[i]));
        }
    }

    public static void setLogWriter(Writer writer) {
        if (stream == null && writer != null) {
            try {
                int n;
                if (wrap) {
                    for (n = logLineCount; n < log.length; ++n) {
                        writer.write(log[n]);
                        writer.write(lineSep);
                    }
                }
                for (n = 0; n < logLineCount; ++n) {
                    writer.write(log[n]);
                    writer.write(lineSep);
                }
                writer.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stream = writer;
    }

    public static void flushStream() {
        if (stream != null) {
            try {
                stream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(realErr);
            }
        }
    }

    public static void closeStream() {
        if (stream != null) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace(realErr);
            }
        }
    }

    public static ListModel getLogListModel() {
        return listModel;
    }

    public static void log(int n, Object object, Object object2, Throwable throwable) {
        Log.log(n, object, object2);
        Log.log(n, object, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int n, Object object, Object object2) {
        int n2;
        String string;
        if (object == null) {
            string = Thread.currentThread().getName();
            if (string == null) {
                string = Thread.currentThread().getClass().getName();
            }
        } else {
            string = object instanceof Class ? ((Class)object).getName() : object.getClass().getName();
        }
        if ((n2 = string.lastIndexOf(46)) != -1) {
            string = string.substring(n2 + 1);
        }
        if (object2 instanceof Throwable) {
            Log._logException(n, object, (Throwable)object2);
        } else {
            String string2 = String.valueOf(object2);
            Object object3 = LOCK;
            synchronized (object3) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\r\n");
                int n3 = 0;
                boolean bl = wrap;
                while (stringTokenizer.hasMoreTokens()) {
                    ++n3;
                    Log._log(n, string, stringTokenizer.nextToken().replace('\t', ' '));
                }
                listModel.update(n3, bl);
            }
        }
    }

    private static PrintStream createPrintStream(int n, Object object) {
        return new LogPrintStream(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _logException(int n, Object object, Throwable throwable) {
        Object object2;
        PrintStream printStream = Log.createPrintStream(n, object);
        if (n >= level) {
            object2 = throwables;
            synchronized (object2) {
                if (throwables.size() == 10) {
                    throwables.remove(0);
                }
                throwables.add(throwable);
            }
        }
        object2 = LOCK;
        synchronized (object2) {
            throwable.printStackTrace(printStream);
        }
    }

    private static void _log(int n, String string, String string2) {
        String string3 = timeFormat.format(new Date()) + " [" + Thread.currentThread().getName() + "] [" + Log.urgencyToString(n) + "] " + string + ": " + string2;
        try {
            Log.log[Log.logLineCount] = string3;
            if (++logLineCount >= log.length) {
                wrap = true;
                logLineCount = 0;
            }
            if (stream != null) {
                stream.write(string3);
                stream.write(lineSep);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(realErr);
        }
        if (n >= level) {
            if (n == 9) {
                realErr.println(string3);
            } else {
                realOut.println(string3);
            }
        }
    }

    private static String urgencyToString(int n) {
        switch (n) {
            case 1: {
                return "debug";
            }
            case 3: {
                return "message";
            }
            case 5: {
                return "notice";
            }
            case 7: {
                return "warning";
            }
            case 9: {
                return "error";
            }
        }
        throw new IllegalArgumentException("Invalid urgency: " + n);
    }

    static {
        level = 7;
        realOut = System.out;
        realErr = System.err;
        log = new String[500];
        lineSep = System.getProperty("line.separator");
        listModel = new LogListModel();
        timeFormat = DateFormat.getTimeInstance(2);
        throwables = Collections.synchronizedList(new ArrayList(10));
    }

    private static class LogOutputStream
    extends OutputStream {
        private final int urgency;
        private final Object source;

        LogOutputStream(int n, Object object) {
            this.urgency = n;
            this.source = object;
        }

        public synchronized void write(int n) {
            byte[] byArray = new byte[]{(byte)n};
            this.write(byArray, 0, 1);
        }

        public synchronized void write(byte[] byArray, int n, int n2) {
            String string = new String(byArray, n, n2);
            Log.log(this.urgency, this.source, string);
        }
    }

    private static class LogPrintStream
    extends PrintStream {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private final OutputStream orig = this.out;

        LogPrintStream(int n, Object object) {
            super(new LogOutputStream(n, object));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrintStream printf(String string, Object ... objectArray) {
            OutputStream outputStream = this.orig;
            synchronized (outputStream) {
                this.buffer.reset();
                this.out = this.buffer;
                super.printf(string, objectArray);
                try {
                    try {
                        byte[] byArray = this.buffer.toByteArray();
                        this.orig.write(byArray, 0, byArray.length);
                        this.out = this.orig;
                    }
                    catch (IOException iOException) {
                        Object var6_7 = null;
                        this.buffer.reset();
                    }
                    Object var6_6 = null;
                    this.buffer.reset();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.buffer.reset();
                    throw throwable;
                }
            }
            return this;
        }
    }

    static class LogListModel
    implements ListModel {
        final List<ListDataListener> listeners = new ArrayList<ListDataListener>();

        LogListModel() {
        }

        private void fireIntervalAdded(int n, int n2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListDataListener listDataListener = this.listeners.get(i);
                listDataListener.intervalAdded(new ListDataEvent(this, 1, n, n2));
            }
        }

        private void fireIntervalRemoved(int n, int n2) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ListDataListener listDataListener = this.listeners.get(i);
                listDataListener.intervalRemoved(new ListDataEvent(this, 2, n, n2));
            }
        }

        public void addListDataListener(ListDataListener listDataListener) {
            this.listeners.add(listDataListener);
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }

        public Object getElementAt(int n) {
            if (wrap) {
                if (n < 500 - logLineCount) {
                    return log[n + logLineCount];
                }
                return log[n - 500 + logLineCount];
            }
            return log[n];
        }

        public int getSize() {
            if (wrap) {
                return 500;
            }
            return logLineCount;
        }

        void update(final int n, final boolean bl) {
            if (n == 0 || this.listeners.isEmpty()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (wrap) {
                        if (bl) {
                            LogListModel.this.fireIntervalRemoved(0, n - 1);
                        } else {
                            LogListModel.this.fireIntervalRemoved(0, logLineCount);
                        }
                        LogListModel.this.fireIntervalAdded(500 - n + 1, 500);
                    } else {
                        LogListModel.this.fireIntervalAdded(logLineCount - n + 1, logLineCount);
                    }
                }
            });
        }
    }
}

