/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;

public class TextAreaTransferHandler
extends TransferHandler {
    private static JEditTextArea dragSource;
    private static boolean compoundEdit;
    private static boolean sameTextArea;
    private static int insertPos;
    private static int insertOffset;

    protected Transferable createTransferable(JComponent jComponent) {
        Log.log(1, this, "createTransferable()");
        JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
        if (jEditTextArea.getSelectionCount() == 0) {
            return null;
        }
        dragSource = jEditTextArea;
        return new TextAreaSelection(jEditTextArea);
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        boolean bl;
        Log.log(1, this, "Import data");
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                bl = this.importFile(jComponent, transferable);
            } else {
                DataFlavor dataFlavor = null;
                DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                for (int i = 0; i < dataFlavorArray.length; ++i) {
                    DataFlavor dataFlavor2 = dataFlavorArray[i];
                    if (!"text".equals(dataFlavor2.getPrimaryType()) || !"uri-list".equals(dataFlavor2.getSubType()) || dataFlavor2.getRepresentationClass() != String.class) continue;
                    dataFlavor = dataFlavor2;
                    break;
                }
                bl = dataFlavor != null && transferable.isDataFlavorSupported(dataFlavor) ? this.importURIList(jComponent, transferable, dataFlavor) : this.importText(jComponent, transferable);
            }
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
            bl = false;
        }
        GUIUtilities.getView(jComponent).toFront();
        GUIUtilities.getView(jComponent).requestFocus();
        jComponent.requestFocus();
        return bl;
    }

    private boolean importFile(JComponent jComponent, Transferable transferable) throws Exception {
        Log.log(1, this, "=> File list");
        EditPane editPane = (EditPane)GUIUtilities.getComponentParent(jComponent, EditPane.class);
        View view = editPane.getView();
        Buffer buffer = null;
        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        boolean bl = false;
        BufferSetManager bufferSetManager = jEdit.getBufferSetManager();
        for (File file : list) {
            if (file.isDirectory()) {
                if (bl) continue;
                VFSBrowser.browseDirectory(view, file.getPath());
                bl = true;
                continue;
            }
            Buffer buffer2 = jEdit.openFile(editPane, file.getPath());
            if (buffer2 == null) continue;
            buffer = buffer2;
            bufferSetManager.addBuffer(editPane, buffer);
        }
        if (buffer != null) {
            editPane.setBuffer(buffer);
        }
        view.toFront();
        view.requestFocus();
        editPane.requestFocus();
        return true;
    }

    private boolean importURIList(JComponent jComponent, Transferable transferable, DataFlavor dataFlavor) throws Exception {
        String string = (String)transferable.getTransferData(dataFlavor);
        Log.log(1, this, "=> URIList \"" + string + '\"');
        EditPane editPane = (EditPane)GUIUtilities.getComponentParent(jComponent, EditPane.class);
        View view = editPane.getView();
        JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
        if (dragSource == null) {
            boolean bl = false;
            String[] stringArray = string.split("\r\n");
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.length() > 0) {
                    URI uRI = new URI(string2);
                    if ("file".equals(uRI.getScheme())) {
                        File file = new File(uRI.getPath());
                        if (file.isDirectory()) {
                            if (!bl2) {
                                VFSBrowser.browseDirectory(view, file.getPath());
                                bl2 = true;
                            }
                        } else {
                            VFSManager.runInWorkThread(new DraggedURLLoader(jEditTextArea, uRI.getPath()));
                        }
                        bl = true;
                        continue;
                    }
                    Log.log(1, this, "I do not know how to handle this URI " + uRI + ", ignoring.");
                    continue;
                }
                if (i == stringArray.length - 1) continue;
                Log.log(1, this, "Odd: there is an empty line in the uri list which is not the last line.");
            }
            if (bl) {
                return true;
            }
        }
        return true;
    }

    private boolean importText(JComponent jComponent, Transferable transferable) throws Exception {
        int n;
        Object object;
        int n2;
        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        string = string.trim();
        Log.log(1, this, "=> String \"" + string + '\"');
        JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
        if (dragSource == null) {
            n2 = 0;
            object = string.split("\n");
            for (n = 0; n < ((String[])object).length; ++n) {
                String string2 = object[n];
                VFS vFS = VFSManager.getVFSForPath(string2);
                if (!(vFS instanceof FileVFS) || string.startsWith("file://")) {
                    if (string2.startsWith("file://")) {
                        string2 = string2.substring(7);
                    }
                    VFSManager.runInWorkThread(new DraggedURLLoader(jEditTextArea, string2));
                }
                n2 = 1;
            }
            if (n2 != 0) {
                return true;
            }
        }
        if (dragSource != null && jEditTextArea.getBuffer() == dragSource.getBuffer()) {
            compoundEdit = true;
            jEditTextArea.getBuffer().beginCompoundEdit();
        }
        sameTextArea = jEditTextArea == dragSource;
        n2 = jEditTextArea.getCaretPosition();
        object = jEditTextArea.getSelectionAtOffset(n2);
        if (object != null) {
            if (sameTextArea) {
                return false;
            }
            n = object.start;
            jEditTextArea.setSelectedText((Selection)object, string);
            jEditTextArea.setSelection(new Selection.Range(n, n + string.length()));
        } else if (sameTextArea) {
            insertPos = n2;
            insertOffset = 0;
            Selection[] selectionArray = jEditTextArea.getSelection();
            for (int i = 0; i < selectionArray.length; ++i) {
                if (selectionArray[i].end >= insertPos + insertOffset) continue;
                insertOffset -= selectionArray[i].end - selectionArray[i].start;
            }
        } else {
            jEditTextArea.getBuffer().insert(n2, string);
            jEditTextArea.setSelection(new Selection.Range(n2, n2 + string.length()));
        }
        jEditTextArea.scrollToCaret(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        JEditTextArea jEditTextArea;
        block12: {
            Log.log(1, this, "Export done");
            jEditTextArea = (JEditTextArea)jComponent;
            try {
                if (n == 0) {
                    Log.log(1, this, "Export impossible");
                    Object var7_5 = null;
                    if (compoundEdit) {
                        compoundEdit = false;
                        jEditTextArea.getBuffer().endCompoundEdit();
                    }
                    return;
                }
                if (transferable == null) {
                    Log.log(1, this, "=> Null transferrable");
                    jEditTextArea.selectNone();
                    break block12;
                }
                if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) break block12;
                Log.log(1, this, "=> String");
                if (sameTextArea) {
                    if (n == 2) {
                        jEditTextArea.setSelectedText(null, false);
                        insertPos += insertOffset;
                    }
                    try {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        jEditTextArea.getBuffer().insert(insertPos, string);
                        jEditTextArea.setSelection(new Selection.Range(insertPos, insertPos + string.length()));
                    }
                    catch (Exception exception) {
                        Log.log(1, this, "exportDone in sameTextArea");
                        Log.log(1, this, exception);
                    }
                    break block12;
                }
                if (n == 2) {
                    jEditTextArea.setSelectedText(null, false);
                    break block12;
                }
                jEditTextArea.selectNone();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (compoundEdit) {
                    compoundEdit = false;
                    jEditTextArea.getBuffer().endCompoundEdit();
                }
                throw throwable;
            }
        }
        Object var7_6 = null;
        if (compoundEdit) {
            compoundEdit = false;
            jEditTextArea.getBuffer().endCompoundEdit();
        }
        dragSource = null;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        JEditTextArea jEditTextArea = (JEditTextArea)jComponent;
        boolean bl = false;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (dataFlavorArray[i].equals(DataFlavor.javaFileListFlavor)) {
                bl = true;
                continue;
            }
            if (dataFlavorArray[i].equals(DataFlavor.stringFlavor)) {
                if (!jEditTextArea.isEditable()) continue;
                bl = true;
                continue;
            }
            if (!dataFlavorArray[i].getRepresentationClass().equals(InputStream.class)) continue;
            bl = true;
            break;
        }
        Log.log(1, this, "canImport() returning " + bl);
        return bl;
    }

    private static class DraggedURLLoader
    extends WorkRequest {
        private final JEditTextArea textArea;
        private final String url;

        DraggedURLLoader(JEditTextArea jEditTextArea, String string) {
            this.textArea = jEditTextArea;
            this.url = string;
        }

        public void run() {
            EditPane editPane = EditPane.get(this.textArea);
            jEdit.openFile(editPane, this.url);
        }
    }

    private static class TextAreaSelection
    extends StringSelection {
        final JEditTextArea textArea;

        TextAreaSelection(JEditTextArea jEditTextArea) {
            super(jEditTextArea.getSelectedText());
            this.textArea = jEditTextArea;
        }
    }
}

