/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;

public interface StructureMatcher {
    public Match getMatch(TextArea var1);

    public void selectMatch(TextArea var1);

    public static class Highlight
    extends TextAreaExtension {
        private TextArea textArea;

        Highlight(TextArea textArea) {
            this.textArea = textArea;
        }

        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            if (!this.textArea.getPainter().isStructureHighlightEnabled()) {
                return;
            }
            Match match = this.textArea.getStructureMatch();
            if (match != null) {
                this.paintHighlight(graphics2D, n, n3, n4, n5, match);
            }
        }

        private int[] getOffsets(int n, Match match) {
            int n2 = this.textArea.getScreenLineOfOffset(match.start);
            int n3 = this.textArea.getScreenLineOfOffset(match.end);
            int n4 = n2 == n ? match.start : this.textArea.getScreenLineStartOffset(n);
            int n5 = n3 == n ? match.end : this.textArea.getScreenLineEndOffset(n) - 1;
            return new int[]{this.textArea.offsetToXY((int)n4).x, this.textArea.offsetToXY((int)n5).x};
        }

        private void paintHighlight(Graphics graphics, int n, int n2, int n3, int n4, Match match) {
            if (!this.textArea.isStructureHighlightVisible()) {
                return;
            }
            if (match.start >= n3 || match.end < n2) {
                return;
            }
            int n5 = this.textArea.getScreenLineOfOffset(match.start);
            int n6 = this.textArea.getScreenLineOfOffset(match.end);
            FontMetrics fontMetrics = this.textArea.getPainter().getFontMetrics();
            int n7 = fontMetrics.getHeight();
            int[] nArray = this.getOffsets(n, match);
            int n8 = nArray[0];
            int n9 = nArray[1];
            graphics.setColor(this.textArea.getPainter().getStructureHighlightColor());
            graphics.drawLine(n8, n4, n8, n4 + n7 - 1);
            graphics.drawLine(n9, n4, n9, n4 + n7 - 1);
            if (n5 == n || n == 0) {
                graphics.drawLine(n8, n4, n9, n4);
            } else {
                nArray = this.getOffsets(n - 1, match);
                int n10 = nArray[0];
                int n11 = nArray[1];
                graphics.drawLine(Math.min(n8, n10), n4, Math.max(n8, n10), n4);
                graphics.drawLine(Math.min(n9, n11), n4, Math.max(n9, n11), n4);
            }
            if (n6 == n) {
                graphics.drawLine(n8, n4 + n7 - 1, n9, n4 + n7 - 1);
            }
        }
    }

    public static class Match {
        public StructureMatcher matcher;
        public int startLine;
        public int start;
        public int endLine;
        public int end;

        public Match() {
        }

        public Match(StructureMatcher structureMatcher) {
            this.matcher = structureMatcher;
        }

        public Match(StructureMatcher structureMatcher, int n, int n2, int n3, int n4) {
            this(structureMatcher);
            this.startLine = n;
            this.start = n2;
            this.endLine = n3;
            this.end = n4;
        }
    }

    public static class BracketMatcher
    implements StructureMatcher {
        public Match getMatch(TextArea textArea) {
            int n;
            int n2 = textArea.getCaretPosition() - textArea.getLineStartOffset(textArea.getCaretLine());
            if (n2 != 0 && (n = TextUtilities.findMatchingBracket(textArea.getBuffer(), textArea.getCaretLine(), n2 - 1)) != -1) {
                int n3 = textArea.getLineOfOffset(n);
                return new Match(this, n3, n, n3, n + 1);
            }
            return null;
        }

        public void selectMatch(TextArea textArea) {
            textArea.selectToMatchingBracket();
        }
    }
}

