/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.StandardUtilities;

public abstract class Selection
implements Cloneable {
    int start;
    int end;
    int startLine;
    int endLine;

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public abstract int getStart(JEditBuffer var1, int var2);

    public abstract int getEnd(JEditBuffer var1, int var2);

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public boolean overlaps(Selection selection) {
        return this.start >= selection.start && this.start <= selection.end || this.end >= selection.start && this.end <= selection.end;
    }

    public String toString() {
        return this.getClass().getName() + "[start=" + this.start + ",end=" + this.end + ",startLine=" + this.startLine + ",endLine=" + this.endLine + ']';
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("I just drank a whole bottle of cough syrup and I feel funny!");
        }
    }

    protected Selection() {
    }

    protected Selection(Selection selection) {
        this.start = selection.start;
        this.end = selection.end;
    }

    protected Selection(int n, int n2) {
        this.start = n;
        this.end = n2;
    }

    abstract void getText(JEditBuffer var1, StringBuilder var2);

    abstract int setText(JEditBuffer var1, String var2);

    abstract boolean contentInserted(JEditBuffer var1, int var2, int var3, int var4, int var5);

    abstract boolean contentRemoved(JEditBuffer var1, int var2, int var3, int var4, int var5);

    public static class Rect
    extends Selection {
        int extraStartVirt;
        int extraEndVirt;

        public Rect() {
        }

        public Rect(Selection selection) {
            super(selection);
        }

        public Rect(int n, int n2) {
            super(n, n2);
        }

        public Rect(int n, int n2, int n3, int n4) {
            this.startLine = n;
            this.start = n2;
            this.endLine = n3;
            this.end = n4;
        }

        public Rect(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
            int n5;
            this.startLine = n;
            this.endLine = n3;
            int[] nArray = new int[1];
            int n6 = jEditBuffer.getOffsetOfVirtualColumn(n, n2, nArray);
            if (n6 == -1) {
                this.extraStartVirt = n2 - nArray[0];
            }
            if ((n5 = jEditBuffer.getOffsetOfVirtualColumn(n3, n4, nArray)) == -1) {
                this.extraEndVirt = n4 - nArray[0];
            }
        }

        public int getStartColumn(JEditBuffer jEditBuffer) {
            int n = jEditBuffer.getVirtualWidth(this.startLine, this.start - jEditBuffer.getLineStartOffset(this.startLine)) + this.extraStartVirt;
            int n2 = jEditBuffer.getVirtualWidth(this.endLine, this.end - jEditBuffer.getLineStartOffset(this.endLine)) + this.extraEndVirt;
            return Math.min(n, n2);
        }

        public int getEndColumn(JEditBuffer jEditBuffer) {
            int n = jEditBuffer.getVirtualWidth(this.startLine, this.start - jEditBuffer.getLineStartOffset(this.startLine)) + this.extraStartVirt;
            int n2 = jEditBuffer.getVirtualWidth(this.endLine, this.end - jEditBuffer.getLineStartOffset(this.endLine)) + this.extraEndVirt;
            return Math.max(n, n2);
        }

        public int getStart(JEditBuffer jEditBuffer, int n) {
            return Rect.getColumnOnOtherLine(jEditBuffer, n, this.getStartColumn(jEditBuffer));
        }

        public int getEnd(JEditBuffer jEditBuffer, int n) {
            return Rect.getColumnOnOtherLine(jEditBuffer, n, this.getEndColumn(jEditBuffer));
        }

        void getText(JEditBuffer jEditBuffer, StringBuilder stringBuilder) {
            int n = this.getStartColumn(jEditBuffer);
            int n2 = this.getEndColumn(jEditBuffer);
            for (int i = this.startLine; i <= this.endLine; ++i) {
                int n3;
                int n4 = jEditBuffer.getLineStartOffset(i);
                int n5 = jEditBuffer.getLineLength(i);
                int n6 = jEditBuffer.getOffsetOfVirtualColumn(i, n, null);
                if (n6 == -1) {
                    n6 = n5;
                }
                if ((n3 = jEditBuffer.getOffsetOfVirtualColumn(i, n2, null)) == -1) {
                    n3 = n5;
                }
                if (n3 < n6) {
                    System.err.println(i + ":::" + n + ':' + n2 + " ==> " + n6 + ':' + n3);
                }
                stringBuilder.append(jEditBuffer.getText(n4 + n6, n3 - n6));
                if (i == this.endLine) continue;
                stringBuilder.append('\n');
            }
        }

        int setText(JEditBuffer jEditBuffer, String string) {
            int n;
            int n2;
            int n3;
            int n4 = this.getStartColumn(jEditBuffer);
            int n5 = this.getEndColumn(jEditBuffer);
            int n6 = jEditBuffer.getTabSize();
            int n7 = 0;
            int n8 = 0;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (string != null) {
                n3 = 0;
                int n9 = n4;
                for (n2 = 0; n2 < string.length(); ++n2) {
                    n = string.charAt(n2);
                    if (n == 10) {
                        ++n8;
                        arrayList.add(string.substring(n3, n2));
                        n3 = n2 + 1;
                        n7 = Math.max(n7, n9);
                        arrayList.add(n9);
                        n9 = n4;
                        continue;
                    }
                    if (n == 9) {
                        n9 += n6 - n9 % n6;
                        continue;
                    }
                    ++n9;
                }
                if (n3 != string.length()) {
                    ++n8;
                    arrayList.add(string.substring(n3));
                    arrayList.add(n9);
                    n7 = Math.max(n7, n9);
                }
            }
            n3 = 0;
            int[] nArray = new int[1];
            n2 = Math.max(this.startLine + n8 - 1, this.endLine);
            for (n = this.startLine; n <= n2; ++n) {
                int n10;
                int n11;
                if (n == jEditBuffer.getLineCount()) {
                    jEditBuffer.insert(jEditBuffer.getLength(), "\n");
                }
                int n12 = jEditBuffer.getLineStartOffset(n);
                int n13 = jEditBuffer.getLineLength(n);
                int n14 = jEditBuffer.getOffsetOfVirtualColumn(n, n4, nArray);
                if (n14 == -1) {
                    n11 = n4 - nArray[0];
                    n14 = n13;
                } else {
                    n11 = 0;
                }
                int n15 = jEditBuffer.getOffsetOfVirtualColumn(n, n5, null);
                if (n15 == -1) {
                    n15 = n13;
                }
                jEditBuffer.remove(n14 + n12, n15 - n14);
                if (n11 != 0) {
                    jEditBuffer.insert(n14 + n12, StandardUtilities.createWhiteSpace(n11, 0));
                }
                if (n8 == 0) {
                    n10 = n15 == n13 ? 0 : n7 - n4;
                } else {
                    int n16 = 2 * ((n - this.startLine) % n8);
                    String string2 = (String)arrayList.get(n16);
                    jEditBuffer.insert(n14 + n12 + n11, string2);
                    n10 = n15 == n13 ? 0 : n7 - (Integer)arrayList.get(n16 + 1);
                    n11 += string2.length();
                }
                if (n10 != 0) {
                    jEditBuffer.insert(n14 + n12 + n11, StandardUtilities.createWhiteSpace(n10, 0));
                }
                n3 = n14 + n12 + n11 + n10;
            }
            if (string == null || string.length() == 0) {
                return this.end;
            }
            return n3;
        }

        boolean contentInserted(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
            int n5;
            if (this.end < n2) {
                return false;
            }
            this.end += n4;
            if (this.startLine > n) {
                this.start += n4;
                if (n3 != 0) {
                    this.startLine = jEditBuffer.getLineOfOffset(this.start);
                    this.endLine = jEditBuffer.getLineOfOffset(this.end);
                }
                return true;
            }
            int n6 = jEditBuffer.getVirtualWidth(this.endLine, this.end - jEditBuffer.getLineStartOffset(this.endLine));
            if (this.start == n2) {
                int[] nArray;
                n5 = jEditBuffer.getVirtualWidth(this.startLine, n2 - jEditBuffer.getLineStartOffset(this.startLine));
                this.start += n4;
                int n7 = jEditBuffer.getVirtualWidth(n, n2 - jEditBuffer.getLineStartOffset(this.startLine));
                int n8 = jEditBuffer.getOffsetOfVirtualColumn(this.endLine, n6 + n7 - n5, nArray = new int[1]);
                if (n8 != -1) {
                    this.end = jEditBuffer.getLineStartOffset(this.endLine) + n8;
                } else {
                    this.end = jEditBuffer.getLineEndOffset(this.endLine) - 1;
                    this.extraEndVirt = nArray[0] - n6;
                }
            } else if (this.start > n2) {
                this.start += n4;
                if (n3 != 0) {
                    this.startLine = jEditBuffer.getLineOfOffset(this.start);
                }
            }
            if (n3 != 0) {
                this.endLine = jEditBuffer.getLineOfOffset(this.end);
            }
            n5 = jEditBuffer.getVirtualWidth(this.endLine, this.end - jEditBuffer.getLineStartOffset(this.endLine));
            if (n == this.endLine && this.extraEndVirt != 0) {
                this.extraEndVirt += n6 - n5;
            } else if (n == this.startLine && this.extraStartVirt != 0) {
                this.extraStartVirt += n6 - n5;
            }
            return true;
        }

        boolean contentRemoved(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
            int n5 = n2 + n4;
            boolean bl = false;
            if (this.start > n2 && this.start <= n5) {
                this.start = n2;
                bl = true;
            } else if (this.start > n5) {
                this.start -= n4;
                bl = true;
            }
            if (this.end > n2 && this.end <= n5) {
                this.end = n2;
                bl = true;
            } else if (this.end > n5) {
                this.end -= n4;
                bl = true;
            }
            if (bl && n3 != 0) {
                this.startLine = jEditBuffer.getLineOfOffset(this.start);
                this.endLine = jEditBuffer.getLineOfOffset(this.end);
            }
            return bl;
        }

        private static int getColumnOnOtherLine(JEditBuffer jEditBuffer, int n, int n2) {
            int n3 = jEditBuffer.getOffsetOfVirtualColumn(n, n2, null);
            if (n3 == -1) {
                return jEditBuffer.getLineEndOffset(n) - 1;
            }
            return jEditBuffer.getLineStartOffset(n) + n3;
        }
    }

    public static class Range
    extends Selection {
        public Range() {
        }

        public Range(Selection selection) {
            super(selection);
        }

        public Range(int n, int n2) {
            super(n, n2);
        }

        public int getStart(JEditBuffer jEditBuffer, int n) {
            if (n == this.startLine) {
                return this.start;
            }
            return jEditBuffer.getLineStartOffset(n);
        }

        public int getEnd(JEditBuffer jEditBuffer, int n) {
            if (n == this.endLine) {
                return this.end;
            }
            return jEditBuffer.getLineEndOffset(n) - 1;
        }

        void getText(JEditBuffer jEditBuffer, StringBuilder stringBuilder) {
            stringBuilder.append(jEditBuffer.getText(this.start, this.end - this.start));
        }

        int setText(JEditBuffer jEditBuffer, String string) {
            jEditBuffer.remove(this.start, this.end - this.start);
            if (string != null && string.length() != 0) {
                jEditBuffer.insert(this.start, string);
                return this.start + string.length();
            }
            return this.start;
        }

        boolean contentInserted(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
            boolean bl = false;
            if (this.start >= n2) {
                this.start += n4;
                if (n3 != 0) {
                    this.startLine = jEditBuffer.getLineOfOffset(this.start);
                }
                bl = true;
            }
            if (this.end >= n2) {
                this.end += n4;
                if (n3 != 0) {
                    this.endLine = jEditBuffer.getLineOfOffset(this.end);
                }
                bl = true;
            }
            return bl;
        }

        boolean contentRemoved(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
            int n5 = n2 + n4;
            boolean bl = false;
            if (this.start > n2 && this.start <= n5) {
                this.start = n2;
                bl = true;
            } else if (this.start > n5) {
                this.start -= n4;
                bl = true;
            }
            if (this.end > n2 && this.end <= n5) {
                this.end = n2;
                bl = true;
            } else if (this.end > n5) {
                this.end -= n4;
                bl = true;
            }
            if (bl && n3 != 0) {
                this.startLine = jEditBuffer.getLineOfOffset(this.start);
                this.endLine = jEditBuffer.getLineOfOffset(this.end);
            }
            return bl;
        }
    }
}

