/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ScrollLayout
implements LayoutManager {
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String BOTTOM = "bottom";
    public static final String TOP = "top";
    private Component center;
    private Component left;
    private Component right;
    private Component bottom;
    private Component top;

    public void addLayoutComponent(String string, Component component) {
        if (string.equals(CENTER)) {
            this.center = component;
        } else if (string.equals(RIGHT)) {
            this.right = component;
        } else if (string.equals(LEFT)) {
            this.left = component;
        } else if (string.equals(BOTTOM)) {
            this.bottom = component;
        } else if (string.equals(TOP)) {
            this.top = component;
        }
    }

    public void removeLayoutComponent(Component component) {
        if (this.center == component) {
            this.center = null;
        } else if (this.right == component) {
            this.right = null;
        } else if (this.left == component) {
            this.left = null;
        } else if (this.bottom == component) {
            this.bottom = null;
        } else if (this.top == component) {
            this.top = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        Insets insets = this.getInsets(container);
        dimension.width = insets.left + insets.right;
        dimension.height = insets.top + insets.bottom;
        Dimension dimension2 = this.left.getPreferredSize();
        dimension.width += dimension2.width;
        Dimension dimension3 = this.center.getPreferredSize();
        dimension.width += dimension3.width;
        dimension.height += dimension3.height;
        Dimension dimension4 = this.right.getPreferredSize();
        dimension.width += dimension4.width;
        Dimension dimension5 = this.bottom.getPreferredSize();
        dimension.height += dimension5.height;
        if (this.top != null) {
            Dimension dimension6 = this.top.getPreferredSize();
            dimension.height += dimension6.height;
        }
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        Insets insets = this.getInsets(container);
        dimension.width = insets.left + insets.right;
        dimension.height = insets.top + insets.bottom;
        Dimension dimension2 = this.left.getMinimumSize();
        dimension.width += dimension2.width;
        Dimension dimension3 = this.center.getMinimumSize();
        dimension.width += dimension3.width;
        dimension.height += dimension3.height;
        Dimension dimension4 = this.right.getMinimumSize();
        dimension.width += dimension4.width;
        Dimension dimension5 = this.bottom.getMinimumSize();
        dimension.height += dimension5.height;
        if (this.top != null) {
            Dimension dimension6 = this.top.getMinimumSize();
            dimension.height += dimension6.height;
        }
        return dimension;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = this.getInsets(container);
        int n = insets.top;
        int n2 = insets.left;
        int n3 = insets.bottom;
        int n4 = insets.right;
        int n5 = this.right.getPreferredSize().width;
        int n6 = this.left.getPreferredSize().width;
        int n7 = this.top != null ? this.top.getPreferredSize().height : 0;
        int n8 = this.bottom.getPreferredSize().height;
        int n9 = Math.max(0, dimension.width - n6 - n5 - n2 - n4);
        int n10 = Math.max(0, dimension.height - n7 - n8 - n - n3);
        this.left.setBounds(n2, n + n7, n6, n10);
        this.center.setBounds(n2 + n6, n + n7, n9, n10);
        this.right.setBounds(n2 + n6 + n9, n + n7, n5, n10);
        this.bottom.setBounds(n2, n + n7 + n10, Math.max(0, dimension.width - this.bottom.getHeight() - n2 - n4), n8);
        if (this.top != null) {
            this.top.setBounds(n2, n, n6 + n9 + n5, n7);
        }
    }

    private Insets getInsets(Component component) {
        Border border = ((JComponent)component).getBorder();
        if (border == null) {
            return new Insets(0, 0, 0, 0);
        }
        return border.getBorderInsets(component);
    }
}

