/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.BufferHandler;
import org.gjt.sp.jedit.textarea.FirstLine;
import org.gjt.sp.jedit.textarea.RangeMap;
import org.gjt.sp.jedit.textarea.ScreenLineManager;
import org.gjt.sp.jedit.textarea.ScrollLineCount;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;

public class DisplayManager {
    private static final Map<JEditBuffer, List<DisplayManager>> bufferMap = new HashMap<JEditBuffer, List<DisplayManager>>();
    final FirstLine firstLine;
    final ScrollLineCount scrollLineCount;
    final ScreenLineManager screenLineMgr;
    RangeMap folds;
    private boolean initialized;
    private boolean inUse;
    private final JEditBuffer buffer;
    private final TextArea textArea;
    private final BufferHandler bufferHandler;

    static DisplayManager getDisplayManager(JEditBuffer jEditBuffer, TextArea textArea) {
        DisplayManager displayManager;
        List<DisplayManager> list = bufferMap.get(jEditBuffer);
        if (list == null) {
            list = new LinkedList<DisplayManager>();
            bufferMap.put(jEditBuffer, list);
        }
        DisplayManager displayManager2 = null;
        Iterator<DisplayManager> iterator = list.iterator();
        while (iterator.hasNext()) {
            displayManager2 = displayManager = iterator.next();
            if (displayManager.inUse || displayManager.textArea != textArea) continue;
            displayManager.inUse = true;
            return displayManager;
        }
        displayManager = new DisplayManager(jEditBuffer, textArea, displayManager2);
        displayManager.inUse = true;
        list.add(displayManager);
        return displayManager;
    }

    void release() {
        this.inUse = false;
    }

    public static void bufferClosed(JEditBuffer jEditBuffer) {
        bufferMap.remove(jEditBuffer);
    }

    static void textAreaDisposed(TextArea textArea) {
        for (List<DisplayManager> list : bufferMap.values()) {
            Iterator<DisplayManager> iterator = list.iterator();
            while (iterator.hasNext()) {
                DisplayManager displayManager = iterator.next();
                if (displayManager.textArea != textArea) continue;
                displayManager.dispose();
                iterator.remove();
            }
        }
    }

    public JEditBuffer getBuffer() {
        return this.buffer;
    }

    public final boolean isLineVisible(int n) {
        return this.folds.search(n) % 2 == 0;
    }

    public int getFirstVisibleLine() {
        return this.folds.first();
    }

    public int getLastVisibleLine() {
        return this.folds.last();
    }

    public int getNextVisibleLine(int n) {
        if (n < 0 || n >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.folds.next(n);
    }

    public int getPrevVisibleLine(int n) {
        if (n < 0 || n >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.folds.prev(n);
    }

    public final int getScreenLineCount(int n) {
        this.updateScreenLineCount(n);
        return this.screenLineMgr.getScreenLineCount(n);
    }

    public final int getScrollLineCount() {
        return this.scrollLineCount.scrollLine;
    }

    public void collapseFold(int n) {
        int n2 = this.buffer.getLineCount();
        int n3 = n2 - 1;
        if (n != 0 && n != this.buffer.getLineCount() - 1 && this.buffer.isFoldStart(n) && !this.isLineVisible(n + 1)) {
            --n;
        }
        int n4 = this.buffer.getFoldLevel(n);
        int n5 = 0;
        if (n != n2 - 1 && this.buffer.getFoldLevel(n + 1) > n4) {
            n5 = n + 1;
            for (int i = n + 1; i < n2; ++i) {
                if (this.buffer.getFoldLevel(i) > n4) continue;
                n3 = i - 1;
                break;
            }
        } else {
            int n6;
            boolean bl = false;
            for (n6 = n - 1; n6 >= 0; --n6) {
                if (this.buffer.getFoldLevel(n6) >= n4) continue;
                n5 = n6 + 1;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            for (n6 = n + 1; n6 < n2; ++n6) {
                if (this.buffer.getFoldLevel(n6) >= n4) continue;
                n3 = n6 - 1;
                break;
            }
        }
        this.hideLineRange(n5, n3);
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public int expandFold(int n, boolean bl) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = this.buffer.getLineCount();
        int n6 = n5 - 1;
        if (n == n5 - 1) {
            return -1;
        }
        while (!this.isLineVisible(n)) {
            n3 = this.folds.lookup(this.folds.search(n)) - 1;
            if (!this.isLineVisible(n3)) {
                return -1;
            }
            this.expandFold(n3, bl);
            if (this.isLineVisible(n3 + 1)) continue;
            return -1;
        }
        if (this.isLineVisible(n + 1) && !bl) {
            return -1;
        }
        int n7 = this.buffer.getFoldLevel(n);
        if (this.buffer.getFoldLevel(n + 1) > n7) {
            n3 = n;
            if (!this.isLineVisible(n + 1) && this.folds.search(n + 1) != this.folds.count() - 1) {
                n2 = this.folds.search(n + 1);
                n6 = this.folds.lookup(n2 + 1) - 1;
            } else {
                for (n2 = n + 1; n2 < n5; ++n2) {
                    if (this.buffer.getFoldLevel(n2) > n7) continue;
                    n6 = n2 - 1;
                    break;
                }
            }
        } else {
            if (!bl) {
                return -1;
            }
            for (n3 = n; n3 > 0 && this.buffer.getFoldLevel(n3) >= n7; --n3) {
            }
            n7 = this.buffer.getFoldLevel(n3);
            for (n2 = n + 1; n2 < n5; ++n2) {
                if (this.buffer.getFoldLevel(n2) > n7) continue;
                n6 = n2 - 1;
                break;
            }
        }
        if (bl) {
            this.showLineRange(n3, n6);
        } else {
            n2 = n3 + 1;
            while (n2 <= n6) {
                if (n4 == -1 && this.buffer.isFoldStart(n2)) {
                    n4 = n2;
                }
                this.showLineRange(n2, n2);
                int n8 = this.buffer.getFoldLevel(n2);
                ++n2;
                while (n2 <= n6 && this.buffer.getFoldLevel(n2) > n8) {
                    ++n2;
                }
            }
        }
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
        return n4;
    }

    public void expandAllFolds() {
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public void expandFolds(char c) {
        if (c < '1' || c > '9') {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.expandFolds(c - 49 + 1);
        }
    }

    public void expandFolds(int n) {
        if (this.buffer.getFoldHandler() instanceof IndentFoldHandler) {
            n = (n - 1) * this.buffer.getIndentSize() + 1;
        }
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < this.buffer.getLineCount(); ++i) {
            if (bl && this.buffer.getFoldLevel(i) >= n) continue;
            if (n2 != i) {
                this.hideLineRange(n2, i - 1);
            }
            n2 = i + 1;
            bl = true;
        }
        if (n2 != this.buffer.getLineCount()) {
            this.hideLineRange(n2, this.buffer.getLineCount() - 1);
        }
        this.notifyScreenLineChanges();
        if (this.textArea.getDisplayManager() == this) {
            this.textArea.foldStructureChanged();
        }
    }

    public void narrow(int n, int n2) {
        if (n > n2 || n < 0 || n2 >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(n + ", " + n2);
        }
        if (n < this.getFirstVisibleLine() || n2 > this.getLastVisibleLine()) {
            this.expandAllFolds();
        }
        if (n != 0) {
            this.hideLineRange(0, n - 1);
        }
        if (n2 != this.buffer.getLineCount() - 1) {
            this.hideLineRange(n2 + 1, this.buffer.getLineCount() - 1);
        }
        if (n != this.buffer.getLineCount() - 1 && !this.isLineVisible(n + 1)) {
            this.expandFold(n, false);
        }
        this.textArea.fireNarrowActive();
        this.notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    void init() {
        if (this.initialized) {
            if (!this.buffer.isLoading()) {
                this.resetAnchors();
            }
        } else {
            this.initialized = true;
            this.folds = new RangeMap();
            if (this.buffer.isLoading()) {
                this.folds.reset(this.buffer.getLineCount());
            } else {
                this.bufferHandler.foldHandlerChanged(this.buffer);
            }
            this.notifyScreenLineChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyScreenLineChanges() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "notifyScreenLineChanges()");
        }
        if (this.textArea.getDisplayManager() != this) {
            return;
        }
        try {
            if (this.firstLine.callReset) {
                this.firstLine.reset();
            } else if (this.firstLine.callChanged) {
                this.firstLine.changed();
            }
            if (this.scrollLineCount.callReset) {
                this.scrollLineCount.reset();
                this.firstLine.ensurePhysicalLineIsVisible();
            } else if (this.scrollLineCount.callChanged) {
                this.scrollLineCount.changed();
            }
            if (this.firstLine.callChanged || this.scrollLineCount.callReset || this.scrollLineCount.callChanged) {
                this.textArea.updateScrollBar();
                this.textArea.recalculateLastPhysicalLine();
            }
        }
        finally {
            this.firstLine.callChanged = false;
            this.firstLine.callReset = false;
            this.scrollLineCount.callChanged = false;
            this.scrollLineCount.callReset = false;
        }
    }

    void setFirstLine(int n, int n2) {
        int n3 = this.textArea.getVisibleLines();
        if (n2 >= n + n3) {
            this.firstLine.scrollDown(n2 - n);
            this.textArea.chunkCache.invalidateAll();
        } else if (n2 <= n - n3) {
            this.firstLine.scrollUp(n - n2);
            this.textArea.chunkCache.invalidateAll();
        } else if (n2 > n) {
            this.firstLine.scrollDown(n2 - n);
            this.textArea.chunkCache.scrollDown(n2 - n);
        } else if (n2 < n) {
            this.firstLine.scrollUp(n - n2);
            this.textArea.chunkCache.scrollUp(n - n2);
        }
        this.notifyScreenLineChanges();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFirstPhysicalLine(int n, int n2) {
        int n3 = this.textArea.getFirstLine();
        if (n == 0) {
            if ((n2 -= this.firstLine.skew) < 0) {
                this.firstLine.scrollUp(-n2);
            } else {
                if (n2 <= 0) return;
                this.firstLine.scrollDown(n2);
            }
        } else if (n > 0) {
            this.firstLine.physDown(n, n2);
        } else if (n < 0) {
            this.firstLine.physUp(-n, n2);
        }
        int n4 = this.textArea.getFirstLine();
        int n5 = this.textArea.getVisibleLines();
        if (n4 != n3) {
            if (n4 >= n3 + n5 || n4 <= n3 - n5) {
                this.textArea.chunkCache.invalidateAll();
            } else if (n4 > n3) {
                this.textArea.chunkCache.scrollDown(n4 - n3);
            } else if (n4 < n3) {
                this.textArea.chunkCache.scrollUp(n3 - n4);
            }
        }
        this.notifyScreenLineChanges();
    }

    void invalidateScreenLineCounts() {
        this.screenLineMgr.invalidateScreenLineCounts();
        this.firstLine.callReset = true;
        this.scrollLineCount.callReset = true;
    }

    void updateScreenLineCount(int n) {
        if (!this.screenLineMgr.isScreenLineCountValid(n)) {
            int n2 = this.textArea.chunkCache.getLineSubregionCount(n);
            this.setScreenLineCount(n, n2);
        }
    }

    void bufferLoaded() {
        int n;
        this.folds.reset(this.buffer.getLineCount());
        this.screenLineMgr.reset();
        if (this.textArea.getDisplayManager() == this) {
            this.textArea.propertiesChanged();
            this.init();
        }
        if ((n = this.buffer.getIntegerProperty("collapseFolds", 0)) != 0) {
            this.expandFolds(n);
        }
    }

    void foldHandlerChanged() {
        if (this.buffer.isLoading()) {
            return;
        }
        this.folds.reset(this.buffer.getLineCount());
        this.resetAnchors();
        int n = this.buffer.getIntegerProperty("collapseFolds", 0);
        if (n != 0) {
            this.expandFolds(n);
        }
    }

    private DisplayManager(JEditBuffer jEditBuffer, TextArea textArea, DisplayManager displayManager) {
        this.buffer = jEditBuffer;
        this.screenLineMgr = new ScreenLineManager(jEditBuffer);
        this.textArea = textArea;
        this.scrollLineCount = new ScrollLineCount(this, textArea);
        this.firstLine = new FirstLine(this, textArea);
        this.bufferHandler = new BufferHandler(this, textArea, jEditBuffer);
        jEditBuffer.addBufferListener(this.bufferHandler, 1);
        if (displayManager != null) {
            this.folds = new RangeMap(displayManager.folds);
            this.initialized = true;
        }
    }

    private void resetAnchors() {
        this.firstLine.callReset = true;
        this.scrollLineCount.callReset = true;
        this.notifyScreenLineChanges();
    }

    private void dispose() {
        this.buffer.removeBufferListener(this.bufferHandler);
    }

    private void showLineRange(int n, int n2) {
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "showLineRange(" + n + ',' + n2 + ')');
        }
        for (int i = n; i <= n2; ++i) {
            if (this.isLineVisible(i)) continue;
            int n3 = this.getScreenLineCount(i);
            if (this.firstLine.physicalLine >= i) {
                this.firstLine.scrollLine += n3;
                this.firstLine.callChanged = true;
            }
            this.scrollLineCount.scrollLine += n3;
            this.scrollLineCount.callChanged = true;
        }
        this.folds.show(n, n2);
    }

    private void hideLineRange(int n, int n2) {
        int n3;
        int n4;
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "hideLineRange(" + n + ',' + n2 + ')');
        }
        if (!this.isLineVisible(n4 = n)) {
            n4 = this.getNextVisibleLine(n4);
        }
        while (n4 != -1 && n4 <= n2) {
            n3 = this.getScreenLineCount(n4);
            if (n4 < this.firstLine.physicalLine) {
                this.firstLine.scrollLine -= n3;
                this.firstLine.skew = 0;
                this.firstLine.callChanged = true;
            }
            this.scrollLineCount.scrollLine -= n3;
            this.scrollLineCount.callChanged = true;
            n4 = this.getNextVisibleLine(n4);
        }
        this.folds.hide(n, n2);
        if (!this.isLineVisible(this.firstLine.physicalLine)) {
            n3 = this.getFirstVisibleLine();
            if (this.firstLine.physicalLine < n3) {
                this.firstLine.physicalLine = n3;
                this.firstLine.scrollLine = 0;
            } else {
                this.firstLine.physicalLine = this.getPrevVisibleLine(this.firstLine.physicalLine);
                this.firstLine.scrollLine -= this.getScreenLineCount(this.firstLine.physicalLine);
            }
            this.firstLine.callChanged = true;
        }
    }

    private void setScreenLineCount(int n, int n2) {
        int n3 = this.screenLineMgr.getScreenLineCount(n);
        this.screenLineMgr.setScreenLineCount(n, n2);
        if (n2 == n3) {
            return;
        }
        if (!this.isLineVisible(n)) {
            return;
        }
        if (this.firstLine.physicalLine >= n) {
            if (this.firstLine.physicalLine == n) {
                this.firstLine.callChanged = true;
            } else {
                this.firstLine.scrollLine += n2 - n3;
                this.firstLine.callChanged = true;
            }
        }
        this.scrollLineCount.scrollLine += n2 - n3;
        this.scrollLineCount.callChanged = true;
    }
}

