/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ModeProvider {
    public static ModeProvider instance = new ModeProvider();
    private List<Mode> modes = new ArrayList<Mode>(180);

    public void removeAll() {
        this.modes = new ArrayList<Mode>(180);
    }

    public Mode getMode(String string) {
        for (int i = 0; i < this.modes.size(); ++i) {
            Mode mode = this.modes.get(i);
            if (!mode.getName().equals(string)) continue;
            return mode;
        }
        return null;
    }

    public Mode getModeForFile(String string, String string2) {
        String string3 = string.substring(0, string.length() - (string.endsWith(".gz") ? 3 : 0));
        Mode[] modeArray = this.getModes();
        for (int i = modeArray.length - 1; i >= 0; --i) {
            if (!modeArray[i].accept(string3, string2)) continue;
            return modeArray[i];
        }
        return null;
    }

    public Mode[] getModes() {
        Mode[] modeArray = new Mode[this.modes.size()];
        this.modes.toArray(modeArray);
        return modeArray;
    }

    public void addMode(Mode mode) {
        this.modes.add(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadMode(Mode mode, XModeHandler xModeHandler) {
        BufferedInputStream bufferedInputStream;
        XMLReader xMLReader;
        String string = (String)mode.getProperty("file");
        Log.log(5, this, "Loading edit mode " + string);
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            Log.log(9, this, sAXException);
            return;
        }
        mode.setTokenMarker(xModeHandler.getTokenMarker());
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            InputStream inputStream = ModeProvider.class.getResourceAsStream(string);
            if (inputStream == null) {
                this.error(string, fileNotFoundException);
            }
            bufferedInputStream = new BufferedInputStream(inputStream);
        }
        try {
            try {
                InputSource inputSource = new InputSource(bufferedInputStream);
                inputSource.setSystemId("jedit.jar");
                xMLReader.setContentHandler(xModeHandler);
                xMLReader.setDTDHandler(xModeHandler);
                xMLReader.setEntityResolver(xModeHandler);
                xMLReader.setErrorHandler(xModeHandler);
                xMLReader.parse(inputSource);
                mode.setProperties(xModeHandler.getModeProperties());
            }
            catch (Throwable throwable) {
                this.error(string, throwable);
                Object var9_12 = null;
                IOUtilities.closeQuietly(bufferedInputStream);
                return;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            IOUtilities.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly(bufferedInputStream);
    }

    public void loadMode(Mode mode) {
        XModeHandler xModeHandler = new XModeHandler(mode.getName()){

            public void error(String string, Object object) {
                Log.log(9, this, object);
            }

            public TokenMarker getTokenMarker(String string) {
                Mode mode = ModeProvider.this.getMode(string);
                if (mode == null) {
                    return null;
                }
                return mode.getTokenMarker();
            }
        };
        this.loadMode(mode, xModeHandler);
    }

    protected void error(String string, Throwable throwable) {
        Log.log(9, this, throwable);
    }
}

