/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;

public class Chunk
extends Token {
    private static final char[] EMPTY_TEXT;
    public boolean accessable;
    public boolean visible;
    public boolean initialized;
    public SyntaxStyle style;
    public Color background;
    public float width;
    public GlyphVector gv;
    public String str;
    private float[] positions;
    private static final boolean SUN_JAVA_5;

    public static float paintChunkList(Chunk chunk, Graphics2D graphics2D, float f, float f2, boolean bl) {
        Rectangle rectangle = graphics2D.getClipBounds();
        float f3 = 0.0f;
        while (chunk != null) {
            if (f + f3 + chunk.width > (float)rectangle.x && f + f3 < (float)(rectangle.x + rectangle.width)) {
                if (Debug.CHUNK_PAINT_DEBUG) {
                    graphics2D.draw(new Rectangle2D.Float(f + f3, f2 - 10.0f, chunk.width, 10.0f));
                }
                if (chunk.accessable && chunk.visible) {
                    graphics2D.setFont(chunk.style.getFont());
                    graphics2D.setColor(chunk.style.getForegroundColor());
                    if (bl && chunk.gv != null) {
                        graphics2D.drawGlyphVector(chunk.gv, f + f3, f2);
                    } else if (chunk.str != null) {
                        graphics2D.drawString(chunk.str, (int)(f + f3), (int)f2);
                    }
                }
            }
            f3 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f3;
    }

    public static float paintChunkBackgrounds(Chunk chunk, Graphics2D graphics2D, float f, float f2) {
        Rectangle rectangle = graphics2D.getClipBounds();
        float f3 = 0.0f;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.getHeight();
        while (chunk != null) {
            Color color;
            if (f + f3 + chunk.width > (float)rectangle.x && f + f3 < (float)(rectangle.x + rectangle.width) && chunk.accessable && (color = chunk.background) != null) {
                graphics2D.setColor(color);
                graphics2D.fill(new Rectangle2D.Float(f + f3, f2 - (float)n, f3 + chunk.width - f3, n2));
            }
            f3 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f3;
    }

    public static float offsetToX(Chunk chunk, int n) {
        if (chunk != null && n < chunk.offset) {
            throw new ArrayIndexOutOfBoundsException(n + " < " + chunk.offset);
        }
        float f = 0.0f;
        while (chunk != null) {
            if (chunk.accessable && n < chunk.offset + chunk.length) {
                return f + chunk.offsetToX(n - chunk.offset);
            }
            f += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return f;
    }

    public static int xToOffset(Chunk chunk, float f, boolean bl) {
        float f2 = 0.0f;
        while (chunk != null) {
            if (chunk.accessable && f < f2 + chunk.width) {
                return chunk.xToOffset(f - f2, bl);
            }
            f2 += chunk.width;
            chunk = (Chunk)chunk.next;
        }
        return -1;
    }

    public Chunk(float f, int n, ParserRuleSet parserRuleSet) {
        super((byte)0, n, 0, parserRuleSet);
        this.width = f;
    }

    public Chunk(byte by, int n, int n2, ParserRuleSet parserRuleSet, SyntaxStyle[] syntaxStyleArray, byte by2) {
        super(by, n, n2, parserRuleSet);
        this.accessable = true;
        this.style = syntaxStyleArray[by];
        this.background = this.style.getBackgroundColor();
        if (this.background == null) {
            this.background = syntaxStyleArray[by2].getBackgroundColor();
        }
    }

    public final float[] getPositions() {
        if (this.gv == null) {
            return null;
        }
        if (this.positions == null) {
            this.positions = this.gv.getGlyphPositions(0, this.length, null);
        }
        return this.positions;
    }

    public final float offsetToX(int n) {
        if (!this.visible) {
            return 0.0f;
        }
        return this.getPositions()[n * 2];
    }

    public final int xToOffset(float f, boolean bl) {
        if (!this.visible) {
            if (bl && this.width - f < f) {
                return this.offset + this.length;
            }
            return this.offset;
        }
        float[] fArray = this.getPositions();
        for (int i = 0; i < this.length; ++i) {
            float f2;
            float f3 = fArray[i * 2];
            float f4 = f2 = i == this.length - 1 ? this.width : fArray[i * 2 + 2];
            if (!(f2 > f)) continue;
            if (!bl || f2 - f > f - f3) {
                return this.offset + i;
            }
            return this.offset + i + 1;
        }
        return -1;
    }

    public void init(Segment segment, TabExpander tabExpander, float f, FontRenderContext fontRenderContext) {
        this.initialized = true;
        if (this.accessable) {
            if (this.length == 1 && segment.array[segment.offset + this.offset] == '\t') {
                this.visible = false;
                float f2 = tabExpander.nextTabStop(f, this.offset + this.length);
                this.width = f2 - f;
            } else {
                this.visible = true;
                this.str = new String(segment.array, segment.offset + this.offset, this.length);
                char[] cArray = segment.array;
                int n = segment.offset + this.offset;
                if (SUN_JAVA_5) {
                    char[] cArray2 = new char[this.length];
                    System.arraycopy(cArray, n, cArray2, 0, this.length);
                    cArray = cArray2;
                    n = 0;
                }
                int n2 = n + this.length;
                int n3 = 6;
                Font font = this.style.getFont();
                this.gv = font.layoutGlyphVector(fontRenderContext, cArray, n, n2, n3);
                font.layoutGlyphVector(fontRenderContext, EMPTY_TEXT, 0, 0, n3);
                Rectangle2D rectangle2D = this.gv.getLogicalBounds();
                this.width = (float)rectangle2D.getWidth();
            }
        }
    }

    static {
        String string;
        EMPTY_TEXT = new char[0];
        boolean bl = false;
        String string2 = System.getProperty("java.vendor");
        if (string2 != null && (string2.startsWith("Sun") || string2.startsWith("Apple")) && (string = System.getProperty("java.version")) != null && string.startsWith("1.5")) {
            bl = true;
        }
        SUN_JAVA_5 = bl;
    }
}

