/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.BshMethod;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.TextAreaDialog;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PositionChanging;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.search.BoyerMooreSearchMatcher;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.HyperSearchRequest;
import org.gjt.sp.jedit.search.HyperSearchResults;
import org.gjt.sp.jedit.search.PatternSearchMatcher;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ReverseCharSequence;
import org.gjt.sp.util.StandardUtilities;

public class SearchAndReplace {
    private static String search;
    private static String replace;
    private static BshMethod replaceMethod;
    private static NameSpace replaceNS;
    private static boolean regexp;
    private static boolean ignoreCase;
    private static boolean reverse;
    private static boolean beanshell;
    private static boolean wrap;
    private static SearchMatcher matcher;
    private static SearchFileSet fileset;

    public static void setSearchString(String string) {
        if (string.equals(search)) {
            return;
        }
        search = string;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getSearchString() {
        return search;
    }

    public static void setReplaceString(String string) {
        if (string.equals(replace)) {
            return;
        }
        replace = string;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static String getReplaceString() {
        return replace;
    }

    public static void setIgnoreCase(boolean bl) {
        if (bl == ignoreCase) {
            return;
        }
        ignoreCase = bl;
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getIgnoreCase() {
        return ignoreCase;
    }

    public static void setRegexp(boolean bl) {
        if (bl == regexp) {
            return;
        }
        regexp = bl;
        if (bl && reverse) {
            reverse = false;
        }
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getRegexp() {
        return regexp;
    }

    public static void setReverseSearch(boolean bl) {
        if (bl == reverse) {
            return;
        }
        reverse = bl;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getReverseSearch() {
        return reverse;
    }

    public static void setBeanShellReplace(boolean bl) {
        if (bl == beanshell) {
            return;
        }
        beanshell = bl;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getBeanShellReplace() {
        return beanshell;
    }

    public static void setAutoWrapAround(boolean bl) {
        if (bl == wrap) {
            return;
        }
        wrap = bl;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static boolean getAutoWrapAround() {
        return wrap;
    }

    public static void setSearchMatcher(SearchMatcher searchMatcher) {
        matcher = searchMatcher;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchMatcher getSearchMatcher() throws Exception {
        if (matcher != null) {
            return matcher;
        }
        if (search == null || "".equals(search)) {
            return null;
        }
        if (regexp) {
            Pattern pattern = Pattern.compile(search, PatternSearchMatcher.getFlag(ignoreCase));
            matcher = new PatternSearchMatcher(pattern, ignoreCase);
        } else {
            matcher = new BoyerMooreSearchMatcher(search, ignoreCase);
        }
        return matcher;
    }

    public static void setSearchFileSet(SearchFileSet searchFileSet) {
        fileset = searchFileSet;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static SearchFileSet getSearchFileSet() {
        return fileset;
    }

    public static boolean getSmartCaseReplace() {
        return replace != null && TextUtilities.getStringCase(replace) == 1;
    }

    public static boolean hyperSearch(View view) {
        return SearchAndReplace.hyperSearch(view, false);
    }

    public static boolean hyperSearch(View view, boolean bl) {
        Window window = SearchDialog.getSearchDialog(view);
        if (window == null) {
            window = view;
        }
        SearchAndReplace.record(view, "hyperSearch(view," + bl + ')', false, !bl);
        view.getDockableWindowManager().addDockableWindow("hypersearch-results");
        HyperSearchResults hyperSearchResults = (HyperSearchResults)view.getDockableWindowManager().getDockable("hypersearch-results");
        hyperSearchResults.searchStarted();
        try {
            Selection[] selectionArray;
            SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
            if (searchMatcher == null) {
                view.getToolkit().beep();
                hyperSearchResults.searchFailed();
                return false;
            }
            if (bl) {
                selectionArray = view.getTextArea().getSelection();
                if (selectionArray == null) {
                    hyperSearchResults.searchFailed();
                    return false;
                }
            } else {
                selectionArray = null;
            }
            VFSManager.runInWorkThread(new HyperSearchRequest(view, searchMatcher, hyperSearchResults, selectionArray));
            return true;
        }
        catch (Exception exception) {
            hyperSearchResults.searchFailed();
            SearchAndReplace.handleError(window, exception);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean find(View view) {
        block22: {
            boolean bl;
            block21: {
                boolean bl2;
                String string;
                Window window = SearchDialog.getSearchDialog(view);
                if (window == null || !((Component)window).isShowing()) {
                    window = view;
                }
                if ((string = fileset.getNextFile(view, null)) == null) {
                    GUIUtilities.error(window, "empty-fileset", null);
                    return false;
                }
                boolean bl3 = reverse && fileset instanceof CurrentBufferSet;
                try {
                    try {
                        view.showWaitCursor();
                        SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
                        if (searchMatcher == null) {
                            view.getToolkit().beep();
                            boolean bl4 = false;
                            Object var11_8 = null;
                            view.hideWaitCursor();
                            return bl4;
                        }
                        SearchAndReplace.record(view, "find(view)", false, true);
                        boolean bl5 = false;
                        while (true) {
                            boolean bl6;
                            if (string != null) {
                                JEditTextArea jEditTextArea;
                                Selection selection;
                                Buffer buffer = jEdit.openTemporary(view, null, string, false);
                                string = fileset.getNextFile(view, string);
                                if (buffer == null) continue;
                                if (!buffer.isLoaded()) {
                                    VFSManager.waitForRequests();
                                }
                                int n = view.getBuffer() == buffer && !bl5 ? ((selection = (jEditTextArea = view.getTextArea()).getSelectionAtOffset(jEditTextArea.getCaretPosition())) == null ? jEditTextArea.getCaretPosition() : (bl3 ? selection.getStart() : selection.getEnd())) : (bl3 ? buffer.getLength() : 0);
                                if (!SearchAndReplace.find(view, buffer, n, bl5, bl3)) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl5) {
                                if (!BeanShell.isScriptRunning()) {
                                    view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.search-not-found"));
                                    view.getToolkit().beep();
                                }
                                bl = false;
                                break block21;
                            }
                            if (wrap) {
                                if (!BeanShell.isScriptRunning()) {
                                    view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.auto-wrap"));
                                    if (jEdit.getBooleanProperty("search.beepOnSearchAutoWrap")) {
                                        view.getToolkit().beep();
                                    }
                                }
                                bl6 = true;
                            } else if (BeanShell.isScriptRunning()) {
                                bl6 = false;
                            } else {
                                Object[] objectArray = new Integer[]{bl3 ? 1 : 0};
                                int n = GUIUtilities.confirm(window, "keepsearching", objectArray, 0, 3);
                                boolean bl7 = bl6 = n == 0;
                            }
                            if (bl6) {
                                string = fileset.getFirstFile(view);
                                bl5 = true;
                                continue;
                            }
                            break block22;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        SearchAndReplace.handleError(window, exception);
                        Object var11_12 = null;
                        view.hideWaitCursor();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    view.hideWaitCursor();
                    throw throwable;
                }
                Object var11_9 = null;
                view.hideWaitCursor();
                return bl2;
            }
            Object var11_10 = null;
            view.hideWaitCursor();
            return bl;
        }
        Object var11_11 = null;
        view.hideWaitCursor();
        return false;
    }

    public static boolean find(View view, Buffer buffer, int n) throws Exception {
        return SearchAndReplace.find(view, buffer, n, false, false);
    }

    public static boolean find(View view, Buffer buffer, int n, boolean bl, boolean bl2) throws Exception {
        boolean bl3;
        boolean bl4;
        CharSequence charSequence;
        EditBus.send(new PositionChanging(view.getEditPane()));
        SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
        if (searchMatcher == null) {
            view.getToolkit().beep();
            return false;
        }
        if (bl2) {
            charSequence = new ReverseCharSequence(buffer.getSegment(0, n));
            bl4 = true;
            bl3 = n == buffer.getLength();
        } else {
            charSequence = buffer.getSegment(n, buffer.getLength() - n);
            bl4 = n == 0;
            bl3 = true;
        }
        SearchMatcher.Match match = searchMatcher.nextMatch(charSequence, bl4, bl3, bl, bl2);
        if (match != null) {
            jEdit.commitTemporary(buffer);
            view.setBuffer(buffer, true);
            JEditTextArea jEditTextArea = view.getTextArea();
            if (bl2) {
                jEditTextArea.setSelection(new Selection.Range(n - match.end, n - match.start));
                jEditTextArea.scrollTo(n - match.start, false);
                jEditTextArea.moveCaretPosition(n - match.end);
            } else {
                jEditTextArea.setSelection(new Selection.Range(n + match.start, n + match.end));
                jEditTextArea.moveCaretPosition(n + match.end);
                jEditTextArea.scrollTo(n + match.start, false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean replace(View view) {
        boolean bl;
        Buffer buffer;
        Window window;
        block16: {
            int n;
            SearchMatcher searchMatcher;
            Selection selection;
            int n2;
            Selection[] selectionArray;
            boolean bl2;
            JEditTextArea jEditTextArea;
            block15: {
                window = SearchDialog.getSearchDialog(view);
                if (window == null) {
                    window = view;
                }
                jEditTextArea = view.getTextArea();
                buffer = view.getBuffer();
                if (!buffer.isEditable()) {
                    return false;
                }
                bl2 = SearchAndReplace.getSmartCaseReplace();
                selectionArray = jEditTextArea.getSelection();
                if (selectionArray.length == 0) {
                    view.getToolkit().beep();
                    return false;
                }
                SearchAndReplace.record(view, "replace(view)", true, false);
                n2 = jEditTextArea.getCaretPosition();
                selection = jEditTextArea.getSelectionAtOffset(n2);
                if (selection != null) {
                    n2 = selection.getStart();
                }
                buffer.beginCompoundEdit();
                searchMatcher = SearchAndReplace.getSearchMatcher();
                if (searchMatcher != null) break block15;
                boolean bl3 = false;
                Object var13_12 = null;
                buffer.endCompoundEdit();
                return bl3;
            }
            SearchAndReplace.initReplace();
            int n3 = 0;
            for (n = 0; n < selectionArray.length; ++n) {
                selection = selectionArray[n];
                n3 += SearchAndReplace.replaceInSelection(view, jEditTextArea, buffer, searchMatcher, bl2, selection);
            }
            int n4 = n = !regexp && reverse && fileset instanceof CurrentBufferSet ? 1 : 0;
            if (n != 0) {
                jEditTextArea.moveCaretPosition(n2);
            } else {
                selection = jEditTextArea.getSelectionAtOffset(jEditTextArea.getCaretPosition());
                if (selection != null) {
                    jEditTextArea.moveCaretPosition(selection.getEnd());
                }
            }
            if (!BeanShell.isScriptRunning()) {
                Object[] objectArray = new Object[]{n3, 1};
                view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.replace-all", objectArray));
            }
            if (n3 != 0) break block16;
            view.getToolkit().beep();
            boolean bl4 = false;
            Object var13_13 = null;
            buffer.endCompoundEdit();
            return bl4;
        }
        try {
            bl = true;
            Object var13_14 = null;
        }
        catch (Exception exception) {
            try {
                SearchAndReplace.handleError(window, exception);
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                buffer.endCompoundEdit();
                throw throwable;
            }
            buffer.endCompoundEdit();
            return false;
        }
        buffer.endCompoundEdit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean replace(View view, Buffer buffer, int n, int n2) {
        block10: {
            boolean bl;
            block11: {
                boolean bl2;
                block9: {
                    if (!buffer.isEditable()) {
                        return false;
                    }
                    Window window = SearchDialog.getSearchDialog(view);
                    if (window == null) {
                        window = view;
                    }
                    boolean bl3 = SearchAndReplace.getSmartCaseReplace();
                    try {
                        try {
                            buffer.beginCompoundEdit();
                            SearchMatcher searchMatcher = SearchAndReplace.getSearchMatcher();
                            if (searchMatcher == null) {
                                bl2 = false;
                                Object var10_10 = null;
                                break block9;
                            }
                            SearchAndReplace.initReplace();
                            int n3 = 0;
                            if ((n3 += SearchAndReplace._replace(view, buffer, searchMatcher, n, n2, bl3)) == 0) break block10;
                            bl = true;
                            break block11;
                        }
                        catch (Exception exception) {
                            SearchAndReplace.handleError(window, exception);
                            Object var10_13 = null;
                            buffer.endCompoundEdit();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        buffer.endCompoundEdit();
                        throw throwable;
                    }
                }
                buffer.endCompoundEdit();
                return bl2;
            }
            Object var10_11 = null;
            buffer.endCompoundEdit();
            return bl;
        }
        Object var10_12 = null;
        buffer.endCompoundEdit();
        return false;
    }

    public static boolean replaceAll(View view) {
        return SearchAndReplace.replaceAll(view, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceAll(View view, boolean bl) {
        Object[] objectArray;
        int n;
        int n2;
        boolean bl2;
        Window window;
        block14: {
            window = SearchDialog.getSearchDialog(view);
            if (window == null) {
                window = view;
            }
            if (fileset.getFileCount(view) == 0) {
                GUIUtilities.error(window, "empty-fileset", null);
                return false;
            }
            SearchAndReplace.record(view, "replaceAll(view)", true, true);
            view.showWaitCursor();
            bl2 = replace != null && TextUtilities.getStringCase(replace) == 1;
            n2 = 0;
            n = 0;
            objectArray = SearchAndReplace.getSearchMatcher();
            if (objectArray != null) break block14;
            boolean bl3 = false;
            Object var13_10 = null;
            view.hideWaitCursor();
            return bl3;
        }
        try {
            try {
                SearchAndReplace.initReplace();
                String string = fileset.getFirstFile(view);
                while (string != null) {
                    Object var11_16;
                    Buffer buffer = jEdit.openTemporary(view, null, string, false);
                    string = fileset.getNextFile(view, string);
                    if (buffer == null) continue;
                    if (buffer.isPerformingIO()) {
                        VFSManager.waitForRequests();
                    }
                    if (!buffer.isEditable()) continue;
                    int n3 = 0;
                    try {
                        buffer.beginCompoundEdit();
                        n3 = SearchAndReplace._replace(view, buffer, (SearchMatcher)objectArray, 0, buffer.getLength(), bl2);
                        var11_16 = null;
                    }
                    catch (Throwable throwable) {
                        var11_16 = null;
                        buffer.endCompoundEdit();
                        throw throwable;
                    }
                    buffer.endCompoundEdit();
                    if (n3 == 0) continue;
                    ++n2;
                    n += n3;
                    if (bl) {
                        buffer.save(null, null);
                        continue;
                    }
                    jEdit.commitTemporary(buffer);
                    jEdit.getBufferSetManager().addBuffer(view, buffer);
                }
                Object var13_11 = null;
                view.hideWaitCursor();
            }
            catch (Exception exception) {
                SearchAndReplace.handleError(window, exception);
                Object var13_12 = null;
                view.hideWaitCursor();
            }
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            view.hideWaitCursor();
            throw throwable;
        }
        if (!BeanShell.isScriptRunning()) {
            objectArray = new Object[]{n, n2};
            view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.replace-all", objectArray));
            if (n == 0) {
                view.getToolkit().beep();
            }
        }
        return n2 != 0;
    }

    public static String escapeRegexp(String string, boolean bl) {
        return StandardUtilities.charsToEscapes(string, "\r\t\\()[]{}$^*+?|." + (bl ? "" : "\n"));
    }

    public static void load() {
        search = jEdit.getProperty("search.find.value");
        replace = jEdit.getProperty("search.replace.value");
        ignoreCase = jEdit.getBooleanProperty("search.ignoreCase.toggle");
        regexp = jEdit.getBooleanProperty("search.regexp.toggle");
        beanshell = jEdit.getBooleanProperty("search.beanshell.toggle");
        wrap = jEdit.getBooleanProperty("search.wrap.toggle");
        fileset = new CurrentBufferSet();
        matcher = null;
        EditBus.send(new SearchSettingsChanged(null));
    }

    public static void save() {
        jEdit.setProperty("search.find.value", search);
        jEdit.setProperty("search.replace.value", replace);
        jEdit.setBooleanProperty("search.ignoreCase.toggle", ignoreCase);
        jEdit.setBooleanProperty("search.regexp.toggle", regexp);
        jEdit.setBooleanProperty("search.beanshell.toggle", beanshell);
        jEdit.setBooleanProperty("search.wrap.toggle", wrap);
    }

    static void handleError(Component component, Exception exception) {
        Log.log(9, SearchAndReplace.class, exception);
        if (component instanceof Dialog) {
            new TextAreaDialog((Dialog)component, beanshell ? "searcherror-bsh" : "searcherror", (Throwable)exception);
        } else {
            new TextAreaDialog((Frame)component, beanshell ? "searcherror-bsh" : "searcherror", (Throwable)exception);
        }
    }

    private static void initReplace() throws Exception {
        replaceMethod = beanshell && replace.length() != 0 ? BeanShell.cacheBlock("replace", "return (" + replace + ");", true) : null;
    }

    private static void record(View view, String string, boolean bl, boolean bl2) {
        Macros.Recorder recorder = view.getMacroRecorder();
        if (recorder != null) {
            recorder.record("SearchAndReplace.setSearchString(\"" + StandardUtilities.charsToEscapes(search) + "\");");
            if (bl) {
                recorder.record("SearchAndReplace.setReplaceString(\"" + StandardUtilities.charsToEscapes(replace) + "\");");
                recorder.record("SearchAndReplace.setBeanShellReplace(" + beanshell + ");");
            } else {
                recorder.record("SearchAndReplace.setAutoWrapAround(" + wrap + ");");
                recorder.record("SearchAndReplace.setReverseSearch(" + reverse + ");");
            }
            recorder.record("SearchAndReplace.setIgnoreCase(" + ignoreCase + ");");
            recorder.record("SearchAndReplace.setRegexp(" + regexp + ");");
            if (bl2) {
                recorder.record("SearchAndReplace.setSearchFileSet(" + fileset.getCode() + ");");
            }
            recorder.record("SearchAndReplace." + string + ';');
        }
    }

    private static int replaceInSelection(View view, TextArea textArea, Buffer buffer, SearchMatcher searchMatcher, boolean bl, Selection selection) throws Exception {
        int n;
        int n2 = selection.getStart();
        if (selection instanceof Selection.Range) {
            n = SearchAndReplace._replace(view, buffer, searchMatcher, selection.getStart(), selection.getEnd(), bl);
            textArea.removeFromSelection(selection);
            textArea.addToSelection(new Selection.Range(n2, selection.getEnd()));
        } else if (selection instanceof Selection.Rect) {
            Selection.Rect rect = (Selection.Rect)selection;
            int n3 = rect.getStartColumn(buffer);
            int n4 = rect.getEndColumn(buffer);
            n = 0;
            for (int i = selection.getStartLine(); i <= selection.getEndLine(); ++i) {
                n += SearchAndReplace._replace(view, buffer, searchMatcher, SearchAndReplace.getColumnOnOtherLine(buffer, i, n3), SearchAndReplace.getColumnOnOtherLine(buffer, i, n4), bl);
            }
            textArea.addToSelection(new Selection.Rect(n2, selection.getEnd()));
        } else {
            throw new RuntimeException("Unsupported: " + selection);
        }
        return n;
    }

    private static int _replace(View view, JEditBuffer jEditBuffer, SearchMatcher searchMatcher, int n, int n2, boolean bl) throws Exception {
        int n3 = 0;
        boolean bl2 = jEditBuffer.getLineEndOffset(jEditBuffer.getLineOfOffset(n2)) - 1 == n2;
        int n4 = n;
        int n5 = 0;
        while (true) {
            boolean bl3 = jEditBuffer.getLineStartOffset(jEditBuffer.getLineOfOffset(n4)) == n4;
            CharSequence charSequence = jEditBuffer.getSegment(n4, n2 - n4);
            SearchMatcher.Match match = searchMatcher.nextMatch(charSequence, bl3, bl2, n5 == 0, false);
            if (match == null) break;
            String string = ((Object)charSequence.subSequence(match.start, match.end)).toString();
            int n6 = SearchAndReplace.replaceOne(view, jEditBuffer, match, n4, string, bl);
            if (n6 == -1) {
                n4 += match.end;
            } else {
                n4 += match.start + n6;
                n2 += n6 - string.length();
                ++n3;
            }
            ++n5;
        }
        return n3;
    }

    private static int replaceOne(View view, JEditBuffer jEditBuffer, SearchMatcher.Match match, int n, String string, boolean bl) throws Exception {
        int n2;
        String string2 = SearchAndReplace.replaceOne(view, match, string);
        if (bl && ignoreCase) {
            n2 = TextUtilities.getStringCase(string);
            if (n2 == 1) {
                string2 = string2.toLowerCase();
            } else if (n2 == 2) {
                string2 = string2.toUpperCase();
            } else if (n2 == 3) {
                string2 = TextUtilities.toTitleCase(string2);
            }
        }
        if (string2 != null) {
            int n3 = n + match.end;
            n2 = n + match.start;
            if (n3 - n2 > 0) {
                jEditBuffer.remove(n2, n3 - n2);
            }
            jEditBuffer.insert(n2, string2);
            return string2.length();
        }
        return -1;
    }

    private static String replaceOne(View view, SearchMatcher.Match match, String string) throws Exception {
        if (regexp) {
            if (replaceMethod != null) {
                return SearchAndReplace.regexpBeanShellReplace(view, match);
            }
            return SearchAndReplace.regexpReplace(match, string);
        }
        if (replaceMethod != null) {
            return SearchAndReplace.literalBeanShellReplace(view, string);
        }
        return replace;
    }

    private static String regexpBeanShellReplace(View view, SearchMatcher.Match match) throws Exception {
        for (int i = 0; i < match.substitutions.length; ++i) {
            replaceNS.setVariable("_" + i, match.substitutions[i]);
        }
        Object object = BeanShell.runCachedBlock(replaceMethod, view, replaceNS);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private static String regexpReplace(SearchMatcher.Match match, String string) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < replace.length(); ++i) {
            char c = replace.charAt(i);
            switch (c) {
                case '$': {
                    String string2;
                    if (i == replace.length() - 1) {
                        stringBuilder.append(c);
                        continue block8;
                    }
                    if ((c = replace.charAt(++i)) == '$') {
                        stringBuilder.append('$');
                        continue block8;
                    }
                    if (c == '0') {
                        stringBuilder.append(string);
                        continue block8;
                    }
                    if (!Character.isDigit(c)) continue block8;
                    int n = c - 48;
                    while (i < replace.length() - 1) {
                        if (Character.isDigit(c = replace.charAt(++i))) {
                            n = n * 10 + (c - 48);
                            continue;
                        }
                        --i;
                        break;
                    }
                    if (n >= match.substitutions.length || (string2 = match.substitutions[n]) == null) continue block8;
                    stringBuilder.append(string2);
                    continue block8;
                }
                case '\\': {
                    if (i == replace.length() - 1) {
                        stringBuilder.append('\\');
                        continue block8;
                    }
                    c = replace.charAt(++i);
                    switch (c) {
                        case 'n': {
                            stringBuilder.append('\n');
                            continue block8;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            continue block8;
                        }
                    }
                    stringBuilder.append(c);
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String literalBeanShellReplace(View view, String string) throws Exception {
        replaceNS.setVariable("_0", string);
        Object object = BeanShell.runCachedBlock(replaceMethod, view, replaceNS);
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private static int getColumnOnOtherLine(Buffer buffer, int n, int n2) {
        int n3 = buffer.getOffsetOfVirtualColumn(n, n2, null);
        if (n3 == -1) {
            return buffer.getLineEndOffset(n) - 1;
        }
        return buffer.getLineStartOffset(n) + n3;
    }

    static {
        replaceNS = new NameSpace(BeanShell.getNameSpace(), BeanShell.getNameSpace().getClassManager(), "search and replace");
    }
}

