/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import javax.swing.text.Position;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.HyperSearchNode;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;

public class HyperSearchResult
implements HyperSearchNode {
    public String path;
    public Buffer buffer;
    public int line;
    public String str;
    public Occur occur;
    public int occurCount;

    public Buffer getBuffer(View view) {
        if (this.buffer == null) {
            this.buffer = jEdit.openFile(view, this.path);
        }
        return this.buffer;
    }

    public Selection[] getSelection() {
        if (this.buffer == null) {
            return null;
        }
        Selection[] selectionArray = new Selection[this.occurCount];
        Occur occur = this.occur;
        int n = 0;
        while (occur != null) {
            Selection.Range range = new Selection.Range(occur.startPos.getOffset(), occur.endPos.getOffset());
            selectionArray[n++] = range;
            occur = occur.next;
        }
        return selectionArray;
    }

    public void goTo(final EditPane editPane) {
        Buffer buffer = this.getBuffer(editPane.getView());
        if (buffer == null) {
            return;
        }
        editPane.setBuffer(buffer);
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                Selection[] selectionArray = HyperSearchResult.this.getSelection();
                if (selectionArray == null) {
                    return;
                }
                JEditTextArea jEditTextArea = editPane.getTextArea();
                if (jEditTextArea.isMultipleSelectionEnabled()) {
                    jEditTextArea.addToSelection(selectionArray);
                } else {
                    jEditTextArea.setSelection(selectionArray);
                }
                jEditTextArea.moveCaretPosition(HyperSearchResult.this.occur.endPos.getOffset());
            }
        });
    }

    public String toString() {
        return this.str;
    }

    HyperSearchResult(Buffer buffer, int n) {
        this.path = buffer.getPath();
        if (!buffer.isTemporary()) {
            this.bufferOpened(buffer);
        }
        this.line = n;
        this.str = n + 1 + ": " + buffer.getLineText(n).replace('\t', ' ').trim();
    }

    void bufferOpened(Buffer buffer) {
        this.buffer = buffer;
        Occur occur = this.occur;
        while (occur != null) {
            occur.bufferOpened();
            occur = occur.next;
        }
    }

    void bufferClosed() {
        this.buffer = null;
        Occur occur = this.occur;
        while (occur != null) {
            occur.bufferClosed();
            occur = occur.next;
        }
    }

    void addOccur(int n, int n2) {
        Occur occur = new Occur(n, n2);
        occur.next = this.occur;
        this.occur = occur;
        ++this.occurCount;
    }

    boolean pathEquals(String string) {
        return string.equals(MiscUtilities.resolveSymlinks(this.path));
    }

    public boolean equals(Object object) {
        if (!(object instanceof HyperSearchResult)) {
            return false;
        }
        HyperSearchResult hyperSearchResult = (HyperSearchResult)object;
        return this.pathEquals(hyperSearchResult.path) && this.line == hyperSearchResult.line && this.buffer.equals(hyperSearchResult.buffer);
    }

    public class Occur {
        public int start;
        public int end;
        public Position startPos;
        public Position endPos;
        public Occur next;

        Occur(int n, int n2) {
            this.start = n;
            this.end = n2;
            if (HyperSearchResult.this.buffer != null && !HyperSearchResult.this.buffer.isTemporary()) {
                this.bufferOpened();
            }
        }

        void bufferOpened() {
            this.startPos = HyperSearchResult.this.buffer.createPosition(Math.min(HyperSearchResult.this.buffer.getLength(), this.start));
            this.endPos = HyperSearchResult.this.buffer.createPosition(Math.min(HyperSearchResult.this.buffer.getLength(), this.end));
        }

        void bufferClosed() {
            this.start = this.startPos.getOffset();
            this.end = this.endPos.getOffset();
            this.endPos = null;
            this.startPos = null;
        }
    }
}

