/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.HyperSearchFileNode;
import org.gjt.sp.jedit.search.HyperSearchOperationNode;
import org.gjt.sp.jedit.search.HyperSearchResult;
import org.gjt.sp.jedit.search.HyperSearchResults;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;
import org.gjt.sp.jedit.search.SearchMatcher;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;
import org.gjt.sp.util.WorkThread;

class HyperSearchRequest
extends WorkRequest {
    private View view;
    private SearchMatcher matcher;
    private HyperSearchResults results;
    private DefaultMutableTreeNode rootSearchNode;
    private Selection[] selection;
    private String searchString;
    private DefaultMutableTreeNode selectNode;

    HyperSearchRequest(View view, SearchMatcher searchMatcher, HyperSearchResults hyperSearchResults, Selection[] selectionArray) {
        this.view = view;
        this.matcher = searchMatcher;
        this.results = hyperSearchResults;
        this.searchString = SearchAndReplace.getSearchString();
        this.rootSearchNode = new DefaultMutableTreeNode(new HyperSearchOperationNode(this.searchString, searchMatcher));
        this.selection = selectionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.setStatus(jEdit.getProperty("hypersearch-status"));
        SearchFileSet searchFileSet = SearchAndReplace.getSearchFileSet();
        String[] stringArray = searchFileSet.getFiles(this.view);
        if (stringArray == null || stringArray.length == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GUIUtilities.error(HyperSearchRequest.this.view, "empty-fileset", null);
                    HyperSearchRequest.this.results.searchDone(HyperSearchRequest.this.rootSearchNode);
                }
            });
            return;
        }
        this.setMaximum(searchFileSet.getFileCount(this.view));
        String string = jEdit.getProperty("hypersearch-results.searching", new String[]{SearchAndReplace.getSearchString()}) + ' ';
        try {
            try {
                if (this.selection != null) {
                    Buffer buffer = this.view.getBuffer();
                    this.searchInSelection(buffer);
                }
                int n = 0;
                long l = 0L;
                int n2 = 0;
                boolean bl = false;
                int n3 = jEdit.getIntegerProperty("hypersearch.maxWarningResults");
                for (int i = 0; i < stringArray.length; ++i) {
                    Buffer buffer;
                    if (jEdit.getBooleanProperty("hyperSearch-stopButton")) {
                        jEdit.setTemporaryProperty("hyperSearch-stopButton", "false");
                        Log.log(3, this, "Search stopped by user action (stop button)");
                        break;
                    }
                    if (!bl && n2 > n3 && n3 != 0) {
                        Log.log(1, this, "Search in progress, " + n2 + " occurrences found, asking the user to stop");
                        bl = true;
                        int n4 = GUIUtilities.confirm(this.view, "hypersearch.tooManyResults", new Object[]{n2}, 0, 3);
                        if (n4 == 0) {
                            Log.log(3, this, "Search stopped by user action");
                            break;
                        }
                    }
                    String string2 = stringArray[i];
                    ++n;
                    long l2 = System.currentTimeMillis();
                    if (l2 - l > 250L) {
                        this.setValue(n);
                        l = l2;
                        this.results.setSearchStatus(string + string2);
                    }
                    if ((buffer = jEdit.openTemporary(null, null, string2, false)) == null) continue;
                    n2 += this.doHyperSearch(buffer, 0, buffer.getLength());
                }
                Log.log(3, this, n2 + " OCCURENCES");
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchAndReplace.handleError(HyperSearchRequest.this.view, exception);
                    }
                });
                Object var16_18 = null;
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        HyperSearchRequest.this.results.searchDone(HyperSearchRequest.this.rootSearchNode, HyperSearchRequest.this.selectNode);
                    }
                });
                return;
            }
            catch (WorkThread.Abort abort) {
                Object var16_19 = null;
                VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchInSelection(Buffer buffer) throws Exception {
        this.setAbortable(false);
        int n = 0;
        try {
            buffer.readLock();
            for (int i = 0; i < this.selection.length; ++i) {
                Selection selection = this.selection[i];
                if (selection instanceof Selection.Rect) {
                    for (int j = selection.getStartLine(); j <= selection.getEndLine(); ++j) {
                        n += this.doHyperSearch(buffer, selection.getStart(buffer, j), selection.getEnd(buffer, j));
                    }
                    continue;
                }
                n += this.doHyperSearch(buffer, selection.getStart(), selection.getEnd());
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            buffer.readUnlock();
            throw throwable;
        }
        buffer.readUnlock();
        this.setAbortable(true);
        return n;
    }

    private int doHyperSearch(Buffer buffer, int n, int n2) throws Exception {
        this.setAbortable(false);
        HyperSearchFileNode hyperSearchFileNode = new HyperSearchFileNode(buffer.getPath());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(hyperSearchFileNode);
        int n3 = this.doHyperSearch(buffer, n, n2, defaultMutableTreeNode);
        hyperSearchFileNode.setCount(n3);
        if (n3 != 0) {
            this.rootSearchNode.insert(defaultMutableTreeNode, this.rootSearchNode.getChildCount());
        }
        this.setAbortable(true);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doHyperSearch(Buffer buffer, int n, int n2, DefaultMutableTreeNode defaultMutableTreeNode) {
        int n3 = 0;
        JEditTextArea jEditTextArea = jEdit.getActiveView().getTextArea();
        int n4 = jEditTextArea.getBuffer() == buffer ? jEditTextArea.getCaretLine() : -1;
        try {
            buffer.readLock();
            boolean bl = buffer.getLineEndOffset(buffer.getLineOfOffset(n2)) - 1 == n2;
            int n5 = n;
            HyperSearchResult hyperSearchResult = null;
            int n6 = 0;
            while (true) {
                boolean bl2 = buffer.getLineStartOffset(buffer.getLineOfOffset(n5)) == n5;
                SearchMatcher.Match match = this.matcher.nextMatch(buffer.getSegment(n5, n2 - n5), bl2, bl, n6 == 0, false);
                if (match == null) break;
                int n7 = buffer.getLineOfOffset(n5 + match.start);
                if (hyperSearchResult == null || hyperSearchResult.line != n7) {
                    hyperSearchResult = new HyperSearchResult(buffer, n7);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(hyperSearchResult, false);
                    if (hyperSearchResult.line == n4) {
                        this.selectNode = defaultMutableTreeNode2;
                    }
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                hyperSearchResult.addOccur(n5 + match.start, n5 + match.end);
                n5 += match.end;
                ++n3;
                ++n6;
            }
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            buffer.readUnlock();
            throw throwable;
        }
        buffer.readUnlock();
        return n3;
    }
}

