/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Component;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class DirectoryListSet
extends BufferListSet {
    private String directory;
    private String glob;
    private boolean recurse;
    private boolean skipHidden;
    private boolean skipBinary;

    public DirectoryListSet(String string, String string2, boolean bl) {
        this.directory = string;
        this.glob = string2;
        this.recurse = bl;
        this.skipBinary = jEdit.getBooleanProperty("search.skipBinary.toggle");
        this.skipHidden = jEdit.getBooleanProperty("search.skipHidden.toggle");
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String string) {
        this.directory = string;
        this.invalidateCachedList();
    }

    public String getFileFilter() {
        return this.glob;
    }

    public void setFileFilter(String string) {
        this.glob = string;
        this.invalidateCachedList();
    }

    public boolean isRecursive() {
        return this.recurse;
    }

    public void setRecursive(boolean bl) {
        this.recurse = bl;
        this.invalidateCachedList();
    }

    public String getCode() {
        return "new DirectoryListSet(\"" + StandardUtilities.charsToEscapes(this.directory) + "\",\"" + StandardUtilities.charsToEscapes(this.glob) + "\"," + this.recurse + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] _getFiles(final Component component) {
        Object[] objectArray;
        Object object;
        this.skipBinary = jEdit.getBooleanProperty("search.skipBinary.toggle");
        this.skipHidden = jEdit.getBooleanProperty("search.skipHidden.toggle");
        final VFS vFS = VFSManager.getVFSForPath(this.directory);
        if (SwingUtilities.isEventDispatchThread()) {
            object = vFS.createVFSSession(this.directory, component);
        } else {
            objectArray = new Object[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        objectArray[0] = vFS.createVFSSession(DirectoryListSet.this.directory, component);
                    }
                });
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
            }
            object = objectArray[0];
        }
        if (object == null) {
            return null;
        }
        try {
            try {
                objectArray = vFS._listDirectory(object, this.directory, this.glob, this.recurse, component, this.skipBinary, this.skipHidden);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                vFS._endVFSSession(object, component);
                throw throwable;
            }
            vFS._endVFSSession(object, component);
            return objectArray;
        }
        catch (IOException iOException) {
            VFSManager.error(component, this.directory, "ioerror", new String[]{iOException.toString()});
            return null;
        }
    }
}

