/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

class Roster {
    private static File downloadDir;
    private List<Operation> operations = new ArrayList<Operation>();
    private List<String> toLoad = new ArrayList<String>();

    Roster() {
    }

    void addRemove(String string) {
        this.addOperation(new Remove(string));
    }

    void addInstall(String string, String string2, String string3, int n) {
        this.addOperation(new Install(string, string2, string3, n));
    }

    public Operation getOperation(int n) {
        return this.operations.get(n);
    }

    int getOperationCount() {
        return this.operations.size();
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    void performOperationsInWorkThread(PluginManagerProgress pluginManagerProgress) {
        for (int i = 0; i < this.operations.size(); ++i) {
            Operation operation = this.operations.get(i);
            operation.runInWorkThread(pluginManagerProgress);
            pluginManagerProgress.done();
            if (!Thread.interrupted()) continue;
            return;
        }
    }

    void performOperationsInAWTThread(Component component) {
        PluginJAR pluginJAR;
        Object object;
        int n;
        for (n = 0; n < this.operations.size(); ++n) {
            object = this.operations.get(n);
            ((Operation)object).runInAWTThread(component);
        }
        for (n = 0; n < this.toLoad.size(); ++n) {
            object = this.toLoad.get(n);
            if (jEdit.getPluginJAR((String)object) != null) {
                Log.log(7, this, "Already loaded: " + (String)object);
                continue;
            }
            jEdit.addPluginJAR((String)object);
        }
        for (n = 0; n < this.toLoad.size(); ++n) {
            object = this.toLoad.get(n);
            pluginJAR = jEdit.getPluginJAR((String)object);
            if (pluginJAR == null) continue;
            pluginJAR.checkDependencies();
        }
        for (n = 0; n < this.toLoad.size(); ++n) {
            object = this.toLoad.get(n);
            pluginJAR = jEdit.getPluginJAR((String)object);
            if (pluginJAR == null) continue;
            pluginJAR.activatePluginIfNecessary();
        }
    }

    private void addOperation(Operation operation) {
        for (int i = 0; i < this.operations.size(); ++i) {
            if (!this.operations.get(i).equals(operation)) continue;
            return;
        }
        this.operations.add(operation);
    }

    private static String getDownloadDir() {
        if (downloadDir == null) {
            String string = jEdit.getSettingsDirectory();
            if (string == null) {
                string = System.getProperty("user.home");
            }
            downloadDir = new File(MiscUtilities.constructPath(string, "PluginManager.download"));
            downloadDir.mkdirs();
        }
        return downloadDir.getPath();
    }

    class Install
    extends Operation {
        int size;
        private String installed;
        private final String url;
        private String installDirectory;
        private String path;

        Install(String string, String string2, String string3, int n) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            this.installed = string;
            this.url = string2;
            this.installDirectory = string3;
            this.size = n;
        }

        public int getMaximum() {
            return this.size;
        }

        public void runInWorkThread(PluginManagerProgress pluginManagerProgress) {
            String string = MiscUtilities.getFileName(this.url);
            this.path = this.download(pluginManagerProgress, string, this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void runInAWTThread(Component component) {
            block34: {
                if (this.path == null) {
                    return;
                }
                if (this.installed != null) {
                    new Remove(this.installed).runInAWTThread(component);
                }
                ZipFile zipFile = null;
                zipFile = new ZipFile(this.path);
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    Object var10_14;
                    ZipEntry zipEntry = enumeration.nextElement();
                    String string = zipEntry.getName().replace('/', File.separatorChar);
                    File file = new File(this.installDirectory, string);
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    new File(file.getParent()).mkdirs();
                    InputStream inputStream = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        inputStream = zipFile.getInputStream(zipEntry);
                        fileOutputStream = new FileOutputStream(file);
                        IOUtilities.copyStream(4096, null, inputStream, fileOutputStream, false);
                        var10_14 = null;
                    }
                    catch (Throwable throwable) {
                        var10_14 = null;
                        IOUtilities.closeQuietly(inputStream);
                        IOUtilities.closeQuietly(fileOutputStream);
                        throw throwable;
                    }
                    IOUtilities.closeQuietly(inputStream);
                    IOUtilities.closeQuietly(fileOutputStream);
                    if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                    Roster.this.toLoad.add(file.getPath());
                }
                Object var12_16 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    Log.log(9, this, iOException);
                }
                if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                    new File(this.path).delete();
                }
                break block34;
                {
                    catch (InterruptedIOException interruptedIOException) {
                        Object var12_17 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException iOException) {
                            Log.log(9, this, iOException);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                        break block34;
                    }
                    catch (ZipException zipException) {
                        Log.log(9, this, zipException);
                        GUIUtilities.error(null, "plugin-error-download", new Object[]{""});
                        Object var12_18 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException iOException) {
                            Log.log(9, this, iOException);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                        break block34;
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                        Object[] objectArray = new String[]{iOException.getMessage()};
                        GUIUtilities.error(null, "ioerror", objectArray);
                        Object var12_19 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException iOException2) {
                            Log.log(9, this, iOException2);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                        break block34;
                    }
                    catch (Exception exception) {
                        Log.log(9, this, exception);
                        Object var12_20 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException iOException) {
                            Log.log(9, this, iOException);
                        }
                        if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                            new File(this.path).delete();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var12_21 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                    }
                    if (jEdit.getBooleanProperty("plugin-manager.deleteDownloads")) {
                        new File(this.path).delete();
                    }
                    throw throwable;
                }
            }
        }

        public boolean equals(Object object) {
            return object instanceof Install && ((Install)object).url.equals(this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String download(PluginManagerProgress pluginManagerProgress, String string, String string2) {
            try {
                FileOutputStream fileOutputStream;
                InputStream inputStream;
                String string3;
                block8: {
                    String string4;
                    String string5 = jEdit.getProperty("plugin-manager.mirror.id");
                    if (string5 == null || string5.equals("NONE")) {
                        string5 = "default";
                    }
                    string3 = MiscUtilities.constructPath(Roster.getDownloadDir(), string);
                    URLConnection uRLConnection = new URL(string2).openConnection();
                    pluginManagerProgress.setStatus(jEdit.getProperty("plugin-manager.progress", new String[]{string, string5}));
                    inputStream = null;
                    fileOutputStream = null;
                    try {
                        inputStream = uRLConnection.getInputStream();
                        fileOutputStream = new FileOutputStream(string3);
                        if (IOUtilities.copyStream(pluginManagerProgress, inputStream, fileOutputStream, true)) break block8;
                        string4 = null;
                        Object var11_14 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_16 = null;
                        IOUtilities.closeQuietly(inputStream);
                        IOUtilities.closeQuietly(fileOutputStream);
                        throw throwable;
                    }
                    IOUtilities.closeQuietly(inputStream);
                    IOUtilities.closeQuietly(fileOutputStream);
                    return string4;
                }
                Object var11_15 = null;
                IOUtilities.closeQuietly(inputStream);
                IOUtilities.closeQuietly(fileOutputStream);
                return string3;
            }
            catch (InterruptedIOException interruptedIOException) {
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.log(9, this, fileNotFoundException);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GUIUtilities.error(null, "plugin-error-download", new Object[]{""});
                    }
                });
                return null;
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Object[] objectArray = new String[]{iOException.getMessage()};
                        GUIUtilities.error(null, "plugin-error-download", objectArray);
                    }
                });
                return null;
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
                return null;
            }
        }
    }

    class Remove
    extends Operation {
        private final String jar;

        Remove(String string) {
            this.jar = string;
        }

        public void runInAWTThread(Component component) {
            PluginJAR pluginJAR = jEdit.getPluginJAR(this.jar);
            if (pluginJAR != null) {
                this.unloadPluginJAR(pluginJAR);
            }
            Roster.this.toLoad.remove(this.jar);
            File file = new File(this.jar);
            File file2 = new File(this.jar.substring(0, this.jar.length() - 4));
            Log.log(5, this, "Deleting " + file);
            boolean bl = file.delete();
            if (file2.exists()) {
                bl &= FileVFS.recursiveDelete(file2);
            }
            if (!bl) {
                Object[] objectArray = new String[]{this.jar};
                GUIUtilities.error(component, "plugin-manager.remove-failed", objectArray);
            }
        }

        private void unloadPluginJAR(PluginJAR pluginJAR) {
            String[] stringArray;
            for (String string : stringArray = pluginJAR.getDependentPlugins()) {
                PluginJAR pluginJAR2 = jEdit.getPluginJAR(string);
                if (pluginJAR2 == null) continue;
                Roster.this.toLoad.add(string);
                this.unloadPluginJAR(pluginJAR2);
                String string2 = pluginJAR.getCachePath();
                if (string2 == null) continue;
                new File(string2).delete();
            }
            jEdit.removePluginJAR(pluginJAR, false);
        }

        public boolean equals(Object object) {
            return object instanceof Remove && ((Remove)object).jar.equals(this.jar);
        }
    }

    static abstract class Operation {
        Operation() {
        }

        public void runInWorkThread(PluginManagerProgress pluginManagerProgress) {
        }

        public void runInAWTThread(Component component) {
        }

        public int getMaximum() {
            return 0;
        }
    }
}

