/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.options.GlobalOptions;
import org.gjt.sp.jedit.options.PluginOptions;
import org.gjt.sp.jedit.pluginmgr.InstallPanel;
import org.gjt.sp.jedit.pluginmgr.ManagePanel;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.WorkRequest;
import org.xml.sax.SAXParseException;

public class PluginManager
extends JFrame
implements EBComponent {
    private static PluginManager instance;
    private JTabbedPane tabPane;
    private JButton done;
    private JButton mgrOptions;
    private JButton pluginOptions;
    private InstallPanel installer;
    private InstallPanel updater;
    private ManagePanel manager;
    private PluginList pluginList;
    private boolean queuedUpdate;
    private boolean downloadingPluginList;
    private final Frame parent;
    public static final String PROPERTY_PLUGINSET = "plugin-manager.pluginset.path";

    public static PluginManager getInstance() {
        return instance;
    }

    public void dispose() {
        instance = null;
        EditBus.removeFromBus(this);
        EditBus.removeFromBus(this.installer);
        super.dispose();
    }

    public void handleMessage(EBMessage eBMessage) {
        if (eBMessage instanceof PropertiesChanged) {
            if (this.shouldUpdatePluginList()) {
                this.pluginList = null;
                this.updatePluginList();
                if (this.tabPane.getSelectedIndex() != 0) {
                    this.installer.updateModel();
                    this.updater.updateModel();
                }
            }
        } else if (eBMessage instanceof PluginUpdate && !this.queuedUpdate) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PluginManager.this.queuedUpdate = false;
                    PluginManager.this.manager.update();
                }
            });
            this.queuedUpdate = true;
        }
    }

    public static void showPluginManager(Frame frame) {
        if (instance == null) {
            instance = new PluginManager(frame);
        } else {
            instance.toFront();
        }
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    PluginList getPluginList() {
        return this.pluginList;
    }

    private PluginManager(Frame frame) {
        super(jEdit.getProperty("plugin-manager.title"));
        this.parent = frame;
        this.init();
    }

    private void init() {
        EditBus.addToBus(this);
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        this.tabPane = new JTabbedPane();
        this.manager = new ManagePanel(this);
        this.tabPane.addTab(jEdit.getProperty("manage-plugins.title"), this.manager);
        this.updater = new InstallPanel(this, true);
        this.tabPane.addTab(jEdit.getProperty("update-plugins.title"), this.updater);
        this.installer = new InstallPanel(this, false);
        this.tabPane.addTab(jEdit.getProperty("install-plugins.title"), this.installer);
        EditBus.addToBus(this.installer);
        jPanel.add("Center", this.tabPane);
        this.tabPane.addChangeListener(new ListUpdater());
        Box box = new Box(0);
        ActionHandler actionHandler = new ActionHandler();
        this.mgrOptions = new JButton(jEdit.getProperty("plugin-manager.mgr-options"));
        this.mgrOptions.addActionListener(actionHandler);
        this.pluginOptions = new JButton(jEdit.getProperty("plugin-manager.plugin-options"));
        this.pluginOptions.addActionListener(actionHandler);
        this.done = new JButton(jEdit.getProperty("plugin-manager.done"));
        this.done.addActionListener(actionHandler);
        box.add(Box.createGlue());
        box.add(this.mgrOptions);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.pluginOptions);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.done);
        box.add(Box.createGlue());
        this.getRootPane().setDefaultButton(this.done);
        jPanel.add("South", box);
        this.setDefaultCloseOperation(2);
        this.setIconImage(GUIUtilities.getPluginIcon());
        this.pack();
        GUIUtilities.loadGeometry(this, this.parent, "plugin-manager");
        GUIUtilities.addSizeSaver(this, this.parent, "plugin-manager");
        this.setVisible(true);
    }

    private boolean shouldUpdatePluginList() {
        return (this.pluginList == null || !this.pluginList.getMirrorId().equals(jEdit.getProperty("plugin-manager.mirror.id"))) && !this.downloadingPluginList;
    }

    private void updatePluginList() {
        if (jEdit.getSettingsDirectory() == null && jEdit.getJEditHome() == null) {
            GUIUtilities.error(this, "no-settings", null);
            return;
        }
        if (!this.shouldUpdatePluginList()) {
            return;
        }
        final Exception[] exceptionArray = new Exception[1];
        VFSManager.runInWorkThread(new WorkRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        PluginManager.this.downloadingPluginList = true;
                        this.setStatus(jEdit.getProperty("plugin-manager.list-download-connect"));
                        PluginManager.this.pluginList = new PluginList(this);
                    }
                    catch (Exception exception) {
                        exceptionArray[0] = exception;
                        Object var3_2 = null;
                        PluginManager.this.downloadingPluginList = false;
                        return;
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    PluginManager.this.downloadingPluginList = false;
                    throw throwable;
                }
                PluginManager.this.downloadingPluginList = false;
            }
        });
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                if (exceptionArray[0] instanceof SAXParseException) {
                    SAXParseException sAXParseException = (SAXParseException)exceptionArray[0];
                    int n = sAXParseException.getLineNumber();
                    String string = jEdit.getProperty("plugin-manager.export-url");
                    String string2 = sAXParseException.getMessage();
                    Log.log(9, this, string + ':' + n + ": " + string2);
                    Object[] objectArray = new String[]{string, String.valueOf(n), string2};
                    GUIUtilities.error(PluginManager.this, "plugin-list.xmlerror", objectArray);
                } else if (exceptionArray[0] != null) {
                    Exception exception = exceptionArray[0];
                    Log.log(9, this, exception);
                    Object[] objectArray = new String[]{exception.toString()};
                    String string = jEdit.getProperty("common.ok");
                    String string3 = jEdit.getProperty("plugin-list.ioerror.proxy-servers");
                    int n = JOptionPane.showOptionDialog(PluginManager.this, jEdit.getProperty("plugin-list.ioerror.message", objectArray), jEdit.getProperty("plugin-list.ioerror.title"), 0, 0, null, new Object[]{string3, string}, string);
                    if (n == 0) {
                        new GlobalOptions((Frame)PluginManager.this, "firewall");
                    }
                }
            }
        });
    }

    public void processKeyEvents(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
            this.cancel();
            keyEvent.consume();
        }
    }

    class ListUpdater
    implements ChangeListener {
        ListUpdater() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Component component = PluginManager.this.tabPane.getSelectedComponent();
            if (component == PluginManager.this.installer || component == PluginManager.this.updater) {
                PluginManager.this.updatePluginList();
                PluginManager.this.installer.updateModel();
                PluginManager.this.updater.updateModel();
            } else if (component == PluginManager.this.manager) {
                PluginManager.this.manager.update();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == PluginManager.this.done) {
                PluginManager.this.ok();
            } else if (object == PluginManager.this.mgrOptions) {
                new GlobalOptions((Frame)PluginManager.this, "plugin-manager");
            } else if (object == PluginManager.this.pluginOptions) {
                new PluginOptions(PluginManager.this);
            }
        }
    }
}

