/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.util.Stack;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

class PluginListHandler
extends DefaultHandler {
    private final String path;
    private final PluginList pluginList;
    private PluginList.PluginSet pluginSet;
    private final StringBuilder pluginSetEntry;
    private PluginList.Plugin plugin;
    private String jar;
    private StringBuilder author;
    private PluginList.Branch branch;
    private boolean obsolete;
    private String version;
    private String date;
    private StringBuilder download;
    private int downloadSize;
    private StringBuilder downloadSource;
    private int downloadSourceSize;
    private int size;
    private String depWhat;
    private String depFrom;
    private String depTo;
    private String depPlugin;
    private String name;
    private StringBuilder description;
    private final Stack<String> stateStack = new Stack();

    PluginListHandler(PluginList pluginList, String string) {
        this.pluginList = pluginList;
        this.path = string;
        this.author = new StringBuilder();
        this.description = new StringBuilder();
        this.pluginSetEntry = new StringBuilder();
        this.download = new StringBuilder();
        this.downloadSource = new StringBuilder();
    }

    public InputSource resolveEntity(String string, String string2) {
        return XMLUtilities.findEntity(string2, "plugins.dtd", this.getClass());
    }

    public void attribute(String string, String string2, boolean bl) {
        if (string == "NAME") {
            this.name = string2;
        } else if (string == "JAR") {
            this.jar = string2;
        } else if (string == "VERSION") {
            this.version = string2;
        } else if (string == "DATE") {
            this.date = string2;
        } else if (string == "OBSOLETE") {
            this.obsolete = "TRUE".equals(string2);
        } else if (string == "WHAT") {
            this.depWhat = string2;
        } else if (string == "FROM") {
            this.depFrom = string2;
        } else if (string == "TO") {
            this.depTo = string2;
        } else if (string == "PLUGIN") {
            this.depPlugin = string2;
        } else if (string == "SIZE") {
            this.size = Integer.parseInt(string2);
            if (this.size == 0) {
                Log.log(7, this, "SIZE = 0");
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = this.peekElement();
        if (string.equals("DESCRIPTION")) {
            this.description.append(cArray, n, n2);
        } else if (string.equals("PLUGIN_SET_ENTRY")) {
            this.pluginSetEntry.append(cArray, n, n2);
        } else if (string.equals("AUTHOR")) {
            if (this.author.length() != 0) {
                this.author.append(", ");
            }
            this.author.append(cArray, n, n2);
        } else if (string.equals("DOWNLOAD")) {
            this.download.append(cArray, n, n2);
        } else if (string.equals("DOWNLOAD_SOURCE")) {
            this.downloadSource.append(cArray, n, n2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getQName(i);
            String string5 = attributes.getValue(i);
            this.attribute(string4, string5, true);
        }
        if ((string3 = this.pushElement(string3)).equals("PLUGIN_SET")) {
            this.description.setLength(0);
            this.pluginSet = new PluginList.PluginSet();
            this.pluginSet.name = this.name;
        } else if (string3.equals("PLUGIN")) {
            this.description.setLength(0);
            this.author.setLength(0);
            this.branch = null;
            this.plugin = new PluginList.Plugin();
        } else if (string3.equals("BRANCH")) {
            this.download.setLength(0);
            this.branch = new PluginList.Branch();
        } else if (string3.equals("DOWNLOAD")) {
            this.downloadSize = this.size;
        } else if (string3.equals("DOWNLOAD_SOURCE")) {
            this.downloadSourceSize = this.size;
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.popElement();
        if (string3.equals("PLUGIN_SET")) {
            this.pluginList.addPluginSet(this.pluginSet);
            this.pluginSet = null;
            this.pluginSetEntry.setLength(0);
        } else if (string3.equals("PLUGIN_SET_ENTRY")) {
            this.pluginSet.plugins.add(this.pluginSetEntry.toString());
            this.pluginSetEntry.setLength(0);
        } else if (string3.equals("PLUGIN")) {
            this.plugin.jar = this.jar;
            this.plugin.name = this.name;
            this.plugin.author = this.author.toString();
            this.plugin.description = this.description.toString();
            this.pluginList.addPlugin(this.plugin);
            this.jar = null;
            this.name = null;
            this.author.setLength(0);
            this.description.setLength(0);
        } else if (string3.equals("BRANCH")) {
            this.branch.version = this.version;
            this.branch.date = this.date;
            this.branch.download = this.download.toString();
            this.branch.downloadSize = this.downloadSize;
            this.branch.downloadSource = this.downloadSource.toString();
            this.branch.downloadSourceSize = this.downloadSourceSize;
            this.branch.obsolete = this.obsolete;
            this.plugin.branches.add(this.branch);
            this.version = null;
            this.download.setLength(0);
            this.downloadSource.setLength(0);
            this.obsolete = false;
        } else if (string3.equals("DEPEND")) {
            PluginList.Dependency dependency = new PluginList.Dependency(this.depWhat, this.depFrom, this.depTo, this.depPlugin);
            this.branch.deps.add(dependency);
            this.depWhat = null;
            this.depFrom = null;
            this.depTo = null;
            this.depPlugin = null;
        }
    }

    public void startDocument() {
        try {
            this.pushElement(null);
        }
        catch (Exception exception) {
            Log.log(9, this, exception);
        }
    }

    public void endDocument() {
        this.pluginList.finished();
    }

    private String pushElement(String string) {
        this.stateStack.push(string);
        return string;
    }

    private String peekElement() {
        return this.stateStack.peek();
    }

    private String popElement() {
        return this.stateStack.pop();
    }
}

