/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginListHandler;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.WorkRequest;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class PluginList {
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    final List<Plugin> plugins = new ArrayList<Plugin>();
    final Map<String, Plugin> pluginHash = new HashMap<String, Plugin>();
    final List<PluginSet> pluginSets = new ArrayList<PluginSet>();
    private final String id = jEdit.getProperty("plugin-manager.mirror.id");
    private String cachedURL;
    private WorkRequest workRequest;
    String gzipURL;

    PluginList(WorkRequest workRequest) {
        this.workRequest = workRequest;
        this.readPluginList(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readPluginList(boolean bl) {
        Object object;
        boolean bl2;
        this.gzipURL = jEdit.getProperty("plugin-manager.export-url");
        if (!this.id.equals("NONE")) {
            this.gzipURL = this.gzipURL + "?mirror=" + this.id;
        }
        String string = null;
        if (jEdit.getSettingsDirectory() == null) {
            this.cachedURL = this.gzipURL;
        } else {
            string = jEdit.getSettingsDirectory() + File.separator + "pluginMgr-Cached.xml.gz";
            this.cachedURL = "file:///" + string;
        }
        boolean bl3 = bl2 = !this.id.equals(jEdit.getProperty("plugin-manager.mirror.cached-id"));
        if (string != null) {
            try {
                long l;
                long l2;
                long l3;
                object = new File(string);
                if (!((File)object).canRead()) {
                    bl2 = true;
                }
                if ((l3 = (l2 = System.currentTimeMillis()) - ((File)object).lastModified()) > (l = (long)(jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 5) * 60 * 1000))) {
                    Log.log(3, this, "PluginList cached copy too old. Downloading from mirror. ");
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                Log.log(3, this, "No cached copy. Downloading from mirror. ");
                bl2 = true;
            }
        }
        if (bl2 && this.cachedURL != this.gzipURL) {
            this.downloadPluginList();
        }
        object = null;
        InputStream inputStream = null;
        try {
            try {
                if (this.cachedURL != this.gzipURL) {
                    Log.log(3, this, "Using cached pluginlist");
                }
                inputStream = new URL(this.cachedURL).openStream();
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                PluginListHandler pluginListHandler = new PluginListHandler(this, this.cachedURL);
                object = new BufferedInputStream(inputStream);
                if (((InputStream)object).markSupported()) {
                    ((InputStream)object).mark(2);
                    int n = ((InputStream)object).read();
                    int n2 = ((InputStream)object).read();
                    ((InputStream)object).reset();
                    if (n == 31 && n2 == 139) {
                        object = new GZIPInputStream((InputStream)object);
                    }
                }
                InputSource inputSource = new InputSource(new InputStreamReader((InputStream)object, "UTF8"));
                inputSource.setSystemId("jedit.jar");
                xMLReader.setContentHandler(pluginListHandler);
                xMLReader.setDTDHandler(pluginListHandler);
                xMLReader.setEntityResolver(pluginListHandler);
                xMLReader.setErrorHandler(pluginListHandler);
                xMLReader.parse(inputSource);
            }
            catch (Exception exception) {
                Log.log(9, this, "readpluginlist: error", exception);
                if (this.cachedURL.startsWith("file:///")) {
                    Log.log(1, this, "Unable to read plugin list, deleting cached file and try again");
                    new File(this.cachedURL.substring(8)).delete();
                    if (bl) {
                        this.plugins.clear();
                        this.pluginHash.clear();
                        this.pluginSets.clear();
                        this.readPluginList(false);
                    }
                }
                Object var12_17 = null;
                IOUtilities.closeQuietly((InputStream)object);
                IOUtilities.closeQuietly(inputStream);
                return;
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            IOUtilities.closeQuietly((InputStream)object);
            IOUtilities.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly((InputStream)object);
        IOUtilities.closeQuietly(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadPluginList() {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            try {
                this.workRequest.setStatus(jEdit.getProperty("plugin-manager.list-download"));
                InputStream inputStream = new URL(this.gzipURL).openStream();
                String string = this.cachedURL.replaceFirst("file:///", "");
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                long l = System.currentTimeMillis();
                bufferedInputStream = new BufferedInputStream(inputStream);
                IOUtilities.copyStream(4096, null, bufferedInputStream, bufferedOutputStream, false);
                jEdit.setProperty("plugin-manager.mirror.cached-id", this.id);
                Log.log(3, this, "Updated cached pluginlist " + (System.currentTimeMillis() - l));
            }
            catch (Exception exception) {
                Log.log(9, this, "CacheRemotePluginList: error", exception);
                Object var8_8 = null;
                IOUtilities.closeQuietly(bufferedOutputStream);
                IOUtilities.closeQuietly(bufferedInputStream);
                return;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            IOUtilities.closeQuietly(bufferedOutputStream);
            IOUtilities.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly(bufferedOutputStream);
        IOUtilities.closeQuietly(bufferedInputStream);
    }

    void addPlugin(Plugin plugin) {
        plugin.checkIfInstalled();
        this.plugins.add(plugin);
        this.pluginHash.put(plugin.name, plugin);
    }

    void addPluginSet(PluginSet pluginSet) {
        this.pluginSets.add(pluginSet);
    }

    void finished() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin = this.plugins.get(i);
            for (int j = 0; j < plugin.branches.size(); ++j) {
                Branch branch = plugin.branches.get(j);
                for (int k = 0; k < branch.deps.size(); ++k) {
                    Dependency dependency = branch.deps.get(k);
                    if (!dependency.what.equals("plugin")) continue;
                    dependency.plugin = this.pluginHash.get(dependency.pluginName);
                }
            }
        }
    }

    void dump() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            System.err.println(this.plugins.get(i));
            System.err.println();
        }
    }

    String getMirrorId() {
        return this.id;
    }

    static class Dependency {
        final String what;
        final String from;
        final String to;
        final String pluginName;
        Plugin plugin;

        Dependency(String string, String string2, String string3, String string4) {
            this.what = string;
            this.from = string2;
            this.to = string3;
            this.pluginName = string4;
        }

        boolean isSatisfied() {
            if (this.what.equals("plugin")) {
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    String string = this.plugin.getInstalledVersion();
                    if (string == null || this.from != null && StandardUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(string, this.to, false) > 0) continue;
                    return true;
                }
                return false;
            }
            if (this.what.equals("jdk")) {
                String string = System.getProperty("java.version").substring(0, 3);
                return !(this.from != null && StandardUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(string, this.to, false) > 0);
            }
            if (this.what.equals("jedit")) {
                String string = jEdit.getBuild();
                return !(this.from != null && StandardUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(string, this.to, false) > 0);
            }
            Log.log(9, this, "Invalid dependency: " + this.what);
            return false;
        }

        boolean canSatisfy() {
            if (this.isSatisfied()) {
                return true;
            }
            if (this.what.equals("plugin")) {
                return this.plugin.canBeInstalled();
            }
            return false;
        }

        void satisfy(Roster roster, String string, boolean bl) {
            if (this.what.equals("plugin")) {
                String string2 = this.plugin.getInstalledVersion();
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    Branch branch = this.plugin.branches.get(i);
                    if (string2 != null && StandardUtilities.compareStrings(string2, branch.version, false) >= 0 || this.from != null && StandardUtilities.compareStrings(branch.version, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(branch.version, this.to, false) > 0) continue;
                    this.plugin.install(roster, string, bl);
                    return;
                }
            }
        }

        public String toString() {
            return "[what=" + this.what + ",from=" + this.from + ",to=" + this.to + ",plugin=" + this.plugin + ']';
        }
    }

    static class Branch {
        String version;
        String date;
        int downloadSize;
        String download;
        int downloadSourceSize;
        String downloadSource;
        boolean obsolete;
        final List<Dependency> deps = new ArrayList<Dependency>();

        Branch() {
        }

        boolean canSatisfyDependencies() {
            for (int i = 0; i < this.deps.size(); ++i) {
                Dependency dependency = this.deps.get(i);
                if (dependency.canSatisfy()) continue;
                return false;
            }
            return true;
        }

        void satisfyDependencies(Roster roster, String string, boolean bl) {
            for (int i = 0; i < this.deps.size(); ++i) {
                Dependency dependency = this.deps.get(i);
                dependency.satisfy(roster, string, bl);
            }
        }

        public String toString() {
            return "[version=" + this.version + ",download=" + this.download + ",obsolete=" + this.obsolete + ",deps=" + this.deps + ']';
        }
    }

    public static class Plugin {
        String jar;
        String name;
        String description;
        String author;
        final List<Branch> branches = new ArrayList<Branch>();

        void checkIfInstalled() {
        }

        String getInstalledVersion() {
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String string = pluginJARArray[i].getPath();
                if (!MiscUtilities.getFileName(string).equals(this.jar)) continue;
                EditPlugin editPlugin = pluginJARArray[i].getPlugin();
                if (editPlugin != null) {
                    return jEdit.getProperty("plugin." + editPlugin.getClassName() + ".version");
                }
                return null;
            }
            return null;
        }

        String getInstalledPath() {
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String string = pluginJARArray[i].getPath();
                if (!MiscUtilities.getFileName(string).equals(this.jar)) continue;
                return string;
            }
            return null;
        }

        Branch getCompatibleBranch() {
            for (int i = 0; i < this.branches.size(); ++i) {
                Branch branch = this.branches.get(i);
                if (!branch.canSatisfyDependencies()) continue;
                return branch;
            }
            return null;
        }

        boolean canBeInstalled() {
            Branch branch = this.getCompatibleBranch();
            return branch != null && !branch.obsolete && branch.canSatisfyDependencies();
        }

        void install(Roster roster, String string, boolean bl) {
            String string2 = this.getInstalledPath();
            Branch branch = this.getCompatibleBranch();
            if (branch.obsolete) {
                if (string2 != null) {
                    roster.addRemove(string2);
                }
                return;
            }
            if (string2 != null) {
                string = MiscUtilities.getParentOfPath(string2);
            }
            roster.addInstall(string2, bl ? branch.downloadSource : branch.download, string, bl ? branch.downloadSourceSize : branch.downloadSize);
        }

        public String toString() {
            return this.name;
        }
    }

    static class PluginSet {
        String name;
        String description;
        final List<String> plugins = new ArrayList<String>();

        PluginSet() {
        }

        public String toString() {
            return this.plugins.toString();
        }
    }
}

