/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.gui.FilteredTableModel;
import org.gjt.sp.jedit.gui.GrabKeyDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortcutsOptionPane
extends AbstractOptionPane {
    private JTable keyTable;
    private Vector<ShortcutsModel> models;
    private FilteredTableModel<ShortcutsModel> filteredModel;
    private JComboBox selectModel;
    private List<GrabKeyDialog.KeyBinding> allBindings;
    private JTextField filterTF;

    public ShortcutsOptionPane() {
        super("shortcuts");
    }

    @Override
    protected void _init() {
        this.allBindings = new Vector<GrabKeyDialog.KeyBinding>();
        this.setLayout(new BorderLayout(12, 12));
        this.initModels();
        this.selectModel = new JComboBox<ShortcutsModel>(this.models);
        this.selectModel.addActionListener(new ActionHandler());
        this.selectModel.setToolTipText(jEdit.getProperty("options.shortcuts.select.tooltip"));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(jEdit.getProperty("options.shortcuts.select.label")));
        box.add(Box.createHorizontalStrut(6));
        box.add(this.selectModel);
        this.filterTF = new JTextField(40);
        this.filterTF.setToolTipText(jEdit.getProperty("options.shortcuts.filter.tooltip"));
        this.filterTF.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ShortcutsOptionPane.this.setFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ShortcutsOptionPane.this.setFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ShortcutsOptionPane.this.setFilter();
            }
        });
        JButton jButton = new JButton(jEdit.getProperty("options.shortcuts.clear.label"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutsOptionPane.this.filterTF.setText("");
                ShortcutsOptionPane.this.filterTF.requestFocus();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel(jEdit.getProperty("options.shortcuts.filter.label")));
        jPanel.add(this.filterTF);
        jPanel.add(jButton);
        this.keyTable = new JTable(this.filteredModel);
        this.filteredModel.setTable(this.keyTable);
        this.keyTable.getTableHeader().setReorderingAllowed(false);
        this.keyTable.getTableHeader().addMouseListener(new HeaderMouseHandler());
        this.keyTable.addMouseListener(new TableMouseHandler());
        Dimension dimension = this.keyTable.getPreferredSize();
        dimension.height = Math.min(dimension.height, 200);
        JScrollPane jScrollPane = new JScrollPane(this.keyTable);
        jScrollPane.setPreferredSize(dimension);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", jPanel);
        jPanel2.add("Center", jScrollPane);
        this.add("North", box);
        this.add("Center", jPanel2);
        try {
            this.selectModel.setSelectedIndex(jEdit.getIntegerProperty("options.shortcuts.select.index", 0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    protected void _save() {
        if (this.keyTable.getCellEditor() != null) {
            this.keyTable.getCellEditor().stopCellEditing();
        }
        for (ShortcutsModel shortcutsModel : this.models) {
            shortcutsModel.save();
        }
        Macros.loadMacros();
    }

    private void setFilter() {
        this.filteredModel.setFilter(this.filterTF.getText());
    }

    private void initModels() {
        Vector<GrabKeyDialog.KeyBinding[]> vector = new Vector<GrabKeyDialog.KeyBinding[]>();
        this.models = new Vector();
        ActionSet[] actionSetArray = jEdit.getActionSets();
        for (int i = 0; i < actionSetArray.length; ++i) {
            ActionSet actionSet = actionSetArray[i];
            if (actionSet.getActionCount() == 0) continue;
            String string = actionSet.getLabel();
            if (string == null) {
                Log.log(9, this, "Empty action set: " + actionSet.getPluginJAR());
            }
            ShortcutsModel shortcutsModel = this.createModel(string, actionSet.getActionNames());
            this.models.addElement(shortcutsModel);
            vector.addAll(shortcutsModel.getBindings());
        }
        if (this.models.size() > 1) {
            this.models.addElement(new ShortcutsModel("All", vector));
        }
        Collections.sort(this.models, new StandardUtilities.StringCompare(true));
        ShortcutsModel shortcutsModel = this.models.elementAt(0);
        this.filteredModel = new FilteredTableModel<ShortcutsModel>(shortcutsModel){

            @Override
            public String prepareFilter(String string) {
                return string.toLowerCase();
            }

            @Override
            public boolean passFilter(int n, String string) {
                String string2 = ((ShortcutsModel)this.delegated).getBindingAt((int)n, (int)0).label.toLowerCase();
                return string2.contains(string);
            }
        };
    }

    private ShortcutsModel createModel(String string, String[] stringArray) {
        Vector<GrabKeyDialog.KeyBinding[]> vector = new Vector<GrabKeyDialog.KeyBinding[]>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            EditAction editAction = jEdit.getAction(string2);
            String string3 = editAction.getLabel();
            if (string3 == null) continue;
            string3 = GUIUtilities.prettifyMenuLabel(string3);
            this.addBindings(string2, string3, vector);
        }
        return new ShortcutsModel(string, vector);
    }

    private void addBindings(String string, String string2, List<GrabKeyDialog.KeyBinding[]> list) {
        GrabKeyDialog.KeyBinding[] keyBindingArray = new GrabKeyDialog.KeyBinding[]{this.createBinding(string, string2, jEdit.getProperty(string + ".shortcut")), this.createBinding(string, string2, jEdit.getProperty(string + ".shortcut2"))};
        list.add(keyBindingArray);
    }

    private GrabKeyDialog.KeyBinding createBinding(String string, String string2, String string3) {
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        GrabKeyDialog.KeyBinding keyBinding = new GrabKeyDialog.KeyBinding(string, string2, string3, false);
        this.allBindings.add(keyBinding);
        return keyBinding;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShortcutsModel
    extends AbstractTableModel {
        private List<GrabKeyDialog.KeyBinding[]> bindings;
        private String name;

        ShortcutsModel(String string, List<GrabKeyDialog.KeyBinding[]> list) {
            this.name = string;
            this.bindings = list;
            this.sort(0);
        }

        public List<GrabKeyDialog.KeyBinding[]> getBindings() {
            return this.bindings;
        }

        public void sort(int n) {
            Collections.sort(this.bindings, new KeyCompare(n));
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.bindings.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getBindingAt((int)n, (int)0).label;
                }
                case 1: {
                    return this.getBindingAt((int)n, (int)0).shortcut;
                }
                case 2: {
                    return this.getBindingAt((int)n, (int)1).shortcut;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            this.getBindingAt((int)n, (int)(n2 - 1)).shortcut = (String)object;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return jEdit.getProperty("options.shortcuts.name");
                }
                case 1: {
                    return jEdit.getProperty("options.shortcuts.shortcut1");
                }
                case 2: {
                    return jEdit.getProperty("options.shortcuts.shortcut2");
                }
            }
            return null;
        }

        public void save() {
            for (GrabKeyDialog.KeyBinding[] keyBindingArray : this.bindings) {
                jEdit.setProperty(keyBindingArray[0].name + ".shortcut", keyBindingArray[0].shortcut);
                jEdit.setProperty(keyBindingArray[1].name + ".shortcut2", keyBindingArray[1].shortcut);
            }
        }

        public GrabKeyDialog.KeyBinding getBindingAt(int n, int n2) {
            GrabKeyDialog.KeyBinding[] keyBindingArray = this.bindings.get(n);
            return keyBindingArray[n2];
        }

        public String toString() {
            return this.name;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyCompare
        implements Comparator<GrabKeyDialog.KeyBinding[]> {
            private int col;

            KeyCompare(int n) {
                this.col = n;
            }

            @Override
            public int compare(GrabKeyDialog.KeyBinding[] keyBindingArray, GrabKeyDialog.KeyBinding[] keyBindingArray2) {
                String string;
                String string2;
                String string3 = keyBindingArray[0].label.toLowerCase();
                String string4 = keyBindingArray2[0].label.toLowerCase();
                if (this.col == 0) {
                    return StandardUtilities.compareStrings(string3, string4, true);
                }
                if (this.col == 1) {
                    string2 = keyBindingArray[0].shortcut;
                    string = keyBindingArray2[0].shortcut;
                } else {
                    string2 = keyBindingArray[1].shortcut;
                    string = keyBindingArray2[1].shortcut;
                }
                if (string2 == null && string != null) {
                    return 1;
                }
                if (string == null && string2 != null) {
                    return -1;
                }
                if (string2 == null) {
                    return StandardUtilities.compareStrings(string3, string4, true);
                }
                return StandardUtilities.compareStrings(string2, string, true);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutsModel shortcutsModel = (ShortcutsModel)ShortcutsOptionPane.this.selectModel.getSelectedItem();
            if (ShortcutsOptionPane.this.filteredModel.getDelegated() != shortcutsModel) {
                jEdit.setIntegerProperty("options.shortcuts.select.index", ShortcutsOptionPane.this.selectModel.getSelectedIndex());
                ShortcutsOptionPane.this.filteredModel.setDelegated(shortcutsModel);
                ShortcutsOptionPane.this.setFilter();
            }
        }
    }

    private class TableMouseHandler
    extends MouseAdapter {
        private TableMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            GrabKeyDialog grabKeyDialog;
            int n = ShortcutsOptionPane.this.keyTable.getSelectedRow();
            int n2 = ShortcutsOptionPane.this.keyTable.getSelectedColumn();
            if (n2 != 0 && n != -1 && (grabKeyDialog = new GrabKeyDialog((Dialog)GUIUtilities.getParentDialog(ShortcutsOptionPane.this), ((ShortcutsModel)ShortcutsOptionPane.this.filteredModel.getDelegated()).getBindingAt(ShortcutsOptionPane.this.filteredModel.getTrueRow(n), n2 - 1), (List<GrabKeyDialog.KeyBinding>)ShortcutsOptionPane.this.allBindings, null)).isOK()) {
                ShortcutsOptionPane.this.filteredModel.setValueAt(grabKeyDialog.getShortcut(), n, n2);
            }
        }
    }

    private class HeaderMouseHandler
    extends MouseAdapter {
        private HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            ShortcutsModel shortcutsModel = (ShortcutsModel)ShortcutsOptionPane.this.filteredModel.getDelegated();
            switch (ShortcutsOptionPane.this.keyTable.getTableHeader().columnAtPoint(mouseEvent.getPoint())) {
                case 0: {
                    shortcutsModel.sort(0);
                    break;
                }
                case 1: {
                    shortcutsModel.sort(1);
                    break;
                }
                case 2: {
                    shortcutsModel.sort(2);
                }
            }
            ShortcutsOptionPane.this.setFilter();
        }
    }
}

