/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.JCheckBoxList;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class EncodingsOptionPane
extends AbstractOptionPane {
    private JComboBox defaultEncoding;
    private JCheckBox encodingAutodetect;
    private JTextField encodingDetectors;
    private JTextField fallbackEncodings;
    private JCheckBoxList encodingsList;
    private JButton selectAllButton;
    private JButton selectNoneButton;

    public EncodingsOptionPane() {
        super("encodings");
    }

    protected void _init() {
        String[] stringArray = MiscUtilities.getEncodings(true);
        Arrays.sort(stringArray, new StandardUtilities.StringCompare(true));
        this.defaultEncoding = new JComboBox<String>(stringArray);
        this.defaultEncoding.setEditable(true);
        this.defaultEncoding.setSelectedItem(jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
        this.addComponent(jEdit.getProperty("options.general.encoding"), (Component)this.defaultEncoding);
        this.encodingAutodetect = new JCheckBox(jEdit.getProperty("options.general.encodingAutodetect"));
        this.encodingAutodetect.setSelected(jEdit.getBooleanProperty("buffer.encodingAutodetect"));
        this.addComponent((Component)this.encodingAutodetect, 1);
        this.encodingDetectors = new JTextField(jEdit.getProperty("encodingDetectors", "BOM XML-PI"));
        this.addComponent(jEdit.getProperty("options.general.encodingDetectors"), (Component)this.encodingDetectors);
        this.fallbackEncodings = new JTextField(jEdit.getProperty("fallbackEncodings", ""));
        this.fallbackEncodings.setToolTipText(jEdit.getProperty("options.general.fallbackEncodings.tooltip"));
        this.addComponent(jEdit.getProperty("options.general.fallbackEncodings"), (Component)this.fallbackEncodings);
        stringArray = MiscUtilities.getEncodings(false);
        Arrays.sort(stringArray, new StandardUtilities.StringCompare(true));
        Vector<JCheckBoxList.Entry> vector = new Vector<JCheckBoxList.Entry>();
        boolean bl = false;
        boolean bl2 = false;
        for (String object2 : stringArray) {
            boolean bl3 = !jEdit.getBooleanProperty("encoding.opt-out." + object2, false);
            bl = bl || !bl3;
            bl2 = bl2 || bl3;
            vector.add(new JCheckBoxList.Entry(bl3, object2));
        }
        this.encodingsList = new JCheckBoxList(vector);
        this.encodingsList.getModel().addTableModelListener(new TableModelHandler());
        JScrollPane jScrollPane = new JScrollPane(this.encodingsList);
        jScrollPane.setBorder(new TitledBorder(jEdit.getProperty("options.encodings.selectEncodings")));
        Dimension dimension = this.encodingsList.getPreferredSize();
        dimension.height = Math.min(dimension.height, 200);
        jScrollPane.setPreferredSize(dimension);
        this.addComponent((Component)jScrollPane, 1);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(12));
        ActionHandler actionHandler = new ActionHandler();
        this.selectAllButton = new JButton(jEdit.getProperty("options.encodings.selectAll"));
        this.selectAllButton.addActionListener(actionHandler);
        this.selectAllButton.setEnabled(bl);
        box.add(this.selectAllButton);
        box.add(Box.createHorizontalStrut(12));
        this.selectNoneButton = new JButton(jEdit.getProperty("options.encodings.selectNone"));
        this.selectNoneButton.addActionListener(actionHandler);
        this.selectNoneButton.setEnabled(bl2);
        box.add(this.selectNoneButton);
        box.add(Box.createHorizontalStrut(12));
        this.addComponent(box);
    }

    protected void _save() {
        jEdit.setProperty("buffer.encoding", (String)this.defaultEncoding.getSelectedItem());
        jEdit.setBooleanProperty("buffer.encodingAutodetect", this.encodingAutodetect.isSelected());
        jEdit.setProperty("encodingDetectors", this.encodingDetectors.getText());
        jEdit.setProperty("fallbackEncodings", this.fallbackEncodings.getText());
        for (JCheckBoxList.Entry entry : this.encodingsList.getValues()) {
            if (entry.isChecked()) {
                jEdit.unsetProperty("encoding.opt-out." + entry.getValue());
                continue;
            }
            jEdit.setBooleanProperty("encoding.opt-out." + entry.getValue(), true);
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = EncodingsOptionPane.this.encodingsList.getCheckedValues().length;
            if (n == 0) {
                EncodingsOptionPane.this.selectNoneButton.setEnabled(false);
            } else {
                EncodingsOptionPane.this.selectNoneButton.setEnabled(true);
            }
            if (EncodingsOptionPane.this.encodingsList.getValues().length == n) {
                EncodingsOptionPane.this.selectAllButton.setEnabled(false);
            } else {
                EncodingsOptionPane.this.selectAllButton.setEnabled(true);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == EncodingsOptionPane.this.selectAllButton) {
                EncodingsOptionPane.this.encodingsList.selectAll();
            } else if (object == EncodingsOptionPane.this.selectNoneButton) {
                int n = EncodingsOptionPane.this.encodingsList.getRowCount();
                for (int i = 0; i < n; ++i) {
                    EncodingsOptionPane.this.encodingsList.setValueAt(false, i, 0);
                }
            }
        }
    }
}

