/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class EditingOptionPane
extends AbstractOptionPane {
    private JComboBox defaultMode;
    private JTextField undoCount;
    private JCheckBox resetUndoOnSave;
    private ModeProperties global;
    private ModeProperties[] modeProps;
    private ModeProperties current;
    private Box captionBox;
    private JComboBox mode;
    private JCheckBox useDefaults;
    private JTextField filenameGlob;
    private JTextField firstlineGlob;
    private JTextField noWordSep;
    private JCheckBox camelCasedWords;
    private JComboBox folding;
    private JTextField collapseFolds;
    private JComboBox wrap;
    private JComboBox maxLineLen;
    private JComboBox tabSize;
    private JComboBox indentSize;
    private JCheckBox noTabs;
    private JCheckBox deepIndent;

    public EditingOptionPane() {
        super("editing");
    }

    protected void _init() {
        Mode[] modeArray = jEdit.getModes();
        Arrays.sort(modeArray, new StandardUtilities.StringCompare(true));
        this.global = new ModeProperties();
        this.modeProps = new ModeProperties[modeArray.length];
        String[] stringArray = new String[modeArray.length + 1];
        stringArray[0] = jEdit.getProperty("options.editing.global");
        for (int i = 0; i < modeArray.length; ++i) {
            this.modeProps[i] = new ModeProperties(modeArray[i]);
            stringArray[i + 1] = modeArray[i].getName();
        }
        this.mode = new JComboBox<String>(stringArray);
        this.mode.addActionListener(new ActionHandler());
        this.captionBox = new Box(0);
        this.addComponent(this.captionBox);
        this.addComponent(jEdit.getProperty("options.editing.mode"), (Component)this.mode);
        this.useDefaults = new JCheckBox(jEdit.getProperty("options.editing.useDefaults"));
        this.useDefaults.addActionListener(new ActionHandler());
        this.addComponent(this.useDefaults);
        this.noWordSep = new JTextField();
        this.addComponent(jEdit.getProperty("options.editing.noWordSep"), (Component)this.noWordSep);
        this.camelCasedWords = new JCheckBox(jEdit.getProperty("options.editing.camelCasedWords"));
        this.addComponent(this.camelCasedWords);
        String[] stringArray2 = FoldHandler.getFoldModes();
        this.folding = new JComboBox<String>(stringArray2);
        this.addComponent(jEdit.getProperty("options.editing.folding"), this.folding);
        this.collapseFolds = new JTextField();
        this.addComponent(jEdit.getProperty("options.editing.collapseFolds"), (Component)this.collapseFolds);
        String[] stringArray3 = new String[]{"none", "soft", "hard"};
        this.wrap = new JComboBox<String>(stringArray3);
        this.addComponent(jEdit.getProperty("options.editing.wrap"), this.wrap);
        String[] stringArray4 = new String[]{"0", "72", "76", "80"};
        this.maxLineLen = new JComboBox<String>(stringArray4);
        this.maxLineLen.setToolTipText(jEdit.getProperty("options.editing.maxLineLen.tooltip"));
        this.addComponent(jEdit.getProperty("options.editing.maxLineLen"), (Component)this.maxLineLen);
        this.maxLineLen.setEditable(true);
        String[] stringArray5 = new String[]{"2", "4", "8"};
        this.tabSize = new JComboBox<String>(stringArray5);
        this.addComponent(jEdit.getProperty("options.editing.tabSize"), this.tabSize);
        this.tabSize.setEditable(true);
        this.indentSize = new JComboBox<String>(stringArray5);
        this.addComponent(jEdit.getProperty("options.editing.indentSize"), this.indentSize);
        this.indentSize.setEditable(true);
        this.noTabs = new JCheckBox(jEdit.getProperty("options.editing.noTabs"));
        this.addComponent(this.noTabs);
        this.deepIndent = new JCheckBox(jEdit.getProperty("options.editing.deepIndent"));
        this.addComponent(this.deepIndent);
        this.filenameGlob = new JTextField();
        this.filenameGlob.setToolTipText(jEdit.getProperty("glob.tooltip"));
        this.addComponent(jEdit.getProperty("options.editing.filenameGlob"), (Component)this.filenameGlob);
        this.firstlineGlob = new JTextField();
        this.addComponent(jEdit.getProperty("options.editing.firstlineGlob"), (Component)this.firstlineGlob);
        this.selectMode();
        this.addSeparator();
        this.defaultMode = new JComboBox<Mode>(modeArray);
        this.defaultMode.setSelectedItem(jEdit.getMode(jEdit.getProperty("buffer.defaultMode")));
        this.addComponent(jEdit.getProperty("options.editing.defaultMode"), (Component)this.defaultMode);
        this.undoCount = new JTextField(jEdit.getProperty("buffer.undoCount"));
        this.addComponent(jEdit.getProperty("options.editing.undoCount"), (Component)this.undoCount);
        this.resetUndoOnSave = new JCheckBox(jEdit.getProperty("options.general.resetUndo"));
        this.resetUndoOnSave.setSelected(jEdit.getBooleanProperty("resetUndoOnSave"));
        this.addComponent(this.resetUndoOnSave);
    }

    protected void _save() {
        jEdit.setProperty("buffer.defaultMode", ((Mode)this.defaultMode.getSelectedItem()).getName());
        jEdit.setProperty("buffer.undoCount", this.undoCount.getText());
        jEdit.setBooleanProperty("resetUndoOnSave", this.resetUndoOnSave.isSelected());
        this.saveMode();
        this.global.save();
        for (int i = 0; i < this.modeProps.length; ++i) {
            this.modeProps[i].save();
        }
    }

    private void saveMode() {
        this.current.useDefaults = this.useDefaults.isSelected();
        this.current.filenameGlob = this.filenameGlob.getText();
        this.current.firstlineGlob = this.firstlineGlob.getText();
        this.current.noWordSep = this.noWordSep.getText();
        this.current.camelCasedWords = this.camelCasedWords.isSelected();
        this.current.folding = (String)this.folding.getSelectedItem();
        this.current.collapseFolds = this.collapseFolds.getText();
        this.current.wrap = (String)this.wrap.getSelectedItem();
        this.current.maxLineLen = (String)this.maxLineLen.getSelectedItem();
        this.current.tabSize = (String)this.tabSize.getSelectedItem();
        this.current.indentSize = (String)this.indentSize.getSelectedItem();
        this.current.noTabs = this.noTabs.isSelected();
        this.current.deepIndent = this.deepIndent.isSelected();
    }

    private void selectMode() {
        int n = this.mode.getSelectedIndex();
        this.current = n == 0 ? this.global : this.modeProps[n - 1];
        this.current.edited = true;
        this.current.load();
        this.captionBox.removeAll();
        this.captionBox.add(GUIUtilities.createMultilineLabel(jEdit.getProperty("options.editing.caption-" + (n == 0 ? "0" : "1"))));
        this.useDefaults.setSelected(this.current.useDefaults);
        this.filenameGlob.setText(this.current.filenameGlob);
        this.firstlineGlob.setText(this.current.firstlineGlob);
        this.noWordSep.setText(this.current.noWordSep);
        this.camelCasedWords.setSelected(this.current.camelCasedWords);
        this.folding.setSelectedItem(this.current.folding);
        this.collapseFolds.setText(this.current.collapseFolds);
        this.wrap.setSelectedItem(this.current.wrap);
        this.maxLineLen.setSelectedItem(this.current.maxLineLen);
        this.tabSize.setSelectedItem(this.current.tabSize);
        this.indentSize.setSelectedItem(this.current.indentSize);
        this.noTabs.setSelected(this.current.noTabs);
        this.deepIndent.setSelected(this.current.deepIndent);
        this.updateEnabled();
        this.revalidate();
    }

    private void updateEnabled() {
        boolean bl;
        if (this.current == this.global) {
            bl = true;
            this.useDefaults.setEnabled(false);
            this.filenameGlob.setEnabled(false);
            this.firstlineGlob.setEnabled(false);
        } else {
            bl = !this.modeProps[this.mode.getSelectedIndex() - 1].useDefaults;
            this.useDefaults.setEnabled(true);
            this.filenameGlob.setEnabled(bl);
            this.firstlineGlob.setEnabled(bl);
        }
        this.noWordSep.setEnabled(bl);
        this.camelCasedWords.setEnabled(bl);
        this.folding.setEnabled(bl);
        this.collapseFolds.setEnabled(bl);
        this.wrap.setEnabled(bl);
        this.maxLineLen.setEnabled(bl);
        this.tabSize.setEnabled(bl);
        this.indentSize.setEnabled(bl);
        this.noTabs.setEnabled(bl);
        this.deepIndent.setEnabled(bl);
    }

    private static class ModeProperties {
        Mode mode;
        boolean edited;
        boolean loaded;
        boolean useDefaults;
        String filenameGlob;
        String firstlineGlob;
        String noWordSep;
        boolean camelCasedWords;
        String folding;
        String collapseFolds;
        String wrap;
        String maxLineLen;
        String tabSize;
        String indentSize;
        boolean noTabs;
        boolean deepIndent;

        ModeProperties() {
        }

        ModeProperties(Mode mode) {
            this.mode = mode;
        }

        void load() {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            if (this.mode != null) {
                this.mode.loadIfNecessary();
                this.useDefaults = !jEdit.getBooleanProperty("mode." + this.mode.getName() + ".customSettings");
                this.filenameGlob = (String)this.mode.getProperty("filenameGlob");
                this.firstlineGlob = (String)this.mode.getProperty("firstlineGlob");
                this.noWordSep = (String)this.mode.getProperty("noWordSep");
                this.camelCasedWords = this.mode.getBooleanProperty("camelCasedWords");
                this.folding = this.mode.getProperty("folding").toString();
                this.collapseFolds = this.mode.getProperty("collapseFolds").toString();
                this.wrap = this.mode.getProperty("wrap").toString();
                this.maxLineLen = this.mode.getProperty("maxLineLen").toString();
                this.tabSize = this.mode.getProperty("tabSize").toString();
                this.indentSize = this.mode.getProperty("indentSize").toString();
                this.noTabs = this.mode.getBooleanProperty("noTabs");
                this.deepIndent = this.mode.getBooleanProperty("deepIndent");
            } else {
                this.noWordSep = jEdit.getProperty("buffer.noWordSep");
                this.camelCasedWords = jEdit.getBooleanProperty("buffer.camelCasedWords");
                this.folding = jEdit.getProperty("buffer.folding");
                this.collapseFolds = jEdit.getProperty("buffer.collapseFolds");
                this.wrap = jEdit.getProperty("buffer.wrap");
                this.maxLineLen = jEdit.getProperty("buffer.maxLineLen");
                this.tabSize = jEdit.getProperty("buffer.tabSize");
                this.indentSize = jEdit.getProperty("buffer.indentSize");
                this.noTabs = jEdit.getBooleanProperty("buffer.noTabs");
                this.deepIndent = jEdit.getBooleanProperty("buffer.deepIndent");
            }
        }

        void save() {
            String string;
            if (!this.edited) {
                return;
            }
            if (this.mode != null) {
                string = "mode." + this.mode.getName() + '.';
                jEdit.setBooleanProperty(string + "customSettings", !this.useDefaults);
                String string2 = (String)this.mode.getProperty("filenameGlob");
                String string3 = (String)this.mode.getProperty("firstlineGlob");
                if (this.useDefaults) {
                    jEdit.resetProperty(string + "filenameGlob");
                    jEdit.resetProperty(string + "firstlineGlob");
                    jEdit.resetProperty(string + "noWordSep");
                    jEdit.resetProperty(string + "camelCasedWords");
                    jEdit.resetProperty(string + "folding");
                    jEdit.resetProperty(string + "collapseFolds");
                    jEdit.resetProperty(string + "wrap");
                    jEdit.resetProperty(string + "maxLineLen");
                    jEdit.resetProperty(string + "tabSize");
                    jEdit.resetProperty(string + "indentSize");
                    jEdit.resetProperty(string + "noTabs");
                    jEdit.resetProperty(string + "deepIndent");
                    if (!StandardUtilities.objectsEqual(string2, this.mode.getProperty("filenameGlob")) || !StandardUtilities.objectsEqual(string3, this.mode.getProperty("firstlineGlob"))) {
                        this.mode.init();
                    }
                    return;
                }
                jEdit.setProperty(string + "filenameGlob", this.filenameGlob);
                jEdit.setProperty(string + "firstlineGlob", this.firstlineGlob);
                if (!StandardUtilities.objectsEqual(string2, this.filenameGlob) || !StandardUtilities.objectsEqual(string3, this.firstlineGlob)) {
                    this.mode.init();
                }
            } else {
                string = "buffer.";
            }
            jEdit.setProperty(string + "noWordSep", this.noWordSep);
            jEdit.setBooleanProperty(string + "camelCasedWords", this.camelCasedWords);
            jEdit.setProperty(string + "folding", this.folding);
            jEdit.setProperty(string + "collapseFolds", this.collapseFolds);
            jEdit.setProperty(string + "wrap", this.wrap);
            jEdit.setProperty(string + "maxLineLen", this.maxLineLen);
            jEdit.setProperty(string + "tabSize", this.tabSize);
            jEdit.setProperty(string + "indentSize", this.indentSize);
            jEdit.setBooleanProperty(string + "noTabs", this.noTabs);
            jEdit.setBooleanProperty(string + "deepIndent", this.deepIndent);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == EditingOptionPane.this.mode) {
                EditingOptionPane.this.saveMode();
                EditingOptionPane.this.selectMode();
            } else if (object == EditingOptionPane.this.useDefaults) {
                ((EditingOptionPane)EditingOptionPane.this).modeProps[((EditingOptionPane)EditingOptionPane.this).mode.getSelectedIndex() - 1].useDefaults = EditingOptionPane.this.useDefaults.isSelected();
                EditingOptionPane.this.updateEnabled();
            }
        }
    }
}

