/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.jedit.menu.MenuItemTextComparator;

public class RecentFilesProvider
implements DynamicMenuProvider {
    public boolean updateEveryTime() {
        return false;
    }

    public void update(JMenu jMenuItem) {
        JMenuItem jMenuItem2;
        final View view = GUIUtilities.getView(jMenuItem);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jEdit.openFile(view, actionEvent.getActionCommand());
                view.getStatus().setMessage(null);
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JMenuItem jMenuItem = (JMenuItem)changeEvent.getSource();
                view.getStatus().setMessage(jMenuItem.isArmed() ? jMenuItem.getActionCommand() : null);
            }
        };
        List<BufferHistory.Entry> list = BufferHistory.getHistory();
        if (list.isEmpty()) {
            JMenuItem jMenuItem3 = new JMenuItem(jEdit.getProperty("no-recent-files.label"));
            jMenuItem3.setEnabled(false);
            ((JMenu)jMenuItem).add(jMenuItem3);
            return;
        }
        final ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        final JTextField jTextField = new JTextField();
        jTextField.setToolTipText(jEdit.getProperty("recent-files.textfield.tooltip"));
        ((JMenu)jMenuItem).add(jTextField);
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                String string = jTextField.getText();
                for (JMenuItem jMenuItem : arrayList) {
                    if (string.length() == 0) {
                        jMenuItem.setEnabled(true);
                        continue;
                    }
                    String string2 = jMenuItem.getText();
                    boolean bl = string2.toLowerCase().startsWith(string.toLowerCase());
                    jMenuItem.setEnabled(bl);
                }
            }
        });
        boolean bl = jEdit.getBooleanProperty("sortRecent");
        int n = jEdit.getIntegerProperty("menu.spillover", 20);
        Iterator<BufferHistory.Entry> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().path;
            jMenuItem2 = new JMenuItem(MiscUtilities.getFileName(string));
            jMenuItem2.setActionCommand(string);
            jMenuItem2.addActionListener(actionListener);
            jMenuItem2.addChangeListener(changeListener);
            jMenuItem2.setIcon(FileCellRenderer.fileIcon);
            arrayList.add(jMenuItem2);
            if (bl) continue;
            if (((JMenu)jMenuItem).getMenuComponentCount() >= n && iterator.hasNext()) {
                JMenu jMenu = new JMenu(jEdit.getProperty("common.more"));
                ((JMenu)jMenuItem).add(jMenu);
                jMenuItem = jMenu;
            }
            ((JMenu)jMenuItem).add(jMenuItem2);
        }
        if (bl) {
            Collections.sort(arrayList, new MenuItemTextComparator());
            for (int i = 0; i < arrayList.size(); ++i) {
                if (((JMenu)jMenuItem).getMenuComponentCount() >= n && i != 0) {
                    jMenuItem2 = new JMenu(jEdit.getProperty("common.more"));
                    ((JMenu)jMenuItem).add(jMenuItem2);
                    jMenuItem = jMenuItem2;
                }
                ((JMenu)jMenuItem).add((JMenuItem)arrayList.get(i));
            }
        }
        JMenuItem jMenuItem4 = new JMenuItem(jEdit.getProperty("clear-recent-files.label"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BufferHistory.clear();
            }
        });
        ((JMenu)jMenuItem).addSeparator();
        ((JMenu)jMenuItem).add(jMenuItem4);
    }
}

