/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class MarkersProvider
implements DynamicMenuProvider {
    public boolean updateEveryTime() {
        return true;
    }

    public void update(JMenu jMenu) {
        final View view = GUIUtilities.getView(jMenu);
        Buffer buffer = view.getBuffer();
        Vector<Marker> vector = buffer.getMarkers();
        if (vector.isEmpty()) {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("no-markers.label"));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
            return;
        }
        int n = jEdit.getIntegerProperty("menu.spillover", 20);
        JMenuItem jMenuItem = jMenu;
        for (int i = 0; i < vector.size(); ++i) {
            JMenuItem jMenuItem2;
            final Marker marker = (Marker)vector.get(i);
            int n2 = buffer.getLineOfOffset(marker.getPosition());
            if (jMenuItem.getItemCount() >= n && i != vector.size() - 1) {
                jMenuItem2 = new JMenu(jEdit.getProperty("common.more"));
                jMenuItem.add(jMenuItem2);
                jMenuItem = jMenuItem2;
            }
            jMenuItem2 = new MarkersMenuItem(buffer, n2, marker.getShortcut());
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    view.getTextArea().setCaretPosition(marker.getPosition());
                }
            });
            jMenuItem.add(jMenuItem2);
        }
    }

    static class MarkersMenuItem
    extends JMenuItem {
        private String shortcutProp;
        private char shortcut;
        private static Font acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        private static Color acceleratorForeground;
        private static Color acceleratorSelectionForeground;

        MarkersMenuItem(Buffer buffer, int n, char c) {
            String string = buffer.getLineText(n).trim();
            if (string.length() == 0) {
                string = jEdit.getProperty("markers.blank-line");
            }
            this.setText(n + 1 + ": " + string);
            this.shortcutProp = "goto-marker.shortcut";
            this.shortcut = c;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            String string = this.getShortcut();
            if (string != null) {
                dimension.width += this.getFontMetrics(acceleratorFont).stringWidth(string) + 15;
            }
            return dimension;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            String string = this.getShortcut();
            if (string != null) {
                graphics.setFont(acceleratorFont);
                graphics.setColor(this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                Insets insets = this.getInsets();
                graphics.drawString(string, this.getWidth() - (fontMetrics.stringWidth(string) + insets.right + insets.left + 5), this.getFont().getSize() + (insets.top - 1));
            }
        }

        private String getShortcut() {
            if (this.shortcut == '\u0000') {
                return null;
            }
            String string = jEdit.getProperty(this.shortcutProp);
            if (string == null) {
                return null;
            }
            return string + ' ' + this.shortcut;
        }

        static {
            acceleratorFont = new Font("Monospaced", acceleratorFont.getStyle(), acceleratorFont.getSize());
            acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground");
            acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground");
        }
    }
}

