/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.gjt.sp.jedit.io.EncodingDetector;
import org.gjt.sp.util.Log;

public class XMLEncodingDetector
implements EncodingDetector {
    public String detectEncoding(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[50];
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, 50 - n2)) != -1 && (n2 += n) != 50) {
        }
        return XMLEncodingDetector.getXMLEncoding(new String(byArray, 0, n2, "ASCII"));
    }

    private static String getXMLEncoding(String string) {
        if (!string.startsWith("<?xml")) {
            return null;
        }
        int n = string.indexOf("encoding=");
        if (n == -1 || n + 9 == string.length()) {
            return null;
        }
        char c = string.charAt(n + 9);
        int n2 = string.indexOf(c, n + 10);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n + 10, n2);
        try {
            if (Charset.isSupported(string2)) {
                return string2;
            }
            Log.log(7, XMLEncodingDetector.class, "XML PI specifies unsupported encoding: " + string2);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            Log.log(7, XMLEncodingDetector.class, "XML PI specifies illegal encoding: " + string2, illegalCharsetNameException);
        }
        return null;
    }
}

