/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.swing.Icon;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class VFSFile
implements Serializable {
    public static final int FILE = 0;
    public static final int DIRECTORY = 1;
    public static final int FILESYSTEM = 2;
    public String name;
    public String path;
    public String symlinkPath;
    public String deletePath;
    public int type;
    public long length;
    public boolean hidden;
    public boolean canRead;
    public boolean canWrite;
    protected boolean colorCalculated;
    protected Color color;
    private boolean fetchedAttrs;

    public static int findCompletion(VFSFile[] vFSFileArray, int n, int n2, String string, boolean bl) {
        for (int i = n; i < n2; ++i) {
            String string2;
            VFSFile vFSFile = vFSFileArray[i];
            String string3 = string2 = MiscUtilities.isAbsolutePath(string) ? vFSFile.getPath() : vFSFile.getName();
            if (bl && vFSFile.getType() == 0) continue;
            if (string2.equals(string)) {
                return i;
            }
            if (!string2.regionMatches(true, 0, string, 0, string.length())) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findCompletion(String string, String string2, VFSBrowser vFSBrowser, boolean bl) {
        VFS vFS;
        Log.log(1, VFSFile.class, "findCompletion(" + string + ',' + string2 + ',' + bl + ')');
        if (string2.equals("~")) {
            return System.getProperty("user.home");
        }
        if (string2.equals("-")) {
            return vFSBrowser.getView().getBuffer().getDirectory();
        }
        if (string2.equals("..")) {
            return MiscUtilities.getParentOfPath(string);
        }
        if (MiscUtilities.isAbsolutePath(string2)) {
            if (MiscUtilities.isURL(string2)) {
                return string2;
            }
            string = "roots:";
        }
        if (((vFS = VFSManager.getVFSForPath(string)).getCapabilities() & 0x40) == 0) {
            return null;
        }
        Object object = vFS.createVFSSession(string, vFSBrowser);
        if (object == null) {
            return null;
        }
        try {
            VFSFile[] vFSFileArray = vFS._listFiles(object, string, vFSBrowser);
            int n = VFSFile.findCompletion(vFSFileArray, 0, vFSFileArray.length, string2, bl);
            if (n != -1) {
                String string3 = vFSFileArray[n].path;
                return string3;
            }
        }
        catch (IOException iOException) {
            VFSManager.error(iOException, string, vFSBrowser);
        }
        finally {
            try {
                vFS._endVFSSession(object, vFSBrowser);
            }
            catch (IOException iOException) {
                VFSManager.error(iOException, string, vFSBrowser);
            }
        }
        return null;
    }

    public final Icon getIcon(boolean bl) {
        return this.getIcon(bl, jEdit._getBuffer(this.getSymlinkPath()) != null);
    }

    public Icon getIcon(boolean bl, boolean bl2) {
        return this.getDefaultIcon(bl, bl2);
    }

    public final Icon getDefaultIcon(boolean bl, boolean bl2) {
        if (this.getType() == 1) {
            return bl ? FileCellRenderer.openDirIcon : FileCellRenderer.dirIcon;
        }
        if (this.getType() == 2) {
            return FileCellRenderer.filesystemIcon;
        }
        if (bl2) {
            return FileCellRenderer.openFileIcon;
        }
        return FileCellRenderer.fileIcon;
    }

    public final Icon getDefaultIcon(boolean bl) {
        return this.getDefaultIcon(bl, jEdit._getBuffer(this.getSymlinkPath()) != null);
    }

    public VFSFile() {
    }

    public VFSFile(String string, String string2, String string3, int n, long l, boolean bl) {
        this.name = string;
        this.path = string2;
        this.deletePath = string3;
        this.symlinkPath = string2;
        this.type = n;
        this.length = l;
        this.hidden = bl;
        if (string2 != null) {
            VFS vFS = VFSManager.getVFSForPath(string2);
            this.canRead = (vFS.getCapabilities() & 1) != 0;
            this.canWrite = (vFS.getCapabilities() & 2) != 0;
        }
    }

    public VFS getVFS() {
        return VFSManager.getVFSForPath(this.path);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBinary(Object object) throws IOException {
        InputStream inputStream = this.getVFS()._createInputStream(object, this.getPath(), false, jEdit.getActiveView());
        if (inputStream == null) {
            throw new IOException("Unable to get a Stream for this file " + this);
        }
        try {
            boolean bl = MiscUtilities.isBinary(inputStream);
            return bl;
        }
        finally {
            IOUtilities.closeQuietly(inputStream);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getSymlinkPath() {
        return this.symlinkPath;
    }

    public void setSymlinkPath(String string) {
        this.symlinkPath = string;
    }

    public String getDeletePath() {
        return this.deletePath;
    }

    public void setDeletePath(String string) {
        this.deletePath = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long l) {
        this.length = l;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public boolean isReadable() {
        return this.canRead;
    }

    public void setReadable(boolean bl) {
        this.canRead = bl;
    }

    public boolean isWriteable() {
        return this.canWrite;
    }

    public void setWriteable(boolean bl) {
        this.canWrite = bl;
    }

    public String getExtendedAttribute(String string) {
        if (string.equals("type")) {
            switch (this.getType()) {
                case 0: {
                    return jEdit.getProperty("vfs.browser.type.file");
                }
                case 1: {
                    return jEdit.getProperty("vfs.browser.type.directory");
                }
                case 2: {
                    return jEdit.getProperty("vfs.browser.type.filesystem");
                }
            }
            throw new IllegalArgumentException();
        }
        if (string.equals("status")) {
            if (this.isReadable()) {
                if (this.isWriteable()) {
                    return jEdit.getProperty("vfs.browser.status.rw");
                }
                return jEdit.getProperty("vfs.browser.status.ro");
            }
            if (this.isWriteable()) {
                return jEdit.getProperty("vfs.browser.status.append");
            }
            return jEdit.getProperty("vfs.browser.status.no");
        }
        if (string.equals("size")) {
            if (this.getType() != 0) {
                return null;
            }
            return MiscUtilities.formatFileSize(this.getLength());
        }
        return null;
    }

    public Color getColor() {
        if (!this.colorCalculated) {
            this.colorCalculated = true;
            this.color = VFS.getDefaultColorFor(this.name);
        }
        return this.color;
    }

    public String toString() {
        return this.name;
    }

    protected boolean fetchedAttrs() {
        return this.fetchedAttrs;
    }

    protected void fetchAttrs() {
        this.fetchedAttrs = true;
    }
}

