/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gjt.sp.jedit.io.EncodingDetector;
import org.gjt.sp.jedit.io.EncodingServer;

public class RegexEncodingDetector
implements EncodingDetector {
    public static final String VALID_ENCODING_PATTERN = "\\p{Alnum}[\\p{Alnum}\\-.:_]*";
    private final Pattern pattern;
    private final String replacement;

    public RegexEncodingDetector(String string, String string2) {
        this.pattern = Pattern.compile(string);
        this.replacement = string2;
    }

    public String detectEncoding(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        int n = inputStreamReader.read(cArray, 0, 1024);
        if (n > 0) {
            Matcher matcher = this.pattern.matcher(CharBuffer.wrap(cArray, 0, n));
            while (matcher.find()) {
                String string = RegexEncodingDetector.extractReplacement(matcher, this.replacement);
                if (!EncodingServer.hasEncoding(string)) continue;
                return string;
            }
        }
        return null;
    }

    private static String extractReplacement(Matcher matcher, String string) {
        int n = matcher.start();
        int n2 = matcher.end();
        int n3 = n2 - n;
        StringBuffer stringBuffer = new StringBuffer(n + n3 * 2);
        matcher.appendReplacement(stringBuffer, string);
        return stringBuffer.substring(n);
    }
}

