/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.util.regex.Pattern;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSFileFilter;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class GlobVFSFileFilter
implements VFSFileFilter {
    private String glob;
    private Pattern pattern;

    public GlobVFSFileFilter(String string) {
        this.glob = string;
    }

    public boolean accept(VFSFile vFSFile) {
        if (vFSFile.getType() == 1 || vFSFile.getType() == 2) {
            return true;
        }
        return this.accept(vFSFile.getName());
    }

    public boolean accept(String string) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(StandardUtilities.globToRE(this.glob), 2);
        }
        return this.pattern.matcher(string).matches();
    }

    public String getDescription() {
        return jEdit.getProperty("vfs.browser.file_filter.glob");
    }

    public String toString() {
        return this.glob;
    }

    public void setGlob(String string) {
        this.glob = string;
        this.pattern = null;
    }

    public String getGlob() {
        return this.glob;
    }
}

